/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.ObjectRegistry;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.MessagingInterface;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

abstract class InProcessMessagingInterface
extends MessagingInterface {
    private static final boolean IS_PRINTING_NON_SERIALIZABLE_MESSAGES = Boolean.parseBoolean(System.getProperty("nativeswing.interface.inprocess.printnonserializablemessages"));
    private volatile InProcessMessagingInterface mirrorMessagingInterface;
    private List<Message> sentMessageList = new LinkedList<Message>();

    public InProcessMessagingInterface(boolean isNativeSide) {
        super(isNativeSide);
    }

    public void destroy() {
        ObjectRegistry controlRegistry = NativeComponent.getControlRegistry();
        int[] nArray = controlRegistry.getInstanceIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int instanceID = nArray[n2];
            final Control control = (Control)controlRegistry.get(instanceID);
            controlRegistry.remove(instanceID);
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    control.getShell().dispose();
                }
            });
            ++n2;
        }
        this.setAlive(false);
    }

    protected void openChannel() {
    }

    protected void closeChannel() {
    }

    protected void setMirrorMessagingInterface(InProcessMessagingInterface mirrorMessagingInterface) {
        this.mirrorMessagingInterface = mirrorMessagingInterface;
    }

    public InProcessMessagingInterface getMirrorMessagingInterface() {
        return this.mirrorMessagingInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Message getNextMessage() {
        List<Message> list = this.sentMessageList;
        synchronized (list) {
            while (true) {
                if (!this.sentMessageList.isEmpty()) {
                    return this.sentMessageList.remove(0);
                }
                try {
                    this.sentMessageList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected Message readMessageFromChannel() throws IOException, ClassNotFoundException {
        return this.mirrorMessagingInterface.getNextMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessageToChannel(Message message) throws IOException {
        if (IS_PRINTING_NON_SERIALIZABLE_MESSAGES && !message.getClass().getName().equals("chrriis.dj.nativeswing.swtimpl.NativeComponent$CMN_createControl")) {
            ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());
            try {
                oos.writeObject(message);
            }
            catch (Exception e) {
                System.err.println("Non-serializable message: " + message);
            }
            oos.close();
        }
        List<Message> list = this.sentMessageList;
        synchronized (list) {
            this.sentMessageList.add(message);
            this.sentMessageList.notifyAll();
        }
    }

    static class SWTInProcessMessagingInterface
    extends InProcessMessagingInterface {
        private Display display;

        public SWTInProcessMessagingInterface(Display display) {
            super(true);
            this.display = display;
            this.setMirrorMessagingInterface(new SwingInProcessMessagingInterface(this));
            this.initialize(false);
        }

        protected void asyncUIExec(Runnable runnable) {
            this.display.asyncExec(runnable);
        }

        public boolean isUIThread() {
            return this.display.getThread() == Thread.currentThread();
        }
    }

    static class SwingInProcessMessagingInterface
    extends InProcessMessagingInterface {
        public SwingInProcessMessagingInterface(InProcessMessagingInterface mirrorMessagingInterface) {
            super(false);
            this.setMirrorMessagingInterface(mirrorMessagingInterface);
            this.initialize(false);
        }

        protected void asyncUIExec(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }

        public boolean isUIThread() {
            return SwingUtilities.isEventDispatchThread();
        }
    }
}

