/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import org.eclipse.swt.widgets.Control;

public abstract class ControlCommandMessage
extends CommandMessage {
    private int componentID;
    private transient Boolean isTargetNativeSide;

    int getComponentID() {
        return this.componentID;
    }

    public void setControl(Control control) {
        this.componentID = (Integer)control.getData("NS_ID");
        this.setTargetNativeSide(false);
    }

    public void setNativeComponent(NativeComponent nativeComponent) {
        this.componentID = nativeComponent.getComponentID();
        this.setTargetNativeSide(true);
    }

    private boolean isTargetNativeSide() {
        if (this.isTargetNativeSide == null) {
            throw new IllegalStateException("The target must be specified!");
        }
        return this.isTargetNativeSide;
    }

    private void setTargetNativeSide(boolean isTargetNativeSide) {
        this.isTargetNativeSide = isTargetNativeSide;
    }

    public Control getControl() {
        return (Control)NativeComponent.getControlRegistry().get(this.componentID);
    }

    public NativeComponent getNativeComponent() {
        return (NativeComponent)NativeComponent.getNativeComponentRegistry().get(this.componentID);
    }

    public void asyncExec(NativeComponent nativeComponent, Object ... args) {
        this.setNativeComponent(nativeComponent);
        this.asyncExec(args);
    }

    public void asyncExec(Control control, Object ... args) {
        this.setControl(control);
        this.asyncExec(args);
    }

    public Object syncExec(NativeComponent nativeComponent, Object ... args) {
        this.setNativeComponent(nativeComponent);
        return this.syncExec(args);
    }

    public Object syncExec(Control control, Object ... args) {
        this.setControl(control);
        return this.syncExec(args);
    }

    private Object syncExec(Object ... args) {
        return this.syncExec(this.isTargetNativeSide(), args);
    }

    public Object syncExec(boolean isTargetNativeSide, Object ... args) {
        this.checkComponentID();
        return super.syncExec(isTargetNativeSide, args);
    }

    private void asyncExec(Object ... args) {
        super.asyncExec(this.isTargetNativeSide(), args);
    }

    public void asyncExec(boolean isTargetNativeSide, Object ... args) {
        this.checkComponentID();
        super.asyncExec(isTargetNativeSide, args);
    }

    private void checkComponentID() {
        if (this.componentID == 0) {
            throw new IllegalStateException("The component was not specified!");
        }
    }

    protected boolean isValid() {
        if (NativeInterface.isInProcess()) {
            return this.getControl() != null || this.getNativeComponent() != null;
        }
        if (NativeInterface.OutProcess.isNativeSide()) {
            return this.getControl() != null;
        }
        return this.getNativeComponent() != null;
    }
}

