/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.DesignMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.empty.EmptyTileFactory;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMapViewer
extends JXPanel
implements DesignMode {
    private final boolean isNegativeYAllowed = true;
    private int zoom = 1;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean recenterOnClickEnabled = true;
    private Painter overlay;
    private boolean designTime;
    private float zoomScale = 1.0f;
    private Image loadingImage;
    private boolean restrictOutsidePanning = false;
    private TileLoadListener tileLoadListener = new TileLoadListener();

    public JXMapViewer() {
        this.factory = new EmptyTileFactory();
        PanMouseInputListener mia = new PanMouseInputListener();
        this.setRecenterOnClickEnabled(false);
        this.addMouseListener(mia);
        this.addMouseMotionListener(mia);
        this.addMouseWheelListener(new ZoomMouseWheelListener());
        this.addKeyListener(new PanKeyListener());
        try {
            URL url = this.getClass().getResource("mapviewer/resources/loading.png");
            this.setLoadingImage(ImageIO.read(url));
        }
        catch (Throwable ex) {
            System.out.println("could not load 'loading.png'");
            BufferedImage img = new BufferedImage(16, 16, 2);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.black);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            this.setLoadingImage(img);
        }
        this.setBackgroundPainter((Painter)new AbstractPainter<JXPanel>(){

            protected void doPaint(Graphics2D g, JXPanel component, int width, int height) {
                JXMapViewer.this.doPaintComponent(g);
            }
        });
    }

    private void doPaintComponent(Graphics g) {
        if (!this.isDesignTime()) {
            int zoom = this.getZoom();
            Rectangle viewportBounds = this.getViewportBounds();
            this.drawMapTiles(g, zoom, viewportBounds);
            this.drawOverlays(zoom, g, viewportBounds);
        }
        super.paintBorder(g);
    }

    @Override
    public void setDesignTime(boolean b) {
        this.designTime = b;
    }

    @Override
    public boolean isDesignTime() {
        return this.designTime;
    }

    private static void p(String s) {
        System.out.println(s);
    }

    protected void drawMapTiles(Graphics g, int zoom, Rectangle viewportBounds) {
        int size = this.getTileFactory().getTileSize(zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        int numWide = viewportBounds.width / size + 2;
        int numHigh = viewportBounds.height / size + 2;
        TileFactoryInfo info = this.getTileFactory().getInfo();
        int tpx = (int)Math.floor(viewportBounds.getX() / (double)info.getTileSize(0));
        int tpy = (int)Math.floor(viewportBounds.getY() / (double)info.getTileSize(0));
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                if (!g.getClipBounds().intersects(new Rectangle(itpx * size - viewportBounds.x, itpy * size - viewportBounds.y, size, size))) continue;
                Tile tile = this.getTileFactory().getTile(itpx, itpy, zoom);
                tile.addUniquePropertyChangeListener("loaded", this.tileLoadListener);
                int ox = itpx * this.getTileFactory().getTileSize(zoom) - viewportBounds.x;
                int oy = itpy * this.getTileFactory().getTileSize(zoom) - viewportBounds.y;
                if (this.isTileOnMap(itpx, itpy, mapSize)) {
                    if (this.isOpaque()) {
                        g.setColor(this.getBackground());
                        g.fillRect(ox, oy, size, size);
                    }
                } else if (tile.isLoaded()) {
                    g.drawImage(tile.getImage(), ox, oy, null);
                } else {
                    int imageX = (this.getTileFactory().getTileSize(zoom) - this.getLoadingImage().getWidth(null)) / 2;
                    int imageY = (this.getTileFactory().getTileSize(zoom) - this.getLoadingImage().getHeight(null)) / 2;
                    g.setColor(Color.GRAY);
                    g.fillRect(ox, oy, size, size);
                    g.drawImage(this.getLoadingImage(), ox + imageX, oy + imageY, null);
                }
                if (!this.isDrawTileBorders()) continue;
                g.setColor(Color.black);
                g.drawRect(ox, oy, size, size);
                g.drawRect(ox + size / 2 - 5, oy + size / 2 - 5, 10, 10);
                g.setColor(Color.white);
                g.drawRect(ox + 1, oy + 1, size, size);
                String text = itpx + ", " + itpy + ", " + this.getZoom();
                g.setColor(Color.BLACK);
                g.drawString(text, ox + 10, oy + 30);
                g.drawString(text, ox + 10 + 2, oy + 30 + 2);
                g.setColor(Color.WHITE);
                g.drawString(text, ox + 10 + 1, oy + 30 + 1);
            }
        }
    }

    private void drawOverlays(int zoom, Graphics g, Rectangle viewportBounds) {
        if (this.overlay != null) {
            this.overlay.paint((Graphics2D)g, (Object)this, this.getWidth(), this.getHeight());
        }
    }

    private boolean isTileOnMap(int x, int y, Dimension mapSize) {
        return (double)y >= mapSize.getHeight();
    }

    public void setOverlayPainter(Painter overlay) {
        Painter old = this.getOverlayPainter();
        this.overlay = overlay;
        this.firePropertyChange("mapOverlay", old, this.getOverlayPainter());
        this.repaint();
    }

    public Painter getOverlayPainter() {
        return this.overlay;
    }

    public Rectangle getViewportBounds() {
        return this.calculateViewportBounds(this.getCenter());
    }

    private Rectangle calculateViewportBounds(Point2D center) {
        Insets insets = this.getInsets();
        int viewportWidth = this.getWidth() - insets.left - insets.right;
        int viewportHeight = this.getHeight() - insets.top - insets.bottom;
        double viewportX = center.getX() - (double)(viewportWidth / 2);
        double viewportY = center.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    public void setRecenterOnClickEnabled(boolean b) {
        boolean old = this.isRecenterOnClickEnabled();
        this.recenterOnClickEnabled = b;
        this.firePropertyChange("recenterOnClickEnabled", old, this.isRecenterOnClickEnabled());
    }

    public boolean isRecenterOnClickEnabled() {
        return this.recenterOnClickEnabled;
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoom) {
            return;
        }
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (zoom < info.getMinimumZoomLevel() || zoom > info.getMaximumZoomLevel())) {
            return;
        }
        int oldzoom = this.zoom;
        Point2D oldCenter = this.getCenter();
        Dimension oldMapSize = this.getTileFactory().getMapSize(oldzoom);
        this.zoom = zoom;
        this.firePropertyChange("zoom", oldzoom, zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        this.setCenter(new Point2D.Double(oldCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), oldCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())));
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    public void setAddressLocation(GeoPosition addressLocation) {
        GeoPosition old = this.getAddressLocation();
        this.addressLocation = addressLocation;
        this.setCenter(this.getTileFactory().geoToPixel(addressLocation, this.getZoom()));
        this.firePropertyChange("addressLocation", old, this.getAddressLocation());
        this.repaint();
    }

    public void recenterToAddressLocation() {
        this.setCenter(this.getTileFactory().geoToPixel(this.getAddressLocation(), this.getZoom()));
        this.repaint();
    }

    public boolean isDrawTileBorders() {
        return this.drawTileBorders;
    }

    public void setDrawTileBorders(boolean drawTileBorders) {
        boolean old = this.isDrawTileBorders();
        this.drawTileBorders = drawTileBorders;
        this.firePropertyChange("drawTileBorders", old, this.isDrawTileBorders());
        this.repaint();
    }

    public boolean isPanEnabled() {
        return this.panEnabled;
    }

    public void setPanEnabled(boolean panEnabled) {
        boolean old = this.isPanEnabled();
        this.panEnabled = panEnabled;
        this.firePropertyChange("panEnabled", old, this.isPanEnabled());
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        boolean old = this.isZoomEnabled();
        this.zoomEnabled = zoomEnabled;
        this.firePropertyChange("zoomEnabled", old, this.isZoomEnabled());
    }

    public void setCenterPosition(GeoPosition geoPosition) {
        GeoPosition oldVal = this.getCenterPosition();
        this.setCenter(this.getTileFactory().geoToPixel(geoPosition, this.zoom));
        this.repaint();
        GeoPosition newVal = this.getCenterPosition();
        this.firePropertyChange("centerPosition", oldVal, newVal);
    }

    public GeoPosition getCenterPosition() {
        return this.getTileFactory().pixelToGeo(this.getCenter(), this.zoom);
    }

    public TileFactory getTileFactory() {
        return this.factory;
    }

    public void setTileFactory(TileFactory factory) {
        this.factory = factory;
        this.setZoom(factory.getInfo().getDefaultZoomLevel());
    }

    public Image getLoadingImage() {
        return this.loadingImage;
    }

    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setCenter(Point2D center) {
        Point2D old = this.getCenter();
        if (this.isRestrictOutsidePanning()) {
            double centerY;
            Insets insets = this.getInsets();
            int viewportHeight = this.getHeight() - insets.top - insets.bottom;
            Rectangle newVP = this.calculateViewportBounds(center);
            if (newVP.getY() < 0.0) {
                double centerY2 = viewportHeight / 2;
                center = new Point2D.Double(center.getX(), centerY2);
            }
            Dimension mapSize = this.getTileFactory().getMapSize(this.getZoom());
            int mapHeight = (int)mapSize.getHeight() * this.getTileFactory().getTileSize(this.getZoom());
            if (newVP.getY() + newVP.getHeight() > (double)mapHeight) {
                centerY = mapHeight - viewportHeight / 2;
                center = new Point2D.Double(center.getX(), centerY);
            }
            if ((double)mapHeight < newVP.getHeight()) {
                centerY = mapHeight / 2;
                center = new Point2D.Double(center.getX(), centerY);
            }
        }
        old = new Point(5, 6);
        GeoPosition oldGP = this.getCenterPosition();
        this.center = center;
        this.firePropertyChange("center", old, this.center);
        this.firePropertyChange("centerPosition", oldGP, this.getCenterPosition());
        this.repaint();
    }

    public void calculateZoomFrom(Set<GeoPosition> positions) {
        if (positions.size() < 2) {
            return;
        }
        int zoom = this.getZoom();
        Rectangle2D rect = this.generateBoundingRect(positions, zoom);
        int count = 0;
        while (!this.getViewportBounds().contains(rect)) {
            Point2D.Double center = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
            GeoPosition px = this.getTileFactory().pixelToGeo(center, zoom);
            this.setCenterPosition(px);
            if (++count > 30 || this.getViewportBounds().contains(rect) || ++zoom > 15) break;
            this.setZoom(zoom);
            rect = this.generateBoundingRect(positions, zoom);
        }
    }

    private Rectangle2D generateBoundingRect(Set<GeoPosition> positions, int zoom) {
        Point2D point1 = this.getTileFactory().geoToPixel(positions.iterator().next(), zoom);
        Rectangle2D.Double rect = new Rectangle2D.Double(point1.getX(), point1.getY(), 0.0, 0.0);
        for (GeoPosition pos : positions) {
            Point2D point = this.getTileFactory().geoToPixel(pos, zoom);
            rect.add(point);
        }
        return rect;
    }

    public boolean isRestrictOutsidePanning() {
        return this.restrictOutsidePanning;
    }

    public void setRestrictOutsidePanning(boolean restrictOutsidePanning) {
        this.restrictOutsidePanning = restrictOutsidePanning;
    }

    public Point2D convertGeoPositionToPoint(GeoPosition pos) {
        Point2D pt = this.getTileFactory().geoToPixel(pos, this.getZoom());
        Rectangle bounds = this.getViewportBounds();
        return new Point2D.Double(pt.getX() - bounds.getX(), pt.getY() - bounds.getY());
    }

    public GeoPosition convertPointToGeoPosition(Point2D pt) {
        Rectangle bounds = this.getViewportBounds();
        Point2D.Double pt2 = new Point2D.Double(pt.getX() + bounds.getX(), pt.getY() + bounds.getY());
        GeoPosition pos = this.getTileFactory().pixelToGeo(pt2, this.getZoom());
        return pos;
    }

    private class ZoomMouseWheelListener
    implements MouseWheelListener {
        private ZoomMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JXMapViewer.this.isZoomEnabled()) {
                JXMapViewer.this.setZoom(JXMapViewer.this.getZoom() + e.getWheelRotation());
            }
        }
    }

    private class PanMouseInputListener
    implements MouseInputListener {
        Point prev;

        private PanMouseInputListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (JXMapViewer.this.isRecenterOnClickEnabled() && (SwingUtilities.isMiddleMouseButton(evt) || SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2)) {
                this.recenterMap(evt);
            } else {
                this.prev = evt.getPoint();
            }
        }

        private void recenterMap(MouseEvent evt) {
            Rectangle bounds = JXMapViewer.this.getViewportBounds();
            double x = bounds.getX() + (double)evt.getX();
            double y = bounds.getY() + (double)evt.getY();
            JXMapViewer.this.setCenter(new Point2D.Double(x, y));
            JXMapViewer.this.repaint();
        }

        public void mouseDragged(MouseEvent evt) {
            if (JXMapViewer.this.isPanEnabled()) {
                int maxHeight;
                Point current = evt.getPoint();
                double x = JXMapViewer.this.getCenter().getX() - (double)(current.x - this.prev.x);
                double y = JXMapViewer.this.getCenter().getY() - (double)(current.y - this.prev.y);
                if (y > (double)(maxHeight = (int)(JXMapViewer.this.getTileFactory().getMapSize(JXMapViewer.this.getZoom()).getHeight() * (double)JXMapViewer.this.getTileFactory().getTileSize(JXMapViewer.this.getZoom())))) {
                    y = maxHeight;
                }
                this.prev = current;
                JXMapViewer.this.setCenter(new Point2D.Double(x, y));
                JXMapViewer.this.repaint();
                JXMapViewer.this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        public void mouseReleased(MouseEvent evt) {
            this.prev = null;
            JXMapViewer.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseMoved(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JXMapViewer.this.requestFocusInWindow();
                }
            });
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class PanKeyListener
    extends KeyAdapter {
        private static final int OFFSET = 10;

        private PanKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int delta_x = 0;
            int delta_y = 0;
            switch (e.getKeyCode()) {
                case 37: {
                    delta_x = -10;
                    break;
                }
                case 39: {
                    delta_x = 10;
                    break;
                }
                case 38: {
                    delta_y = -10;
                    break;
                }
                case 40: {
                    delta_y = 10;
                }
            }
            if (delta_x != 0 || delta_y != 0) {
                Rectangle bounds = JXMapViewer.this.getViewportBounds();
                double x = bounds.getCenterX() + (double)delta_x;
                double y = bounds.getCenterY() + (double)delta_y;
                JXMapViewer.this.setCenter(new Point2D.Double(x, y));
                JXMapViewer.this.repaint();
            }
        }
    }

    private final class TileLoadListener
    implements PropertyChangeListener {
        private TileLoadListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Tile t;
            if ("loaded".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && (t = (Tile)((Object)evt.getSource())).getZoom() == JXMapViewer.this.getZoom()) {
                JXMapViewer.this.repaint();
            }
        }
    }
}

