/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.dj.nativeswing.BackBufferManager;
import chrriis.dj.nativeswing.EmbeddableComponent;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentProxyFinalizationPanel;
import chrriis.dj.nativeswing.NativeComponentProxyPanel;
import chrriis.dj.nativeswing.NativeSwing;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeComponentWrapper {
    private static final boolean IS_DEBUGGING_OPTIONS = Boolean.parseBoolean(System.getProperty("nativeswing.components.debug.printoptions"));
    private boolean isRegistered;
    private Component nativeComponent;
    private Reference<NativeComponentProxy> nativeComponentProxy;
    private BackBufferManager backBufferManager;

    private void checkParent() {
        Container parent = this.nativeComponent.getParent();
        if (parent != null && !(parent instanceof NativeComponentHolder)) {
            throw new IllegalStateException("The native component cannot be added directly! Use the createEmbeddableComponent() method to get a component that can be added.");
        }
        if (parent != null && SwingUtilities.getWindowAncestor(parent) != null) {
            if (!this.isRegistered) {
                NativeSwing.addNativeComponentWrapper(this);
                this.isRegistered = true;
            }
        } else if (this.isRegistered && NativeSwing.removeNativeComponentWrapper(this)) {
            this.isRegistered = false;
        }
    }

    public NativeComponentWrapper(Component nativeComponent) {
        this.nativeComponent = nativeComponent;
        this.checkParent();
        nativeComponent.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if ((changeFlags & 1L) != 0L) {
                    NativeComponentWrapper.this.checkParent();
                }
            }
        });
    }

    Component getNativeComponent() {
        return this.nativeComponent;
    }

    protected void paintNativeComponent(BufferedImage image, Rectangle[] rectangles) {
    }

    void setNativeComponentProxy(NativeComponentProxy nativeComponentProxy) {
        this.nativeComponentProxy = nativeComponentProxy == null ? null : new WeakReference<NativeComponentProxy>(nativeComponentProxy);
    }

    NativeComponentProxy getNativeComponentProxy() {
        return this.nativeComponentProxy == null ? null : this.nativeComponentProxy.get();
    }

    protected void setNativeComponentEnabled(boolean isEnabled) {
    }

    protected String getComponentDescription() {
        return String.valueOf(this.getClass().getName()) + "[" + this.hashCode() + "]";
    }

    public Component createEmbeddableComponent(NSOption ... options) {
        return this.createEmbeddableComponent(NSOption.createOptionMap(options));
    }

    public Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        Boolean componentHierarchyProxying;
        if (IS_DEBUGGING_OPTIONS) {
            StringBuilder sb = new StringBuilder();
            sb.append("NativeComponent ").append(this.getComponentDescription()).append(" options: ");
            boolean isFirst = true;
            for (Object key : optionMap.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                Object value = optionMap.get(key);
                if (value instanceof NSOption) {
                    sb.append(value);
                    continue;
                }
                sb.append(key).append('=').append(value);
            }
            if (isFirst) {
                sb.append("<none>");
            }
            System.err.println(sb);
        }
        String isActive = System.getProperty("nativeswing.integration.active");
        if (optionMap.get("Deactivate Native Integration") != null || isActive != null && !Boolean.parseBoolean(isActive)) {
            this.isRegistered = true;
            return new SimpleNativeComponentHolder(this);
        }
        Boolean deferredDestruction = optionMap.get("Destroy On Finalization") != null ? Boolean.TRUE : null;
        Boolean bl = componentHierarchyProxying = optionMap.get("Proxy Component Hierarchy") != null ? Boolean.TRUE : null;
        if (Boolean.valueOf(System.getProperty("nativeswing.integration.useDefaultClipping")).booleanValue()) {
            if (deferredDestruction != null && componentHierarchyProxying == null) {
                componentHierarchyProxying = true;
            }
            if (Boolean.TRUE.equals(componentHierarchyProxying)) {
                return new NativeComponentProxyFinalizationPanel(this);
            }
            return new SimpleNativeComponentHolder(this);
        }
        Boolean visibilityConstraint = optionMap.get("Constrain Visibility") != null ? Boolean.TRUE : null;
        boolean isJNAPresent = NativeComponentWrapper.isJNAPresent();
        if (visibilityConstraint == null && isJNAPresent && componentHierarchyProxying != null) {
            visibilityConstraint = true;
        }
        if (visibilityConstraint != null && !isJNAPresent) {
            throw new IllegalStateException("The JNA libraries are required to use the visibility constraints!");
        }
        if (deferredDestruction != null && componentHierarchyProxying == null) {
            componentHierarchyProxying = true;
        }
        if (componentHierarchyProxying != null) {
            return new NativeComponentProxyPanel(this, Boolean.TRUE.equals(visibilityConstraint), Boolean.TRUE.equals(deferredDestruction), Boolean.TRUE.equals(componentHierarchyProxying));
        }
        if (visibilityConstraint == null) {
            return new SimpleNativeComponentHolder(this);
        }
        return new NativeComponentProxyPanel(this, Boolean.TRUE.equals(visibilityConstraint), Boolean.TRUE.equals(deferredDestruction), Boolean.TRUE.equals(componentHierarchyProxying));
    }

    private static boolean isJNAPresent() {
        try {
            Class.forName("com.sun.jna.examples.WindowUtils");
            Class.forName("com.sun.jna.Platform");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void disposeNativeComponent() {
        NativeComponentProxy nativeComponentProxy = this.getNativeComponentProxy();
        if (nativeComponentProxy != null) {
            nativeComponentProxy.dispose();
        }
    }

    BackBufferManager getBackBufferManager() {
        NativeComponentProxy nativeComponentProxy = this.getNativeComponentProxy();
        if (nativeComponentProxy != null) {
            return nativeComponentProxy.getBackBufferManager();
        }
        if (this.backBufferManager == null) {
            this.backBufferManager = new BackBufferManager(this, this.getNativeComponent());
        }
        return this.backBufferManager;
    }

    public void paintBackBuffer(Graphics g) {
        if (this.backBufferManager != null) {
            this.backBufferManager.paintBackBuffer(g);
        }
    }

    public void createBackBuffer() {
        this.getBackBufferManager().createBackBuffer();
    }

    public void updateBackBufferOnVisibleTranslucentAreas() {
        this.getBackBufferManager().updateBackBufferOnVisibleTranslucentAreas();
    }

    public void updateBackBuffer(Rectangle[] rectangles) {
        this.getBackBufferManager().updateBackBuffer(rectangles);
    }

    public void destroyBackBuffer() {
        this.getBackBufferManager().destroyBackBuffer();
    }

    public void transferFocus(boolean isForward) {
        Component c = this.getNativeComponentProxy();
        if (c == null) {
            c = this.getNativeComponent();
        }
        if (isForward) {
            c.transferFocus();
        } else {
            c.transferFocusBackward();
        }
    }

    static interface NativeComponentHolder {
    }

    static class SimpleNativeComponentHolder
    extends EmbeddableComponent
    implements NativeComponentHolder {
        private NativeComponentWrapper nativeComponent;

        public SimpleNativeComponentHolder(NativeComponentWrapper nativeComponent) {
            this.nativeComponent = nativeComponent;
            this.add(nativeComponent.getNativeComponent());
        }

        protected void printComponent(Graphics g) {
            this.nativeComponent.getNativeComponent().print(g);
        }
    }
}

