/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class WebServer {
    private int port;
    private volatile boolean isRunning;
    private volatile ServerSocket serverSocket;
    private volatile int instanceID;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);
    private static WebServer webServer;
    private static Object LOCK;
    private static String hostAddress;

    static {
        LOCK = new Object();
        String hostAddress = Utils.getLocalHostAddress();
        if (hostAddress == null) {
            hostAddress = "127.0.0.1";
        }
        WebServer.hostAddress = hostAddress;
    }

    public WebServer() {
        this(0);
    }

    public WebServer(int port) {
        this.port = port;
    }

    public void stop() {
        this.isRunning = false;
        if (this.serverSocket != null) {
            ServerSocket serverSocket = this.serverSocket;
            this.serverSocket = null;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() throws IOException {
        this.start(true);
    }

    public void start(boolean isDaemon) throws IOException {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.instanceID = ObjectRegistry.getInstance().add(this);
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(WebServer.getHostAddress()), this.port));
        this.port = this.serverSocket.getLocalPort();
        if (Boolean.parseBoolean(System.getProperty("nativeswing.webserver.debug.printport"))) {
            System.err.println("Web Server port: " + this.port);
        }
        Thread listenerThread = new Thread("WebServer"){

            public void run() {
                while (WebServer.this.isRunning) {
                    try {
                        Socket socket = WebServer.this.serverSocket.accept();
                        socket.setSoTimeout(10000);
                        try {
                            WebServerConnectionThread.semaphore.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        WebServerConnectionThread webServerConnectionThread = new WebServerConnectionThread(socket);
                        webServerConnectionThread.start();
                    }
                    catch (IOException e) {
                        if (WebServer.this.serverSocket == null) continue;
                        e.printStackTrace();
                    }
                }
                WebServer.this.serverSocket = null;
                ObjectRegistry.getInstance().remove(WebServer.this.instanceID);
            }
        };
        listenerThread.setDaemon(isDaemon);
        listenerThread.start();
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPrefix() {
        return "http://" + hostAddress + ":" + this.port;
    }

    public String getDynamicContentURL(String className, String parameter) {
        return String.valueOf(this.getURLPrefix()) + "/class/" + this.instanceID + "/" + className + "/" + Utils.encodeURL(parameter);
    }

    public String getDynamicContentURL(String className, String codebase, String parameter) {
        return String.valueOf(this.getURLPrefix()) + "/class/" + this.instanceID + "/" + className + "/" + codebase + "/" + Utils.encodeURL(parameter);
    }

    public String getClassPathResourceURL(String className, String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            String classPath = className.replace('.', '/');
            classPath = classPath.substring(0, classPath.lastIndexOf(47) + 1);
            resourcePath = "/" + classPath + resourcePath;
        }
        return String.valueOf(this.getURLPrefix()) + "/classpath/" + this.instanceID + Utils.simplifyPath(resourcePath);
    }

    public String getResourcePathURL(String codeBase, String resourcePath) {
        if (codeBase == null) {
            codeBase = ".";
        }
        return String.valueOf(this.getURLPrefix()) + "/resource/" + Utils.encodeURL(codeBase) + "/" + Utils.encodeURL(resourcePath);
    }

    public WebServerContent getURLContent(String resourceURL) {
        try {
            HTTPRequest httpRequest = new HTTPRequest(new URL(resourceURL).getPath());
            return WebServer.getWebServerContent(httpRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader()) {
            return;
        }
        this.referenceClassLoaderList.add(0, referenceClassLoader);
    }

    public void removeReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader()) {
            return;
        }
        this.referenceClassLoaderList.remove(referenceClassLoader);
    }

    protected static WebServerContent getWebServerContent(HTTPRequest httpRequest) {
        int index;
        String parameter = httpRequest.getResourcePath();
        if (parameter.startsWith("/")) {
            parameter = parameter.substring(1);
        }
        if ((index = parameter.indexOf(47)) == -1) {
            return null;
        }
        String type = parameter.substring(0, index);
        parameter = parameter.substring(index + 1);
        if ("class".equals(type)) {
            index = parameter.indexOf(47);
            WebServer webServer = (WebServer)ObjectRegistry.getInstance().get(Integer.parseInt(parameter.substring(0, index)));
            if (webServer == null) {
                return null;
            }
            parameter = parameter.substring(index + 1);
            index = parameter.indexOf(47);
            String className = parameter.substring(0, index);
            parameter = Utils.decodeURL(parameter.substring(index + 1));
            httpRequest = httpRequest.clone();
            try {
                Class<?> clazz = null;
                for (ClassLoader referenceClassLoader : webServer.referenceClassLoaderList) {
                    try {
                        clazz = Class.forName(className, true, referenceClassLoader);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    clazz = Class.forName(className);
                }
                Method getWebServerContentMethod = clazz.getDeclaredMethod("getWebServerContent", HTTPRequest.class);
                getWebServerContentMethod.setAccessible(true);
                httpRequest.setResourcePath(parameter);
                return (WebServerContent)getWebServerContentMethod.invoke(null, httpRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if ("classpath".equals(type)) {
            index = parameter.indexOf(47);
            final WebServer webServer = (WebServer)ObjectRegistry.getInstance().get(Integer.parseInt(parameter.substring(0, index)));
            if (webServer == null) {
                return null;
            }
            final String resourcePath = parameter = parameter.substring(index + 1);
            return new WebServerContent(){

                public String getContentType() {
                    int index = resourcePath.lastIndexOf(46);
                    return 2.getDefaultMimeType(index == -1 ? null : resourcePath.substring(index));
                }

                public InputStream getInputStream() {
                    try {
                        for (ClassLoader referenceClassLoader : webServer.referenceClassLoaderList) {
                            InputStream in = referenceClassLoader.getResourceAsStream(resourcePath);
                            if (in == null) continue;
                            return in;
                        }
                        return WebServer.class.getResourceAsStream(String.valueOf('/') + resourcePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
        if ("resource".equals(type)) {
            String resourceURL;
            parameter = Utils.decodeURL(parameter);
            index = parameter.indexOf(47);
            String codeBase = Utils.decodeURL(parameter.substring(0, index));
            parameter = parameter.substring(index + 1);
            try {
                URL url = new URL(codeBase);
                int port = url.getPort();
                resourceURL = String.valueOf(url.getProtocol()) + "://" + url.getHost() + (port != -1 ? ":" + port : "");
                if (parameter.startsWith("/")) {
                    resourceURL = String.valueOf(resourceURL) + parameter;
                } else {
                    String path = url.getPath();
                    path = String.valueOf(path.substring(0, path.lastIndexOf(47) + 1)) + parameter;
                    resourceURL = String.valueOf(resourceURL) + (path.startsWith("/") ? path : "/" + path);
                }
            }
            catch (Exception e) {
                File file = Utils.getLocalFile(new File(codeBase, parameter).getAbsolutePath());
                resourceURL = file != null ? new File(codeBase, parameter).toURI().toString() : String.valueOf(codeBase) + "/" + parameter;
            }
            final String resourceURL_ = resourceURL;
            return new WebServerContent(){

                public long getContentLength() {
                    File file = Utils.getLocalFile(resourceURL_);
                    if (file != null) {
                        return file.length();
                    }
                    return super.getContentLength();
                }

                public String getContentType() {
                    int index = resourceURL_.lastIndexOf(46);
                    return 3.getDefaultMimeType(index == -1 ? null : resourceURL_.substring(index));
                }

                public InputStream getInputStream() {
                    String url = resourceURL_;
                    try {
                        return new URL(url).openStream();
                    }
                    catch (Exception exception) {
                        try {
                            return new FileInputStream("/" + url);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                }
            };
        }
        return null;
    }

    private static String getHostAddress() {
        return hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopDefaultWebServer() {
        Object object = LOCK;
        synchronized (object) {
            if (webServer != null) {
                webServer.stop();
                webServer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServer getDefaultWebServer() {
        Object object = LOCK;
        synchronized (object) {
            if (webServer != null) {
                return webServer;
            }
            webServer = new WebServer();
            try {
                webServer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return webServer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTTPData {
        private Map<String, String> headerMap = new HashMap<String, String>();
        private byte[] bytes;

        HTTPData() {
        }

        public Map<String, String> getHeaderMap() {
            return this.headerMap;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTTPRequest
    implements Cloneable {
        private String endQuery = "";
        private String urlPath;
        private String resourcePath;
        private String anchor;
        private Map<String, String> queryParameterMap = new HashMap<String, String>();
        private boolean isPostMethod;
        private HTTPData[] httpPostDataArray;

        HTTPRequest(String urlPath) {
            this.setURLPath(urlPath);
        }

        void setURLPath(String urlPath) {
            this.urlPath = urlPath;
            this.resourcePath = urlPath;
            int index = this.resourcePath.indexOf(63);
            if (index != -1) {
                String queryString = this.resourcePath.substring(index + 1);
                this.endQuery = String.valueOf('?') + queryString;
                this.resourcePath = this.resourcePath.substring(0, index);
                String[] stringArray = queryString.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String content = stringArray[n2];
                    int eqIndex = content.indexOf(61);
                    if (eqIndex > 0) {
                        String key = content.substring(0, eqIndex);
                        String value = Utils.decodeURL(content.substring(eqIndex + 1));
                        this.queryParameterMap.put(key, value);
                    } else {
                        this.queryParameterMap.put(content, "");
                    }
                    ++n2;
                }
            }
            if ((index = this.resourcePath.indexOf(35)) != -1) {
                this.anchor = this.resourcePath.substring(index + 1);
                this.endQuery = String.valueOf('#') + this.anchor + this.endQuery;
                this.resourcePath = this.resourcePath.substring(0, index);
            }
        }

        public String getURLPath() {
            return this.urlPath;
        }

        void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            this.urlPath = String.valueOf(resourcePath) + this.endQuery;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public Map<String, String> getQueryParameterMap() {
            return this.queryParameterMap;
        }

        void setPostMethod(boolean isPostMethod) {
            this.isPostMethod = isPostMethod;
        }

        public boolean isPostMethod() {
            return this.isPostMethod;
        }

        void setHTTPPostDataArray(HTTPData[] httpPostDataArray) {
            this.httpPostDataArray = httpPostDataArray;
        }

        public HTTPData[] getHTTPPostDataArray() {
            return this.httpPostDataArray;
        }

        protected HTTPRequest clone() {
            try {
                HTTPRequest httpRequest = (HTTPRequest)super.clone();
                httpRequest.queryParameterMap = new HashMap<String, String>(this.queryParameterMap);
                return httpRequest;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class WebServerConnectionThread
    extends Thread {
        private static int threadInitNumber;
        private static Semaphore semaphore;
        private Socket socket;
        private static final String LS;
        private static final boolean DEBUG_PRINT_REQUESTS;

        static {
            semaphore = new Semaphore(10);
            LS = Utils.LINE_SEPARATOR;
            DEBUG_PRINT_REQUESTS = Boolean.parseBoolean(System.getProperty("nativeswing.webserver.debug.printrequests"));
        }

        private static synchronized int nextThreadNumber() {
            return threadInitNumber++;
        }

        public WebServerConnectionThread(Socket socket) {
            super("WebServer Connection-" + WebServerConnectionThread.nextThreadNumber());
            this.socket = socket;
            this.setDaemon(true);
        }

        static void writeHTTPHeaders(BufferedOutputStream out, int code, String contentType, long contentLength, long lastModified) {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP/1.0 " + code + " OK" + LS);
            sb.append("Content-Type: " + contentType + LS);
            sb.append("Server: WebServer/1.0" + LS);
            sb.append("Date: " + new Date() + LS);
            if (contentLength != -1L) {
                sb.append("Content-Length: " + contentLength + LS);
            }
            sb.append(LS);
            try {
                out.write(sb.toString().getBytes("UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        static void writeHTTPError(BufferedOutputStream out, int code, String message) {
            WebServerConnectionThread.writeHTTPHeaders(out, code, "text/html", message.length(), System.currentTimeMillis());
            try {
                out.write(message.getBytes("UTF-8"));
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                String request;
                BufferedOutputStream out;
                HTTPInputStream in;
                block45: {
                    in = new HTTPInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    out = new BufferedOutputStream(this.socket.getOutputStream());
                    request = in.readAsciiLine();
                    if (request != null && (request.endsWith(" HTTP/1.0") || request.endsWith("HTTP/1.1"))) break block45;
                    WebServerConnectionThread.writeHTTPError(out, 500, "Invalid Method.");
                    return;
                }
                try {
                    try {
                        int i;
                        boolean isPostMethod = false;
                        if (request.startsWith("POST ")) {
                            isPostMethod = true;
                        } else if (!request.startsWith("GET ")) {
                            WebServerConnectionThread.writeHTTPError(out, 500, "Invalid Method.");
                            return;
                        }
                        String resourcePath = request.substring((isPostMethod ? "POST " : "GET ").length(), request.length() - " HTTP/1.0".length());
                        HTTPRequest httpRequest = new HTTPRequest(resourcePath);
                        httpRequest.setPostMethod(isPostMethod);
                        if (isPostMethod) {
                            HTTPData[] httpDataArray;
                            String header;
                            String contentType = null;
                            int contentLength = -1;
                            while ((header = in.readAsciiLine()).length() > 0) {
                                if (header.startsWith("Content-Length: ")) {
                                    contentLength = Integer.parseInt(header.substring("Content-Length: ".length()));
                                    continue;
                                }
                                if (!header.startsWith("Content-Type: ")) continue;
                                contentType = header.substring("Content-Type: ".length());
                            }
                            if (contentType != null && contentType.startsWith("multipart/")) {
                                byte[] dataBytes;
                                if (contentLength > 0) {
                                    dataBytes = new byte[contentLength];
                                    in.read(dataBytes);
                                } else {
                                    int i2;
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    byte[] bytes = new byte[1024];
                                    while ((i2 = in.read(bytes)) != -1) {
                                        baos.write(bytes, 0, i2);
                                    }
                                    dataBytes = baos.toByteArray();
                                }
                                String boundary = "--" + contentType.substring(contentType.indexOf("boundary=") + "boundary=".length());
                                byte[] boundaryBytes = boundary.getBytes("UTF-8");
                                ArrayList<Integer> indexList = new ArrayList<Integer>();
                                int i3 = 0;
                                while (i3 < dataBytes.length - boundaryBytes.length) {
                                    boolean isFound = true;
                                    int j = 0;
                                    while (j < boundaryBytes.length) {
                                        if (dataBytes[i3 + j] != boundaryBytes[j]) {
                                            isFound = false;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (isFound) {
                                        indexList.add(i3);
                                        i3 += boundaryBytes.length;
                                    }
                                    ++i3;
                                }
                                httpDataArray = new HTTPData[indexList.size() - 1];
                                i3 = 0;
                                while (i3 < httpDataArray.length) {
                                    int n;
                                    String header2;
                                    HTTPData httpData;
                                    httpDataArray[i3] = httpData = new HTTPData();
                                    int start = (Integer)indexList.get(i3);
                                    ByteArrayInputStream bais = new ByteArrayInputStream(dataBytes, start, (Integer)indexList.get(i3 + 1) - start - in.getLineSeparator().length());
                                    HTTPInputStream din = new HTTPInputStream(bais);
                                    din.readAsciiLine();
                                    Map<String, String> headerMap = httpData.getHeaderMap();
                                    while ((header2 = din.readAsciiLine()).length() > 0) {
                                        String key = header2.substring(header2.indexOf(": "));
                                        String value = header2.substring(key.length() + ": ".length());
                                        headerMap.put(key, value);
                                    }
                                    ByteArrayOutputStream aos = new ByteArrayOutputStream();
                                    while ((n = din.read()) != -1) {
                                        aos.write(n);
                                    }
                                    httpData.setBytes(aos.toByteArray());
                                    ++i3;
                                }
                            } else {
                                String dataContent;
                                InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");
                                if (contentLength > 0) {
                                    char[] chars = new char[contentLength];
                                    int offset = 0;
                                    while (chars.length > offset) {
                                        int n = reader.read(chars, offset, chars.length - offset);
                                        int n2 = offset = n == -1 ? chars.length : offset + n;
                                    }
                                    dataContent = new String(chars);
                                } else {
                                    int i4;
                                    StringBuilder sb = new StringBuilder();
                                    char[] chars = new char[1024];
                                    while ((i4 = reader.read(chars)) != -1) {
                                        sb.append(chars, 0, i4);
                                    }
                                    dataContent = sb.toString();
                                }
                                HTTPData httpData = new HTTPData();
                                Map<String, String> headerMap = httpData.getHeaderMap();
                                String[] stringArray = dataContent.split("&");
                                int n = stringArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    String content = stringArray[n3];
                                    int eqIndex = content.indexOf(61);
                                    if (eqIndex > 0) {
                                        String key = content.substring(0, eqIndex);
                                        String value = Utils.decodeURL(content.substring(eqIndex + 1));
                                        headerMap.put(key, value);
                                    } else {
                                        headerMap.put(content, "");
                                    }
                                    ++n3;
                                }
                                httpDataArray = new HTTPData[]{httpData};
                            }
                            httpRequest.setHTTPPostDataArray(httpDataArray);
                        }
                        WebServerContent webServerContent = WebServer.getWebServerContent(httpRequest);
                        InputStream resourceStream_ = null;
                        if (webServerContent != null) {
                            try {
                                resourceStream_ = webServerContent.getInputStream();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (resourceStream_ == null) {
                            if (DEBUG_PRINT_REQUESTS) {
                                System.err.println("Web Server " + (isPostMethod ? "POST" : "GET") + ": " + resourcePath + " -> 404 (not found)");
                            }
                            WebServerConnectionThread.writeHTTPError(out, 404, "File Not Found.");
                            return;
                        }
                        if (DEBUG_PRINT_REQUESTS) {
                            System.err.println("Web Server " + (isPostMethod ? "POST" : "GET") + ": " + resourcePath + " -> 200 (OK)");
                        }
                        BufferedInputStream resourceStream = new BufferedInputStream(resourceStream_);
                        WebServerConnectionThread.writeHTTPHeaders(out, 200, webServerContent.getContentType(), webServerContent.getContentLength(), webServerContent.getLastModified());
                        byte[] bytes = new byte[4096];
                        while ((i = resourceStream.read(bytes)) != -1) {
                            out.write(bytes, 0, i);
                        }
                        try {
                            resourceStream.close();
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        out.flush();
                        out.close();
                        in.close();
                        this.socket.close();
                    }
                }
                catch (Exception exception) {}
                return;
            }
            finally {
                semaphore.release();
            }
        }

        private static class HTTPInputStream
        extends InputStream {
            private InputStream inputStream;
            private LineSeparator lineSeparator;
            private int lastByte = -1;

            public HTTPInputStream(InputStream inputStream) {
                this.inputStream = inputStream;
            }

            public String getLineSeparator() {
                switch (this.lineSeparator) {
                    case CR: {
                        return "\r";
                    }
                    case LF: {
                        return "\n";
                    }
                    case CRLF: {
                        return "\r\n";
                    }
                }
                return null;
            }

            public String readAsciiLine() throws IOException {
                if (this.lineSeparator == null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (true) {
                        int b;
                        if ((b = this.read()) == -1) {
                            return null;
                        }
                        if (b == 10) {
                            this.lineSeparator = LineSeparator.LF;
                            return new String(baos.toByteArray(), "UTF-8");
                        }
                        if (b == 13) {
                            int b2 = this.read();
                            if (b2 == 10) {
                                this.lineSeparator = LineSeparator.CRLF;
                            } else {
                                this.lineSeparator = LineSeparator.CR;
                                if (b2 != -1) {
                                    this.lastByte = b2;
                                }
                            }
                            return new String(baos.toByteArray(), "UTF-8");
                        }
                        baos.write(b);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (this.lastByte != -1) {
                    baos.write(this.lastByte);
                    this.lastByte = -1;
                }
                switch (this.lineSeparator) {
                    case CR: {
                        int b;
                        while ((b = this.read()) != 13 && b != -1) {
                            baos.write(b);
                        }
                        break;
                    }
                    case LF: {
                        int b;
                        while ((b = this.read()) != 10 && b != -1) {
                            baos.write(b);
                        }
                        break;
                    }
                    case CRLF: {
                        int b;
                        while ((b = this.read()) != 13 && b != -1) {
                            baos.write(b);
                        }
                        this.read();
                    }
                }
                return new String(baos.toByteArray(), "UTF-8");
            }

            public void close() throws IOException {
                this.inputStream.close();
            }

            public int read(byte[] b) throws IOException {
                return this.inputStream.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return this.inputStream.read(b, off, len);
            }

            public int read() throws IOException {
                int n = this.inputStream.read();
                return n;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum LineSeparator {
                CR,
                LF,
                CRLF;

            }
        }
    }

    public static abstract class WebServerContent {
        public static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
        private static Map<String, String> extensionToMimeTypeMap = new HashMap<String, String>();

        static {
            extensionToMimeTypeMap.put("323", "text/h323");
            extensionToMimeTypeMap.put("acx", "application/internet-property-stream");
            extensionToMimeTypeMap.put("ai", "application/postscript");
            extensionToMimeTypeMap.put("aif", "audio/x-aiff");
            extensionToMimeTypeMap.put("aifc", "audio/x-aiff");
            extensionToMimeTypeMap.put("aiff", "audio/x-aiff");
            extensionToMimeTypeMap.put("asf", "video/x-ms-asf");
            extensionToMimeTypeMap.put("asr", "video/x-ms-asf");
            extensionToMimeTypeMap.put("asx", "video/x-ms-asf");
            extensionToMimeTypeMap.put("au", "audio/basic");
            extensionToMimeTypeMap.put("avi", "video/x-msvideo");
            extensionToMimeTypeMap.put("axs", "application/olescript");
            extensionToMimeTypeMap.put("bas", "text/plain");
            extensionToMimeTypeMap.put("bcpio", "application/x-bcpio");
            extensionToMimeTypeMap.put("bin", MIME_APPLICATION_OCTET_STREAM);
            extensionToMimeTypeMap.put("bmp", "image/bmp");
            extensionToMimeTypeMap.put("c", "text/plain");
            extensionToMimeTypeMap.put("cat", "application/vnd.ms-pkiseccat");
            extensionToMimeTypeMap.put("cdf", "application/x-cdf");
            extensionToMimeTypeMap.put("cer", "application/x-x509-ca-cert");
            extensionToMimeTypeMap.put("class", MIME_APPLICATION_OCTET_STREAM);
            extensionToMimeTypeMap.put("clp", "application/x-msclip");
            extensionToMimeTypeMap.put("cmx", "image/x-cmx");
            extensionToMimeTypeMap.put("cod", "image/cis-cod");
            extensionToMimeTypeMap.put("cpio", "application/x-cpio");
            extensionToMimeTypeMap.put("crd", "application/x-mscardfile");
            extensionToMimeTypeMap.put("crl", "application/pkix-crl");
            extensionToMimeTypeMap.put("crt", "application/x-x509-ca-cert");
            extensionToMimeTypeMap.put("csh", "application/x-csh");
            extensionToMimeTypeMap.put("css", "text/css");
            extensionToMimeTypeMap.put("dcr", "application/x-director");
            extensionToMimeTypeMap.put("der", "application/x-x509-ca-cert");
            extensionToMimeTypeMap.put("dir", "application/x-director");
            extensionToMimeTypeMap.put("dll", "application/x-msdownload");
            extensionToMimeTypeMap.put("dms", MIME_APPLICATION_OCTET_STREAM);
            extensionToMimeTypeMap.put("doc", "application/msword");
            extensionToMimeTypeMap.put("dot", "application/msword");
            extensionToMimeTypeMap.put("dvi", "application/x-dvi");
            extensionToMimeTypeMap.put("dxr", "application/x-director");
            extensionToMimeTypeMap.put("eps", "application/postscript");
            extensionToMimeTypeMap.put("etx", "text/x-setext");
            extensionToMimeTypeMap.put("evy", "application/envoy");
            extensionToMimeTypeMap.put("exe", MIME_APPLICATION_OCTET_STREAM);
            extensionToMimeTypeMap.put("fif", "application/fractals");
            extensionToMimeTypeMap.put("flr", "x-world/x-vrml");
            extensionToMimeTypeMap.put("gif", "image/gif");
            extensionToMimeTypeMap.put("gtar", "application/x-gtar");
            extensionToMimeTypeMap.put("gz", "application/x-gzip");
            extensionToMimeTypeMap.put("h", "text/plain");
            extensionToMimeTypeMap.put("hdf", "application/x-hdf");
            extensionToMimeTypeMap.put("hlp", "application/winhlp");
            extensionToMimeTypeMap.put("hqx", "application/mac-binhex40");
            extensionToMimeTypeMap.put("hta", "application/hta");
            extensionToMimeTypeMap.put("htc", "text/x-component");
            extensionToMimeTypeMap.put("htm", "text/html");
            extensionToMimeTypeMap.put("html", "text/html");
            extensionToMimeTypeMap.put("htt", "text/webviewhtml");
            extensionToMimeTypeMap.put("ico", "image/x-icon");
            extensionToMimeTypeMap.put("ief", "image/ief");
            extensionToMimeTypeMap.put("iii", "application/x-iphone");
            extensionToMimeTypeMap.put("ins", "application/x-internet-signup");
            extensionToMimeTypeMap.put("isp", "application/x-internet-signup");
            extensionToMimeTypeMap.put("jfif", "image/pipeg");
            extensionToMimeTypeMap.put("jnlp", "application/x-java-jnlp-file");
            extensionToMimeTypeMap.put("jpe", "image/jpeg");
            extensionToMimeTypeMap.put("jpeg", "image/jpeg");
            extensionToMimeTypeMap.put("jpg", "image/jpeg");
            extensionToMimeTypeMap.put("js", "application/x-javascript");
            extensionToMimeTypeMap.put("latex", "application/x-latex");
            extensionToMimeTypeMap.put("lha", MIME_APPLICATION_OCTET_STREAM);
            extensionToMimeTypeMap.put("lsf", "video/x-la-asf");
            extensionToMimeTypeMap.put("lsx", "video/x-la-asf");
            extensionToMimeTypeMap.put("lzh", MIME_APPLICATION_OCTET_STREAM);
            extensionToMimeTypeMap.put("m13", "application/x-msmediaview");
            extensionToMimeTypeMap.put("m14", "application/x-msmediaview");
            extensionToMimeTypeMap.put("m3u", "audio/x-mpegurl");
            extensionToMimeTypeMap.put("man", "application/x-troff-man");
            extensionToMimeTypeMap.put("mdb", "application/x-msaccess");
            extensionToMimeTypeMap.put("me", "application/x-troff-me");
            extensionToMimeTypeMap.put("mht", "message/rfc822");
            extensionToMimeTypeMap.put("mhtml", "message/rfc822");
            extensionToMimeTypeMap.put("mid", "audio/mid");
            extensionToMimeTypeMap.put("mny", "application/x-msmoney");
            extensionToMimeTypeMap.put("mov", "video/quicktime");
            extensionToMimeTypeMap.put("movie", "video/x-sgi-movie");
            extensionToMimeTypeMap.put("mp2", "video/mpeg");
            extensionToMimeTypeMap.put("mp3", "audio/mpeg");
            extensionToMimeTypeMap.put("mpa", "video/mpeg");
            extensionToMimeTypeMap.put("mpe", "video/mpeg");
            extensionToMimeTypeMap.put("mpeg", "video/mpeg");
            extensionToMimeTypeMap.put("mpg", "video/mpeg");
            extensionToMimeTypeMap.put("mpp", "application/vnd.ms-project");
            extensionToMimeTypeMap.put("mpv2", "video/mpeg");
            extensionToMimeTypeMap.put("ms", "application/x-troff-ms");
            extensionToMimeTypeMap.put("mvb", "application/x-msmediaview");
            extensionToMimeTypeMap.put("nws", "message/rfc822");
            extensionToMimeTypeMap.put("oda", "application/oda");
            extensionToMimeTypeMap.put("p10", "application/pkcs10");
            extensionToMimeTypeMap.put("p12", "application/x-pkcs12");
            extensionToMimeTypeMap.put("p7b", "application/x-pkcs7-certificates");
            extensionToMimeTypeMap.put("p7c", "application/x-pkcs7-mime");
            extensionToMimeTypeMap.put("p7m", "application/x-pkcs7-mime");
            extensionToMimeTypeMap.put("p7r", "application/x-pkcs7-certreqresp");
            extensionToMimeTypeMap.put("p7s", "application/x-pkcs7-signature");
            extensionToMimeTypeMap.put("pbm", "image/x-portable-bitmap");
            extensionToMimeTypeMap.put("pdf", "application/pdf");
            extensionToMimeTypeMap.put("pfx", "application/x-pkcs12");
            extensionToMimeTypeMap.put("pgm", "image/x-portable-graymap");
            extensionToMimeTypeMap.put("pko", "application/ynd.ms-pkipko");
            extensionToMimeTypeMap.put("pma", "application/x-perfmon");
            extensionToMimeTypeMap.put("pmc", "application/x-perfmon");
            extensionToMimeTypeMap.put("pml", "application/x-perfmon");
            extensionToMimeTypeMap.put("pmr", "application/x-perfmon");
            extensionToMimeTypeMap.put("pmw", "application/x-perfmon");
            extensionToMimeTypeMap.put("pnm", "image/x-portable-anymap");
            extensionToMimeTypeMap.put("pot,", "application/vnd.ms-powerpoint");
            extensionToMimeTypeMap.put("ppm", "image/x-portable-pixmap");
            extensionToMimeTypeMap.put("pps", "application/vnd.ms-powerpoint");
            extensionToMimeTypeMap.put("ppt", "application/vnd.ms-powerpoint");
            extensionToMimeTypeMap.put("prf", "application/pics-rules");
            extensionToMimeTypeMap.put("ps", "application/postscript");
            extensionToMimeTypeMap.put("pub", "application/x-mspublisher");
            extensionToMimeTypeMap.put("qt", "video/quicktime");
            extensionToMimeTypeMap.put("ra", "audio/x-pn-realaudio");
            extensionToMimeTypeMap.put("ram", "audio/x-pn-realaudio");
            extensionToMimeTypeMap.put("ras", "image/x-cmu-raster");
            extensionToMimeTypeMap.put("rgb", "image/x-rgb");
            extensionToMimeTypeMap.put("rmi", "audio/mid");
            extensionToMimeTypeMap.put("roff", "application/x-troff");
            extensionToMimeTypeMap.put("rtf", "application/rtf");
            extensionToMimeTypeMap.put("rtx", "text/richtext");
            extensionToMimeTypeMap.put("scd", "application/x-msschedule");
            extensionToMimeTypeMap.put("sct", "text/scriptlet");
            extensionToMimeTypeMap.put("setpay", "application/set-payment-initiation");
            extensionToMimeTypeMap.put("setreg", "application/set-registration-initiation");
            extensionToMimeTypeMap.put("sh", "application/x-sh");
            extensionToMimeTypeMap.put("shar", "application/x-shar");
            extensionToMimeTypeMap.put("sit", "application/x-stuffit");
            extensionToMimeTypeMap.put("snd", "audio/basic");
            extensionToMimeTypeMap.put("spc", "application/x-pkcs7-certificates");
            extensionToMimeTypeMap.put("spl", "application/futuresplash");
            extensionToMimeTypeMap.put("src", "application/x-wais-source");
            extensionToMimeTypeMap.put("sst", "application/vnd.ms-pkicertstore");
            extensionToMimeTypeMap.put("stl", "application/vnd.ms-pkistl");
            extensionToMimeTypeMap.put("stm", "text/html");
            extensionToMimeTypeMap.put("svg", "image/svg+xml");
            extensionToMimeTypeMap.put("sv4cpio", "application/x-sv4cpio");
            extensionToMimeTypeMap.put("sv4crc", "application/x-sv4crc");
            extensionToMimeTypeMap.put("swf", "application/x-shockwave-flash");
            extensionToMimeTypeMap.put("t", "application/x-troff");
            extensionToMimeTypeMap.put("tar", "application/x-tar");
            extensionToMimeTypeMap.put("tcl", "application/x-tcl");
            extensionToMimeTypeMap.put("tex", "application/x-tex");
            extensionToMimeTypeMap.put("texi", "application/x-texinfo");
            extensionToMimeTypeMap.put("texinfo", "application/x-texinfo");
            extensionToMimeTypeMap.put("tgz", "application/x-compressed");
            extensionToMimeTypeMap.put("tif", "image/tiff");
            extensionToMimeTypeMap.put("tiff", "image/tiff");
            extensionToMimeTypeMap.put("tr", "application/x-troff");
            extensionToMimeTypeMap.put("trm", "application/x-msterminal");
            extensionToMimeTypeMap.put("tsv", "text/tab-separated-values");
            extensionToMimeTypeMap.put("txt", "text/plain");
            extensionToMimeTypeMap.put("uls", "text/iuls");
            extensionToMimeTypeMap.put("ustar", "application/x-ustar");
            extensionToMimeTypeMap.put("vcf", "text/x-vcard");
            extensionToMimeTypeMap.put("vrml", "x-world/x-vrml");
            extensionToMimeTypeMap.put("wav", "audio/x-wav");
            extensionToMimeTypeMap.put("wax", "audio/x-ms-wax");
            extensionToMimeTypeMap.put("wcm", "application/vnd.ms-works");
            extensionToMimeTypeMap.put("wdb", "application/vnd.ms-works");
            extensionToMimeTypeMap.put("wks", "application/vnd.ms-works");
            extensionToMimeTypeMap.put("wm", "video/x-ms-wm");
            extensionToMimeTypeMap.put("wma", "audio/x-ms-wma");
            extensionToMimeTypeMap.put("wmd", "application/x-ms-wmd");
            extensionToMimeTypeMap.put("wmf", "application/x-msmetafile");
            extensionToMimeTypeMap.put("wmv", "audio/x-ms-wmv");
            extensionToMimeTypeMap.put("wmx", "video/x-ms-wmx");
            extensionToMimeTypeMap.put("wmz", "application/x-ms-wmz");
            extensionToMimeTypeMap.put("wps", "application/vnd.ms-works");
            extensionToMimeTypeMap.put("wri", "application/x-mswrite");
            extensionToMimeTypeMap.put("wrl", "x-world/x-vrml");
            extensionToMimeTypeMap.put("wrz", "x-world/x-vrml");
            extensionToMimeTypeMap.put("wvx", "video/x-ms-wvx");
            extensionToMimeTypeMap.put("xaf", "x-world/x-vrml");
            extensionToMimeTypeMap.put("xbm", "image/x-xbitmap");
            extensionToMimeTypeMap.put("xla", "application/vnd.ms-excel");
            extensionToMimeTypeMap.put("xlc", "application/vnd.ms-excel");
            extensionToMimeTypeMap.put("xlm", "application/vnd.ms-excel");
            extensionToMimeTypeMap.put("xls", "application/vnd.ms-excel");
            extensionToMimeTypeMap.put("xlt", "application/vnd.ms-excel");
            extensionToMimeTypeMap.put("xlw", "application/vnd.ms-excel");
            extensionToMimeTypeMap.put("xml", "application/xml");
            extensionToMimeTypeMap.put("xof", "x-world/x-vrml");
            extensionToMimeTypeMap.put("xpm", "image/x-xpixmap");
            extensionToMimeTypeMap.put("xwd", "image/x-xwindowdump");
            extensionToMimeTypeMap.put("z", "application/x-compress");
            extensionToMimeTypeMap.put("zip", "application/zip");
        }

        public static String getDefaultMimeType(String extension) {
            String mimeType;
            if (extension == null) {
                return MIME_APPLICATION_OCTET_STREAM;
            }
            if (extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            return (mimeType = extensionToMimeTypeMap.get(extension.toLowerCase(Locale.ENGLISH))) != null ? mimeType : MIME_APPLICATION_OCTET_STREAM;
        }

        public abstract InputStream getInputStream();

        public static InputStream getInputStream(String content) {
            if (content == null) {
                return null;
            }
            try {
                return new ByteArrayInputStream(content.getBytes("UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getContentType() {
            return WebServerContent.getDefaultMimeType(".html");
        }

        public long getContentLength() {
            return -1L;
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }
    }
}

