/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final boolean IS_JAVA_6_OR_GREATER = System.getProperty("java.version").compareTo("1.6") >= 0;
    public static final boolean IS_MAC;
    public static final String LINE_SEPARATOR;
    private static String localHostAddress;

    static {
        String os = System.getProperty("os.name");
        IS_MAC = os.startsWith("Mac") || os.startsWith("Darwin");
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    private Utils() {
    }

    public static String decodeURL(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeURL(String s) {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            encodedString = URLEncoder.encode(s);
        }
        return encodedString.replaceAll("\\+", "%20");
    }

    public static String escapeXML(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static File getLocalFile(String path) {
        File file;
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:") && (file = new File(path.substring("file:".length()))).exists()) {
            return file;
        }
        file = new File(path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File getClassPathFile(String resourcePath) {
        File file = Utils.getJARFile(resourcePath);
        return file != null ? file : Utils.getDirectory(resourcePath);
    }

    public static File getClassPathFile(Class<?> clazz) {
        File file = Utils.getJARFile(clazz);
        return file != null ? file : Utils.getDirectory(clazz);
    }

    public static File getJARFile(String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            resourcePath = String.valueOf('/') + resourcePath;
        }
        return Utils.getJARFile(Utils.class, resourcePath);
    }

    public static File getJARFile(Class<?> clazz) {
        return Utils.getJARFile(clazz, "/" + clazz.getName().replace('.', '/') + ".class");
    }

    private static File getJARFile(Class<?> clazz, String resourcePath) {
        URL resource = clazz.getResource(resourcePath);
        if (resource == null) {
            return null;
        }
        String classResourceURL = resource.toExternalForm();
        if (classResourceURL != null && classResourceURL.startsWith("jar:file:") && (classResourceURL = classResourceURL.substring("jar:file:".length())).endsWith("!" + resourcePath)) {
            return new File(Utils.decodeURL(classResourceURL.substring(0, classResourceURL.length() - 1 - resourcePath.length())));
        }
        return null;
    }

    public static File getDirectory(String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            resourcePath = String.valueOf('/') + resourcePath;
        }
        return Utils.getDirectory(Utils.class, resourcePath);
    }

    public static File getDirectory(Class<?> clazz) {
        return Utils.getDirectory(clazz, "/" + clazz.getName().replace('.', '/') + ".class");
    }

    private static File getDirectory(Class<?> clazz, String resourcePath) {
        URL resource;
        String resourceName = resourcePath;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if ((resource = clazz.getResource(resourcePath)) == null) {
            return null;
        }
        String classResourceURL = resource.toExternalForm();
        if (classResourceURL != null && classResourceURL.startsWith("file:")) {
            File dir = new File(Utils.decodeURL(classResourceURL.substring("file:".length()))).getParentFile();
            int i = 0;
            while (i < resourceName.length()) {
                if (resourceName.charAt(i) == '/') {
                    dir = dir.getParentFile();
                }
                ++i;
            }
            return dir;
        }
        return null;
    }

    public static void deleteAll(File fileOrDir) {
        if (!fileOrDir.delete() && fileOrDir.isDirectory()) {
            File[] fileArray = fileOrDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Utils.deleteAll(file);
                ++n2;
            }
            fileOrDir.delete();
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static String arrayDeepToString(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        if (clazz == boolean[].class) {
            return Arrays.toString((boolean[])array);
        }
        if (clazz == byte[].class) {
            return Arrays.toString((byte[])array);
        }
        if (clazz == short[].class) {
            return Arrays.toString((short[])array);
        }
        if (clazz == char[].class) {
            return Arrays.toString((char[])array);
        }
        if (clazz == int[].class) {
            return Arrays.toString((int[])array);
        }
        if (clazz == long[].class) {
            return Arrays.toString((long[])array);
        }
        if (clazz == float[].class) {
            return Arrays.toString((float[])array);
        }
        if (clazz == double[].class) {
            return Arrays.toString((double[])array);
        }
        return Arrays.deepToString((Object[])array);
    }

    public static String simplifyPath(String path) {
        if (path.indexOf("//") != -1) {
            throw new IllegalArgumentException("The path is invalid: " + path);
        }
        String[] crumbs = path.split("/");
        ArrayList<String> crumbList = new ArrayList<String>(crumbs.length);
        String[] stringArray = crumbs;
        int n = crumbs.length;
        int n2 = 0;
        while (n2 < n) {
            String crumb = stringArray[n2];
            if (!"".equals(crumb) && !".".equals(crumb)) {
                if ("..".equals(crumb)) {
                    int index = crumbList.size() - 1;
                    if (index == -1) {
                        throw new IllegalArgumentException("The path is invalid: " + path);
                    }
                    crumbList.remove(index);
                } else {
                    crumbList.add(crumb);
                }
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder(path.length());
        if (path.startsWith("/")) {
            sb.append('/');
        }
        int crumbCount = crumbList.size();
        int i = 0;
        while (i < crumbCount) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append((String)crumbList.get(i));
            ++i;
        }
        if (path.length() > 1 && path.endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    public static String getLocalHostAddress() {
        if (localHostAddress != null) {
            return "".equals(localHostAddress) ? null : localHostAddress;
        }
        String localHostAddress = System.getProperty("nativeswing.localhostaddress");
        if ("_localhost_".equals(localHostAddress)) {
            try {
                localHostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                localHostAddress = null;
            }
        }
        if (localHostAddress == null) {
            localHostAddress = Utils.getLocalHostAddress(0);
        }
        if (Boolean.parseBoolean(System.getProperty("nativeswing.debug.printlocalhostaddress"))) {
            System.err.println("Local host address: " + localHostAddress);
        }
        Utils.localHostAddress = localHostAddress == null ? "" : localHostAddress;
        return localHostAddress;
    }

    public static String getLocalHostAddress(int port) {
        String loopbackAddress = "127.0.0.1";
        if (Utils.isLocalHostAddressReachable(loopbackAddress, port)) {
            return loopbackAddress;
        }
        ArrayList<InetAddress> inetAddressList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Enumeration<InetAddress> en2 = networkInterface.getInetAddresses();
                while (en2.hasMoreElements()) {
                    InetAddress inetAddress = en2.nextElement();
                    if (!inetAddress.isLoopbackAddress() && !inetAddress.isSiteLocalAddress() || loopbackAddress.equals(inetAddress.getHostAddress())) continue;
                    inetAddressList.add(inetAddress);
                }
            }
        }
        catch (SocketException en) {
            // empty catch block
        }
        Collections.sort(inetAddressList, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress o1, InetAddress o2) {
                if (o1.isLoopbackAddress()) {
                    if (o2.isLoopbackAddress()) {
                        return o1.getHostAddress().compareTo(o2.getHostAddress());
                    }
                    return 1;
                }
                if (o2.isLoopbackAddress()) {
                    return -1;
                }
                return o1.getHostAddress().compareTo(o2.getHostAddress());
            }
        });
        for (InetAddress address : inetAddressList) {
            String hostAddress = address.getHostAddress();
            if (!Utils.isLocalHostAddressReachable(hostAddress, port)) continue;
            return hostAddress;
        }
        return null;
    }

    private static boolean isLocalHostAddressReachable(String hostAddress, int port) {
        boolean isReachable = false;
        try {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(hostAddress), port));
            port = serverSocket.getLocalPort();
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(hostAddress, port), 200);
                isReachable = true;
                socket.close();
            }
            catch (Exception e) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isReachable;
    }
}

