/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.markup.MappingValue;
import org.languagetool.markup.TextPart;

public class AnnotatedText {
    private final List<TextPart> parts;
    private final Map<Integer, MappingValue> mapping;
    private final Map<MetaDataKey, String> metaData;
    private final Map<String, String> customMetaData;

    AnnotatedText(List<TextPart> parts, Map<Integer, MappingValue> mapping, Map<MetaDataKey, String> metaData, Map<String, String> customMetaData) {
        this.parts = Objects.requireNonNull(parts);
        this.mapping = Objects.requireNonNull(mapping);
        this.metaData = Objects.requireNonNull(metaData);
        this.customMetaData = Objects.requireNonNull(customMetaData);
    }

    public List<TextPart> getParts() {
        return this.parts;
    }

    public String getOriginalText() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() != TextPart.Type.TEXT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public String getPlainText() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() != TextPart.Type.TEXT && part.getType() != TextPart.Type.FAKE_CONTENT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public String getTextWithMarkup() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() == TextPart.Type.FAKE_CONTENT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public int getOriginalTextPositionFor(int plainTextPosition, boolean isToPos) {
        if (plainTextPosition < 0) {
            throw new IllegalArgumentException("plainTextPosition must be >= 0: " + plainTextPosition);
        }
        if (this.mapping.isEmpty()) {
            return 0;
        }
        int minDiff = Integer.MAX_VALUE;
        MappingValue bestMatch = null;
        for (Map.Entry<Integer, MappingValue> entry : this.mapping.entrySet()) {
            int diff;
            int maybeClosePosition = entry.getKey();
            if (plainTextPosition >= maybeClosePosition || (diff = maybeClosePosition - plainTextPosition) <= 0 || diff >= minDiff) continue;
            bestMatch = entry.getValue();
            minDiff = diff;
        }
        if (bestMatch == null) {
            String msg = "mappings: " + (this.mapping.size() < 5 ? this.mapping : Integer.valueOf(this.mapping.size()));
            throw new RuntimeException("Could not map " + plainTextPosition + " to original position. isToPos: " + isToPos + ", " + msg);
        }
        if (!isToPos && bestMatch.getFakeMarkupLength() > 0) {
            minDiff = bestMatch.getFakeMarkupLength();
        }
        return bestMatch.getTotalPosition() - minDiff;
    }

    public String getGlobalMetaData(String key, String defaultValue) {
        return this.customMetaData.getOrDefault(key, defaultValue);
    }

    public String getGlobalMetaData(MetaDataKey key, String defaultValue) {
        return this.metaData.getOrDefault((Object)key, defaultValue);
    }

    public Map<MetaDataKey, String> getGlobalMetaData() {
        return this.metaData;
    }

    public Map<String, String> getCustomMetaData() {
        return this.customMetaData;
    }

    public String toString() {
        return StringUtils.join(this.parts, (String)"");
    }

    public static enum MetaDataKey {
        DocumentTitle,
        EmailToAddress,
        EmailNumberOfAttachments;

    }
}

