/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    long webView;
    long webViewData;
    long scrolledWindow;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    String postData;
    String[] headers;
    boolean ignoreDispose;
    boolean loadingText;
    boolean untrustedText;
    byte[] htmlBytes;
    BrowserFunction eventFunction;
    static long ExternalClass;
    static long PostString;
    static boolean LibraryLoaded;
    static final String ABOUT_BLANK = "about:blank";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String ENCODING_FORM = "Content-Type: application/x-www-form-urlencoded";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int HOVERING_OVER_LINK = 1;
    static final int NOTIFY_PROGRESS = 2;
    static final int NAVIGATION_POLICY_DECISION_REQUESTED = 3;
    static final int NOTIFY_TITLE = 4;
    static final int POPULATE_POPUP = 5;
    static final int STATUS_BAR_TEXT_CHANGED = 6;
    static final int CREATE_WEB_VIEW = 7;
    static final int WEB_VIEW_READY = 8;
    static final int NOTIFY_LOAD_STATUS = 9;
    static final int RESOURCE_REQUEST_STARTING = 10;
    static final int DOWNLOAD_REQUESTED = 11;
    static final int MIME_TYPE_POLICY_DECISION_REQUESTED = 12;
    static final int CLOSE_WEB_VIEW = 13;
    static final int WINDOW_OBJECT_CLEARED = 14;
    static final int CONSOLE_MESSAGE = 15;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback Proc6;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        MIN_VERSION = nArray;
        SEPARATOR_FILE = System.getProperty("file.separator").charAt(0);
        try {
            Library.loadLibrary("swt-webkit12");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {
            try {
                Library.loadLibrary("swt-webkit");
                LibraryLoaded = true;
            }
            catch (Throwable throwable2) {}
        }
        if (LibraryLoaded) {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc2 = new Callback(clazz8, "Proc", 2)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz7 = class$0) == null) {
                try {
                    clazz7 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc3 = new Callback(clazz7, "Proc", 3)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz6 = class$0) == null) {
                try {
                    clazz6 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc4 = new Callback(clazz6, "Proc", 4)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz5 = class$0) == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc5 = new Callback(clazz5, "Proc", 5)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz4 = class$0) == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((Proc6 = new Callback(clazz4, "Proc", 6)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz3 = class$0) == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectHasPropertyProc = new Callback(clazz3, "JSObjectHasPropertyProc", 3)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz2 = class$0) == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectGetPropertyProc = new Callback(clazz2, "JSObjectGetPropertyProc", 4)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectCallAsFunctionProc = new Callback(clazz, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0L) {
                SWT.error(3);
            }
            NativeClearSessions = new Runnable(){

                public void run() {
                    long l;
                    if (!LibraryLoaded) {
                        return;
                    }
                    long l2 = WebKitGTK.webkit_get_default_session();
                    long l3 = WebKitGTK.soup_session_get_feature(l2, l = WebKitGTK.soup_cookie_jar_get_type());
                    if (l3 == 0L) {
                        return;
                    }
                    long l4 = WebKitGTK.soup_cookie_jar_all_cookies(l3);
                    int n = OS.g_slist_length(l4);
                    long l5 = l4;
                    int n2 = 0;
                    while (n2 < n) {
                        long l6 = OS.g_slist_data(l5);
                        long l7 = WebKitGTK.SoupCookie_expires(l6);
                        if (l7 == 0L) {
                            WebKitGTK.soup_cookie_jar_delete_cookie(l3, l6);
                        }
                        l5 = OS.g_slist_next(l5);
                        ++n2;
                    }
                    OS.g_slist_free(l4);
                }
            };
            NativeGetCookie = new Runnable(){

                public void run() {
                    long l;
                    if (!LibraryLoaded) {
                        return;
                    }
                    long l2 = WebKitGTK.webkit_get_default_session();
                    long l3 = WebKitGTK.soup_session_get_feature(l2, l = WebKitGTK.soup_cookie_jar_get_type());
                    if (l3 == 0L) {
                        return;
                    }
                    byte[] byArray = Converter.wcsToMbcs(null, CookieUrl, true);
                    long l4 = WebKitGTK.soup_uri_new(byArray);
                    if (l4 == 0L) {
                        return;
                    }
                    long l5 = WebKitGTK.soup_cookie_jar_get_cookies(l3, l4, 0);
                    WebKitGTK.soup_uri_free(l4);
                    if (l5 == 0L) {
                        return;
                    }
                    int n = OS.strlen(l5);
                    byArray = new byte[n];
                    C.memmove(byArray, l5, (long)n);
                    OS.g_free(l5);
                    String string = new String(Converter.mbcsToWcs(null, byArray));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2;
                        String string3 = stringTokenizer.nextToken();
                        int n2 = string3.indexOf(61);
                        if (n2 == -1 || !(string2 = string3.substring(0, n2).trim()).equals(CookieName)) continue;
                        CookieValue = string3.substring(n2 + 1).trim();
                        return;
                    }
                }
            };
            NativeSetCookie = new Runnable(){

                public void run() {
                    long l;
                    if (!LibraryLoaded) {
                        return;
                    }
                    long l2 = WebKitGTK.webkit_get_default_session();
                    long l3 = WebKitGTK.soup_session_get_feature(l2, l = WebKitGTK.soup_cookie_jar_get_type());
                    if (l3 == 0L) {
                        WebKitGTK.soup_session_add_feature_by_type(l2, l);
                        l3 = WebKitGTK.soup_session_get_feature(l2, l);
                    }
                    if (l3 == 0L) {
                        return;
                    }
                    byte[] byArray = Converter.wcsToMbcs(null, CookieUrl, true);
                    long l4 = WebKitGTK.soup_uri_new(byArray);
                    if (l4 == 0L) {
                        return;
                    }
                    byArray = Converter.wcsToMbcs(null, CookieValue, true);
                    long l5 = WebKitGTK.soup_cookie_parse(byArray, l4);
                    if (l5 != 0L) {
                        WebKitGTK.soup_cookie_jar_add_cookie(l3, l5);
                        CookieResult = true;
                    }
                    WebKitGTK.soup_uri_free(l4);
                }
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
                NativePendingCookies = null;
            }
        }
    }

    WebKit() {
    }

    static Browser findBrowser(long l) {
        if (l == 0L) {
            return null;
        }
        long l2 = OS.gtk_widget_get_parent(l);
        l2 = OS.gtk_widget_get_parent(l2);
        return (Browser)Display.getCurrent().findWidget(l2);
    }

    static boolean isInstalled() {
        if (!LibraryLoaded) {
            return false;
        }
        int n = WebKitGTK.webkit_major_version();
        int n2 = WebKitGTK.webkit_minor_version();
        int n3 = WebKitGTK.webkit_micro_version();
        return n > MIN_VERSION[0] || n == MIN_VERSION[0] && n2 > MIN_VERSION[1] || n == MIN_VERSION[0] && n2 == MIN_VERSION[1] && n3 >= MIN_VERSION[2];
    }

    static long JSObjectCallAsFunctionProc(long l, long l2, long l3, long l4, long l5, long l6) {
        if (WebKitGTK.JSValueIsObjectOfClass(l, l3, ExternalClass) == 0) {
            return WebKitGTK.JSValueMakeUndefined(l);
        }
        long l7 = WebKitGTK.JSObjectGetPrivate(l3);
        long[] lArray = new long[1];
        C.memmove(lArray, l7, (long)C.PTR_SIZEOF);
        Browser browser = WebKit.findBrowser(lArray[0]);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.callJava(l, l2, l3, l4, l5, l6);
    }

    static long JSObjectGetPropertyProc(long l, long l2, long l3, long l4) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        long l5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        long l6 = WebKitGTK.JSObjectMakeFunctionWithCallback(l, l5, JSObjectCallAsFunctionProc.getAddress());
        WebKitGTK.JSStringRelease(l5);
        return l6;
    }

    static long JSObjectHasPropertyProc(long l, long l2, long l3) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        return WebKitGTK.JSStringIsEqualToUTF8CString(l3, byArray);
    }

    static long Proc(long l, long l2) {
        Browser browser = WebKit.findBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2);
    }

    static long Proc(long l, long l2, long l3) {
        if (OS.GTK_IS_SCROLLED_WINDOW(l)) {
            return l3;
        }
        long l4 = WebKitGTK.WEBKIT_IS_WEB_FRAME(l) ? WebKitGTK.webkit_web_frame_get_web_view(l) : l;
        Browser browser = WebKit.findBrowser(l4);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (l4 == l) {
            return webKit.webViewProc(l, l2, l3);
        }
        return webKit.webFrameProc(l, l2, l3);
    }

    static long Proc(long l, long l2, long l3, long l4) {
        Browser browser = WebKit.findBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2, l3, l4);
    }

    static long Proc(long l, long l2, long l3, long l4, long l5) {
        long l6 = WebKitGTK.SOUP_IS_SESSION(l) ? l5 : l;
        Browser browser = WebKit.findBrowser(l6);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (l6 == l) {
            return webKit.webViewProc(l, l2, l3, l4, l5);
        }
        return webKit.sessionProc(l, l2, l3, l4, l5);
    }

    static long Proc(long l, long l2, long l3, long l4, long l5, long l6) {
        Browser browser = WebKit.findBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2, l3, l4, l5, l6);
    }

    long sessionProc(long l, long l2, long l3, long l4, long l5) {
        if (l4 == 0L) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0L;
        }
        long l6 = WebKitGTK.soup_message_get_uri(l2);
        long l7 = WebKitGTK.soup_uri_to_string(l6, 0);
        int n = C.strlen(l7);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l7, (long)n);
        OS.g_free(l7);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        int n2 = 0;
        while (n2 < this.authenticationListeners.length) {
            AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
            authenticationEvent.location = string;
            this.authenticationListeners[n2].authenticate(authenticationEvent);
            if (!authenticationEvent.doit) {
                OS.g_signal_stop_emission_by_name(l, WebKitGTK.authenticate);
                return 0L;
            }
            if (authenticationEvent.user != null && authenticationEvent.password != null) {
                byte[] byArray2 = Converter.wcsToMbcs(null, authenticationEvent.user, true);
                byte[] byArray3 = Converter.wcsToMbcs(null, authenticationEvent.password, true);
                WebKitGTK.soup_auth_authenticate(l3, byArray2, byArray3);
                OS.g_signal_stop_emission_by_name(l, WebKitGTK.authenticate);
                return 0L;
            }
            ++n2;
        }
        return 0L;
    }

    long webFrameProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 9: {
                return this.webframe_notify_load_status(l, l2);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2) {
        switch ((int)l2) {
            case 13: {
                return this.webkit_close_web_view(l);
            }
            case 8: {
                return this.webkit_web_view_ready(l);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 7: {
                return this.webkit_create_web_view(l, l2);
            }
            case 11: {
                return this.webkit_download_requested(l, l2);
            }
            case 9: {
                return this.webkit_notify_load_status(l, l2);
            }
            case 2: {
                return this.webkit_notify_progress(l, l2);
            }
            case 4: {
                return this.webkit_notify_title(l, l2);
            }
            case 5: {
                return this.webkit_populate_popup(l, l2);
            }
            case 6: {
                return this.webkit_status_bar_text_changed(l, l2);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4) {
        switch ((int)l4) {
            case 1: {
                return this.webkit_hovering_over_link(l, l2, l3);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4, long l5) {
        switch ((int)l5) {
            case 15: {
                return this.webkit_console_message(l, l2, l3, l4);
            }
            case 14: {
                return this.webkit_window_object_cleared(l, l2, l3, l4);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4, long l5, long l6) {
        switch ((int)l6) {
            case 12: {
                return this.webkit_mime_type_policy_decision_requested(l, l2, l3, l4, l5);
            }
            case 3: {
                return this.webkit_navigation_policy_decision_requested(l, l2, l3, l4, l5);
            }
            case 10: {
                return this.webkit_resource_request_starting(l, l2, l3, l4, l5);
            }
        }
        return 0L;
    }

    public void create(Composite composite, int n) {
        if (ExternalClass == 0L) {
            if (Device.DEBUG) {
                int n2 = WebKitGTK.webkit_major_version();
                int n3 = WebKitGTK.webkit_minor_version();
                int n4 = WebKitGTK.webkit_micro_version();
                System.out.println("WebKit version " + n2 + "." + n3 + "." + n4);
            }
            JSClassDefinition jSClassDefinition = new JSClassDefinition();
            byte[] byArray = Converter.wcsToMbcs(null, CLASSNAME_EXTERNAL, true);
            jSClassDefinition.className = C.malloc(byArray.length);
            OS.memmove(jSClassDefinition.className, byArray, (long)byArray.length);
            jSClassDefinition.hasProperty = JSObjectHasPropertyProc.getAddress();
            jSClassDefinition.getProperty = JSObjectGetPropertyProc.getAddress();
            long l = C.malloc(JSClassDefinition.sizeof);
            WebKitGTK.memmove(l, jSClassDefinition, (long)JSClassDefinition.sizeof);
            ExternalClass = WebKitGTK.JSClassCreate(l);
            byArray = Converter.wcsToMbcs(null, "POST", true);
            PostString = C.malloc(byArray.length);
            C.memmove(PostString, byArray, (long)byArray.length);
        }
        this.scrolledWindow = OS.gtk_scrolled_window_new(0L, 0L);
        OS.gtk_scrolled_window_set_policy(this.scrolledWindow, 1, 1);
        this.webView = WebKitGTK.webkit_web_view_new();
        this.webViewData = C.malloc(C.PTR_SIZEOF);
        C.memmove(this.webViewData, new long[]{this.webView}, (long)C.PTR_SIZEOF);
        OS.gtk_container_add(this.scrolledWindow, this.webView);
        OS.gtk_container_add(this.browser.handle, this.scrolledWindow);
        OS.gtk_widget_show(this.scrolledWindow);
        OS.gtk_widget_show(this.webView);
        OS.g_signal_connect(this.webView, WebKitGTK.close_web_view, Proc2.getAddress(), 13L);
        OS.g_signal_connect(this.webView, WebKitGTK.console_message, Proc5.getAddress(), 15L);
        OS.g_signal_connect(this.webView, WebKitGTK.create_web_view, Proc3.getAddress(), 7L);
        OS.g_signal_connect(this.webView, WebKitGTK.download_requested, Proc3.getAddress(), 11L);
        OS.g_signal_connect(this.webView, WebKitGTK.hovering_over_link, Proc4.getAddress(), 1L);
        OS.g_signal_connect(this.webView, WebKitGTK.mime_type_policy_decision_requested, Proc6.getAddress(), 12L);
        OS.g_signal_connect(this.webView, WebKitGTK.navigation_policy_decision_requested, Proc6.getAddress(), 3L);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_load_status, Proc3.getAddress(), 9L);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_progress, Proc3.getAddress(), 2L);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 4L);
        OS.g_signal_connect(this.webView, WebKitGTK.populate_popup, Proc3.getAddress(), 5L);
        OS.g_signal_connect(this.webView, WebKitGTK.resource_request_starting, Proc6.getAddress(), 10L);
        OS.g_signal_connect(this.webView, WebKitGTK.status_bar_text_changed, Proc3.getAddress(), 6L);
        OS.g_signal_connect(this.webView, WebKitGTK.web_view_ready, Proc2.getAddress(), 8L);
        OS.g_signal_connect(this.webView, WebKitGTK.window_object_cleared, Proc5.getAddress(), 14L);
        OS.g_signal_connect(this.scrolledWindow, OS.event, Proc3.getAddress(), 0L);
        OS.g_signal_connect(this.scrolledWindow, OS.button_press_event, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.scrolledWindow, OS.button_release_event, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.scrolledWindow, OS.key_press_event, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.scrolledWindow, OS.key_release_event, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.scrolledWindow, OS.scroll_event, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.scrolledWindow, OS.motion_notify_event, Proc3.getAddress(), 1L);
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(l, WebKitGTK.javascript_can_open_windows_automatically, 1, 0L);
        OS.g_object_set(l, WebKitGTK.enable_universal_access_from_file_uris, 1, 0L);
        byte[] byArray = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
        OS.g_object_set(l, WebKitGTK.default_encoding, byArray, 0L);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        WebKit.this.onDispose(event);
                        break;
                    }
                    case 15: {
                        OS.gtk_widget_grab_focus(WebKit.this.webView);
                        break;
                    }
                    case 11: {
                        WebKit.this.onResize(event);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        long l2 = WebKitGTK.webkit_get_default_session();
        long l3 = WebKitGTK.soup_session_get_feature(l2, WebKitGTK.webkit_soup_auth_dialog_get_type());
        WebKitGTK.soup_session_feature_detach(l3, l2);
        OS.g_signal_connect(l2, WebKitGTK.authenticate, Proc5.getAddress(), this.webView);
        WebKitGTK.soup_session_feature_attach(l3, l2);
        String string = System.getProperty(PROPERTY_PROXYHOST);
        String string2 = System.getProperty(PROPERTY_PROXYPORT);
        int n5 = -1;
        if (string2 != null) {
            try {
                int n6 = Integer.valueOf(string2);
                if (n6 >= 0 && n6 <= 65535) {
                    n5 = n6;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (string != null || n5 != -1) {
            long l4;
            if (!string.startsWith(PROTOCOL_HTTP)) {
                string = PROTOCOL_HTTP + string;
            }
            if ((l4 = WebKitGTK.soup_uri_new(byArray = Converter.wcsToMbcs(null, string = String.valueOf(string) + ":" + n5, true))) != 0L) {
                OS.g_object_set(l2, WebKitGTK.SOUP_SESSION_PROXY_URI, l4, 0L);
                WebKitGTK.soup_uri_free(l4);
            }
        }
        this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

            public Object function(Object[] objectArray) {
                return WebKit.this.handleEvent(objectArray) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
    }

    void addEventHandlers(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('keydown', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            this.execute(stringBuffer.toString());
            stringBuffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button + 1, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            this.execute(stringBuffer.toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            stringBuffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            stringBuffer.append('}');
            this.execute(stringBuffer.toString());
        }
    }

    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        if (!this.jsEnabled) {
            return true;
        }
        String string = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String string2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String string3 = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string3);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = confirm('");
            stringBuffer.append(string);
            stringBuffer.append("\\n\\n'+str+'\\n\\n");
            stringBuffer.append(string2);
            stringBuffer.append("');");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string3);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        Boolean bl2 = (Boolean)this.evaluate("return " + string3 + "(window);");
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    public boolean execute(String string) {
        long l = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        long l2 = WebKitGTK.webkit_web_frame_get_global_context(l);
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        long l3 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        try {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, this.getUrl(), true);
        }
        long l4 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        long l5 = WebKitGTK.JSEvaluateScript(l2, l3, 0L, l4, 0, null);
        WebKitGTK.JSStringRelease(l4);
        WebKitGTK.JSStringRelease(l3);
        return l5 != 0L;
    }

    public boolean forward() {
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        long l = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        long l2 = WebKitGTK.webkit_web_frame_get_data_source(l);
        if (l2 == 0L) {
            return "";
        }
        long l3 = WebKitGTK.webkit_web_data_source_get_data(l2);
        if (l3 == 0L) {
            return "";
        }
        long l4 = WebKitGTK.webkit_web_data_source_get_encoding(l2);
        int n = OS.strlen(l4);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l4, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        n = OS.GString_len(l3);
        byArray = new byte[n];
        long l5 = OS.GString_str(l3);
        C.memmove(byArray, l5, (long)n);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(Converter.mbcsToWcs(null, byArray));
        }
    }

    public String getUrl() {
        long l = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (l == 0L) {
            return ABOUT_BLANK;
        }
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        return string;
    }

    boolean handleEvent(Object[] objectArray) {
        int n;
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN)) {
            int n2;
            this.lastKeyCode = n2 = this.translateKey(((Double)objectArray[1]).intValue());
            switch (n2) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n2;
                    switch (n2) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
                    event.stateMask &= ~n2;
                    final int n3 = event.stateMask;
                    if (!this.sendKeyEvent(event) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || n2 != 9 || (n3 & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (WebKit.this.browser.isDisposed()) {
                                return;
                            }
                            if (WebKit.this.browser.getDisplay().getFocusControl() == null) {
                                int n = (n3 & 0x20000) != 0 ? 8 : 16;
                                WebKit.this.browser.traverse(n);
                            }
                        }
                    });
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = ((Double)objectArray[2]).intValue();
            if (((Boolean)objectArray[4]).booleanValue() && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if (string.equals(DOMEVENT_KEYUP)) {
            int n4 = this.translateKey(((Double)objectArray[1]).intValue());
            if (n4 == 0) {
                return true;
            }
            if (n4 != this.lastKeyCode) {
                this.lastKeyCode = n4;
                this.lastCharCode = 0;
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 2;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    event.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(event.type, event);
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            return event.doit && !this.browser.isDisposed();
        }
        Point point = new Point(((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue());
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n = ((Boolean)objectArray[5] != false ? 65536 : 0) | ((Boolean)objectArray[6] != false ? 262144 : 0) | ((Boolean)objectArray[7] != false ? 131072 : 0) | ((Boolean)objectArray[8] != false ? 0x400000 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (((Double)objectArray[3]).intValue() == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n;
                event.count = ((Double)objectArray[3]).intValue();
                event.button = ((Double)objectArray[4]).intValue();
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = ((Double)objectArray[3]).intValue();
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = ((Double)objectArray[4]).intValue() + 1;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
            this.browser.notifyListeners(event.type, event);
            return false;
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    long handleLoadCommitted(long l, boolean bl) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        if (bl && string.startsWith(ABOUT_BLANK) && this.htmlBytes != null) {
            return 0L;
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.top = bl;
        int n2 = 0;
        while (n2 < this.locationListeners.length) {
            this.locationListeners[n2].changed(locationEvent);
            ++n2;
        }
        return 0L;
    }

    long handleLoadFinished(long l, boolean bl) {
        Object object;
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        if (bl && this.htmlBytes != null && string.startsWith(ABOUT_BLANK)) {
            this.loadingText = true;
            object = Converter.wcsToMbcs(null, "text/html", true);
            byte[] byArray2 = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
            byte[] byArray3 = this.untrustedText ? Converter.wcsToMbcs(null, ABOUT_BLANK, true) : Converter.wcsToMbcs(null, URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_string(this.webView, this.htmlBytes, (byte[])object, byArray2, byArray3);
            this.htmlBytes = null;
        }
        if (!this.loadingText) {
            long l2;
            long l3;
            if (bl && (l3 = WebKitGTK.webkit_web_frame_get_title(l2 = WebKitGTK.webkit_web_view_get_main_frame(this.webView))) == 0L) {
                TitleEvent titleEvent = new TitleEvent(this.browser);
                titleEvent.display = this.browser.getDisplay();
                titleEvent.widget = this.browser;
                titleEvent.title = string;
                int n2 = 0;
                while (n2 < this.titleListeners.length) {
                    this.titleListeners[n2].changed(titleEvent);
                    ++n2;
                }
                if (this.browser.isDisposed()) {
                    return 0L;
                }
            }
            object = new ProgressEvent(this.browser);
            ((ProgressEvent)object).display = this.browser.getDisplay();
            ((ProgressEvent)object).widget = this.browser;
            ((ProgressEvent)object).current = 100;
            ((ProgressEvent)object).total = 100;
            int n3 = 0;
            while (n3 < this.progressListeners.length) {
                this.progressListeners[n3].completed((ProgressEvent)object);
                ++n3;
            }
        }
        this.loadingText = false;
        return 0L;
    }

    public boolean isBackEnabled() {
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event event) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            ((BrowserFunction)enumeration.nextElement()).dispose(false);
        }
        this.functions = null;
        C.free(this.webViewData);
        this.postData = null;
        this.headers = null;
        this.htmlBytes = null;
    }

    void onResize(Event event) {
        Rectangle rectangle = this.browser.getClientArea();
        OS.gtk_widget_set_size_request(this.scrolledWindow, rectangle.width, rectangle.height);
    }

    void openDownloadWindow(final long l) {
        final Shell shell = new Shell();
        String string = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        long l2 = WebKitGTK.webkit_download_get_suggested_filename(l);
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        long l3 = WebKitGTK.webkit_download_get_uri(l);
        n = OS.strlen(l3);
        byArray = new byte[n];
        OS.memmove(byArray, l3, (long)n);
        String string3 = new String(Converter.mbcsToWcs(null, byArray));
        string = Compatibility.getMessage("SWT_Download_Location", new Object[]{string2, string3});
        Label label = new Label(shell, 64);
        label.setText(string);
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n2 = monitor.getBounds().width / 2;
        int n3 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n3, n2);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WebKitGTK.webkit_download_cancel(l);
            }
        };
        button.addListener(13, listener);
        OS.g_object_ref(l);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            public void run() {
                int n = WebKitGTK.webkit_download_get_status(l);
                if (shell.isDisposed() || n == 3 || n == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(l);
                    return;
                }
                if (n == -1) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(l);
                    button.removeListener(13, listener);
                    button.addListener(13, new Listener(this, shell){
                        final /* synthetic */ 8 this$1;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$shell = shell;
                        }

                        public void handleEvent(Event event) {
                            this.val$shell.dispose();
                        }
                    });
                    return;
                }
                long l3 = WebKitGTK.webkit_download_get_current_size(l) / 1024L;
                long l2 = WebKitGTK.webkit_download_get_total_size(l) / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(l3), new Long(l2)});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    public void refresh() {
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    public boolean setText(String string, boolean bl) {
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        boolean bl2 = this.htmlBytes != null;
        this.htmlBytes = byArray;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        byte[] byArray2 = Converter.wcsToMbcs(null, ABOUT_BLANK, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray2);
        return true;
    }

    public boolean setUrl(String string, String string2, String[] stringArray) {
        this.postData = string2;
        this.headers = stringArray;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = null;
            string3 = string.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + string : PROTOCOL_HTTP + string;
            try {
                new URL(string3);
                string = string3;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                String string4 = stringArray[n];
                if (string4 != null && (n2 = string4.indexOf(58)) != -1) {
                    String string5 = string4.substring(0, n2).trim();
                    String string6 = string4.substring(n2 + 1).trim();
                    if (string5.length() > 0 && string6.length() > 0 && string5.equalsIgnoreCase(USER_AGENT)) {
                        byte[] byArray = Converter.wcsToMbcs(null, string6, true);
                        OS.g_object_set(l, WebKitGTK.user_agent, byArray, 0L);
                    }
                }
                ++n;
            }
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray);
        OS.g_object_set(l, WebKitGTK.user_agent, 0, 0L);
        return true;
    }

    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    long webframe_notify_load_status(long l, long l2) {
        int n = WebKitGTK.webkit_web_frame_get_load_status(l);
        switch (n) {
            case 1: {
                long l3 = WebKitGTK.webkit_web_frame_get_uri(l);
                return this.handleLoadCommitted(l3, false);
            }
            case 2: {
                long l4 = WebKitGTK.webkit_web_frame_get_parent(l);
                if (WebKitGTK.webkit_web_frame_get_load_status(l4) != 2) break;
                long l5 = WebKitGTK.webkit_web_frame_get_uri(l);
                return this.handleLoadFinished(l5, false);
            }
        }
        return 0L;
    }

    long webkit_close_web_view(long l) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n = 0;
        while (n < this.closeWindowListeners.length) {
            this.closeWindowListeners[n].close(windowEvent);
            ++n;
        }
        this.browser.dispose();
        return 0L;
    }

    long webkit_console_message(long l, long l2, long l3, long l4) {
        return 1L;
    }

    long webkit_create_web_view(long l, long l2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            int n = 0;
            while (n < this.openWindowListeners.length) {
                this.openWindowListeners[n].open(windowEvent);
                ++n;
            }
        }
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            return ((WebKit)((Browser)widget).webBrowser).webView;
        }
        return 0L;
    }

    long webkit_download_requested(long l, long l2) {
        long l3 = WebKitGTK.webkit_download_get_suggested_filename(l2);
        int n = OS.strlen(l3);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l3, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 4096);
        fileDialog.setFileName(string);
        String string2 = Compatibility.getMessage("SWT_FileDownload");
        fileDialog.setText(string2);
        String string3 = fileDialog.open();
        if (string3 != null) {
            string3 = URI_FILEROOT + string3;
            byte[] byArray2 = Converter.wcsToMbcs(null, string3, true);
            WebKitGTK.webkit_download_set_destination_uri(l2, byArray2);
            this.openDownloadWindow(l2);
        } else {
            WebKitGTK.webkit_download_cancel(l2);
        }
        return 1L;
    }

    long webkit_hovering_over_link(long l, long l2, long l3) {
        if (l3 != 0L) {
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            int n2 = 0;
            while (n2 < this.statusTextListeners.length) {
                this.statusTextListeners[n2].changed(statusTextEvent);
                ++n2;
            }
        }
        return 0L;
    }

    long webkit_mime_type_policy_decision_requested(long l, long l2, long l3, long l4, long l5) {
        boolean bl;
        boolean bl2 = bl = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, l4) != 0;
        if (!bl) {
            WebKitGTK.webkit_web_policy_decision_download(l5);
            return 1L;
        }
        return 0L;
    }

    long webkit_navigation_policy_decision_requested(long l, long l2, long l3, long l4, long l5) {
        if (this.loadingText) {
            return 0L;
        }
        long l6 = WebKitGTK.webkit_network_request_get_uri(l3);
        int n = OS.strlen(l6);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l6, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            int n2 = 0;
            while (n2 < this.locationListeners.length) {
                this.locationListeners[n2].changing(locationEvent);
                ++n2;
            }
        }
        if (locationEvent.doit && !this.browser.isDisposed()) {
            int n3;
            long l7;
            if (this.jsEnabledChanged) {
                this.jsEnabledChanged = false;
                long l8 = WebKitGTK.webkit_web_view_get_settings(this.webView);
                OS.g_object_set(l8, WebKitGTK.enable_scripts, this.jsEnabled ? 1 : 0, 0L);
            }
            if (l2 != (l7 = WebKitGTK.webkit_web_view_get_main_frame(this.webView)) && (n3 = OS.g_signal_handler_find(l2, 24, 0, 0, 0L, Proc3.getAddress(), 9L)) == 0) {
                OS.g_signal_connect(l2, WebKitGTK.notify_load_status, Proc3.getAddress(), 9L);
            }
        } else {
            WebKitGTK.webkit_web_policy_decision_ignore(l5);
        }
        return 0L;
    }

    long webkit_notify_load_status(long l, long l2) {
        int n = WebKitGTK.webkit_web_view_get_load_status(this.webView);
        switch (n) {
            case 1: {
                long l3 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(l3, true);
            }
            case 2: {
                long l4 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadFinished(l4, true);
            }
        }
        return 0L;
    }

    long webkit_notify_progress(long l, long l2) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.current = (int)(WebKitGTK.webkit_web_view_get_progress(this.webView) * 100.0);
        progressEvent.total = 100;
        int n = 0;
        while (n < this.progressListeners.length) {
            this.progressListeners[n].changed(progressEvent);
            ++n;
        }
        return 0L;
    }

    long webkit_notify_title(long l, long l2) {
        String string;
        long l3 = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (l3 == 0L) {
            string = "";
        } else {
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            string = new String(Converter.mbcsToWcs(null, byArray));
        }
        TitleEvent titleEvent = new TitleEvent(this.browser);
        titleEvent.display = this.browser.getDisplay();
        titleEvent.widget = this.browser;
        titleEvent.title = string;
        int n = 0;
        while (n < this.titleListeners.length) {
            this.titleListeners[n].changed(titleEvent);
            ++n;
        }
        return 0L;
    }

    long webkit_populate_popup(long l, long l2) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            long l3;
            long l4 = l3 = OS.gtk_container_get_children(l2);
            while (l4 != 0L) {
                long l5 = OS.g_list_data(l4);
                OS.gtk_container_remove(l2, l5);
                l4 = OS.g_list_next(l4);
            }
            OS.g_list_free(l3);
            return 0L;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            long l6;
            if (point.x != event.x || point.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            long l7 = l6 = OS.gtk_container_get_children(l2);
            while (l7 != 0L) {
                long l8 = OS.g_list_data(l7);
                OS.gtk_container_remove(l2, l8);
                l7 = OS.g_list_next(l7);
            }
            OS.g_list_free(l6);
        }
        return 0L;
    }

    long webkit_resource_request_starting(long l, long l2, long l3, long l4, long l5) {
        if (this.postData != null || this.headers != null) {
            long l6 = WebKitGTK.webkit_network_request_get_message(l4);
            if (l6 == 0L) {
                this.headers = null;
                this.postData = null;
            } else {
                String[] stringArray;
                long l7;
                if (this.postData != null) {
                    WebKitGTK.SoupMessage_method(l6, PostString);
                    l7 = WebKitGTK.SoupMessage_request_body(l6);
                    byte[] byArray = Converter.wcsToMbcs(null, this.postData, false);
                    long l8 = C.malloc(byArray.length);
                    C.memmove(l8, byArray, (long)byArray.length);
                    WebKitGTK.soup_message_body_append(l7, 1, l8, byArray.length);
                    WebKitGTK.soup_message_body_flatten(l7);
                    if (this.headers == null) {
                        this.headers = new String[0];
                    }
                    stringArray = new String[this.headers.length + 1];
                    System.arraycopy(this.headers, 0, stringArray, 0, this.headers.length);
                    stringArray[this.headers.length] = ENCODING_FORM;
                    this.headers = stringArray;
                    this.postData = null;
                }
                l7 = WebKitGTK.SoupMessage_request_headers(l6);
                int n = 0;
                while (n < this.headers.length) {
                    int n2;
                    String string = this.headers[n];
                    if (string != null && (n2 = string.indexOf(58)) != -1) {
                        stringArray = string.substring(0, n2).trim();
                        String string2 = string.substring(n2 + 1).trim();
                        if (stringArray.length() > 0 && string2.length() > 0) {
                            byte[] byArray = Converter.wcsToMbcs(null, (String)stringArray, true);
                            byte[] byArray2 = Converter.wcsToMbcs(null, string2, true);
                            WebKitGTK.soup_message_headers_append(l7, byArray, byArray2);
                        }
                    }
                    ++n;
                }
                this.headers = null;
            }
        }
        return 0L;
    }

    long webkit_status_bar_text_changed(long l, long l2) {
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(Converter.mbcsToWcs(null, byArray));
        int n2 = 0;
        while (n2 < this.statusTextListeners.length) {
            this.statusTextListeners[n2].changed(statusTextEvent);
            ++n2;
        }
        return 0L;
    }

    long webkit_web_view_ready(long l) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        long l2 = WebKitGTK.webkit_web_view_get_window_features(this.webView);
        int[] nArray = new int[1];
        OS.g_object_get(l2, WebKitGTK.locationbar_visible, nArray, 0L);
        windowEvent.addressBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.menubar_visible, nArray, 0L);
        windowEvent.menuBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.statusbar_visible, nArray, 0L);
        windowEvent.statusBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.toolbar_visible, nArray, 0L);
        windowEvent.toolBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.x, nArray, 0L);
        int n = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.y, nArray, 0L);
        int n2 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.width, nArray, 0L);
        int n3 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(l2, WebKitGTK.height, nArray, 0L);
        int n4 = nArray[0];
        nArray[0] = 0;
        if (n != -1 && n2 != -1) {
            windowEvent.location = new Point(n, n2);
        }
        if (n3 != -1 && n4 != -1) {
            windowEvent.size = new Point(n3, n4);
        }
        int n5 = 0;
        while (n5 < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[n5].show(windowEvent);
            ++n5;
        }
        return 0L;
    }

    long webkit_window_object_cleared(long l, long l2, long l3, long l4) {
        long l5 = WebKitGTK.JSContextGetGlobalObject(l3);
        long l6 = WebKitGTK.JSObjectMake(l3, ExternalClass, this.webViewData);
        byte[] byArray = null;
        try {
            byArray = "external\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, OBJECTNAME_EXTERNAL, true);
        }
        long l7 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        WebKitGTK.JSObjectSetProperty(l3, l5, l7, l6, 0, null);
        WebKitGTK.JSStringRelease(l7);
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            BrowserFunction browserFunction = (BrowserFunction)enumeration.nextElement();
            this.execute(browserFunction.functionString);
        }
        long l8 = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        boolean bl = l8 == l2;
        this.addEventHandlers(bl);
        return 0L;
    }

    long callJava(long l, long l2, long l3, long l4, long l5, long l6) {
        Object object = null;
        if (l4 == 3L) {
            long[] lArray = new long[1];
            C.memmove(lArray, l5, (long)C.PTR_SIZEOF);
            int n = WebKitGTK.JSValueGetType(l, lArray[0]);
            if (n == 3) {
                int n2 = ((Double)this.convertToJava(l, lArray[0])).intValue();
                lArray[0] = 0L;
                Integer n3 = new Integer(n2);
                C.memmove(lArray, l5 + (long)C.PTR_SIZEOF, (long)C.PTR_SIZEOF);
                n = WebKitGTK.JSValueGetType(l, lArray[0]);
                if (n == 3) {
                    long l7 = ((Double)this.convertToJava(l, lArray[0])).longValue();
                    BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n3);
                    if (browserFunction != null && l7 == browserFunction.token) {
                        try {
                            C.memmove(lArray, l5 + (long)(2 * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
                            Object object2 = this.convertToJava(l, lArray[0]);
                            if (object2 instanceof Object[]) {
                                Object[] objectArray = (Object[])object2;
                                try {
                                    object = browserFunction.function(objectArray);
                                }
                                catch (Exception exception) {
                                    object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                                }
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (browserFunction.isEvaluate) {
                                browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                            }
                            object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        return this.convertToJS(l, object);
    }

    long convertToJS(long l, Object object) {
        if (object == null) {
            return WebKitGTK.JSValueMakeUndefined(l);
        }
        if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = (String.valueOf((String)object) + '\u0000').getBytes(CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = Converter.wcsToMbcs(null, (String)object, true);
            }
            long l2 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
            long l3 = WebKitGTK.JSValueMakeString(l, l2);
            WebKitGTK.JSStringRelease(l2);
            return l3;
        }
        if (object instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(l, (Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(l, ((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                long l4;
                Object object2 = objectArray[n2];
                lArray[n2] = l4 = this.convertToJS(l, object2);
                ++n2;
            }
            return WebKitGTK.JSObjectMakeArray(l, n, lArray, null);
        }
        SWT.error(51);
        return 0L;
    }

    Object convertToJava(long l, long l2) {
        int n = WebKitGTK.JSValueGetType(l, l2);
        switch (n) {
            case 2: {
                int n2 = (int)WebKitGTK.JSValueToNumber(l, l2, null);
                return new Boolean(n2 != 0);
            }
            case 3: {
                double d = WebKitGTK.JSValueToNumber(l, l2, null);
                return new Double(d);
            }
            case 4: {
                long l3 = WebKitGTK.JSValueToStringCopy(l, l2, null);
                if (l3 == 0L) {
                    return "";
                }
                long l4 = WebKitGTK.JSStringGetMaximumUTF8CStringSize(l3);
                byte[] byArray = new byte[(int)l4];
                l4 = WebKitGTK.JSStringGetUTF8CString(l3, byArray, l4);
                WebKitGTK.JSStringRelease(l3);
                try {
                    return new String(byArray, 0, (int)l4 - 1, CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(Converter.mbcsToWcs(null, byArray));
                }
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = null;
                try {
                    byArray = "length\u0000".getBytes(CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = Converter.wcsToMbcs(null, PROPERTY_LENGTH, true);
                }
                long l5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
                long l6 = WebKitGTK.JSObjectGetProperty(l, l2, l5, null);
                WebKitGTK.JSStringRelease(l5);
                n = WebKitGTK.JSValueGetType(l, l6);
                if (n != 3) break;
                int n3 = (int)WebKitGTK.JSValueToNumber(l, l6, null);
                Object[] objectArray = new Object[n3];
                int n4 = 0;
                while (n4 < n3) {
                    long l7 = WebKitGTK.JSObjectGetPropertyAtIndex(l, l2, n4, null);
                    if (l7 != 0L) {
                        objectArray[n4] = this.convertToJava(l, l7);
                    }
                    ++n4;
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }
}

