/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.profile.Profile;
import jrm.profile.fix.actions.BackupContainer;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.scan.Scan;
import jrm.ui.progress.ProgressHandler;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class Fix {
    private final Scan curr_scan;

    public Fix(Profile curr_profile, Scan curr_scan, ProgressHandler progress) {
        this.curr_scan = curr_scan;
        boolean use_parallelism = curr_profile.getProperty("use_parallelism", false);
        long start = System.currentTimeMillis();
        AtomicInteger i = new AtomicInteger(0);
        AtomicInteger max = new AtomicInteger(0);
        curr_scan.actions.forEach((Consumer<Collection<ContainerAction>>)((Consumer<Collection>)actions -> max.addAndGet(actions.size())));
        progress.setProgress(Messages.getString("Fix.Fixing"), i.get(), max.get());
        curr_scan.actions.forEach((Consumer<Collection<ContainerAction>>)((Consumer<Collection>)actions -> {
            List done = Collections.synchronizedList(new ArrayList());
            progress.setInfos(use_parallelism ? Runtime.getRuntime().availableProcessors() : 1, use_parallelism);
            ((StreamEx)StreamEx.of(use_parallelism ? (Stream)actions.parallelStream().unordered() : actions.stream()).takeWhile(action -> !progress.isCancel())).forEach(action -> {
                try {
                    if (!action.doAction(progress)) {
                        progress.cancel();
                    } else {
                        done.add(action);
                    }
                    progress.setProgress(null, i.incrementAndGet());
                }
                catch (BreakException be) {
                    progress.cancel();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
            if (done.size() > 0 && done.get(0) instanceof BackupContainer) {
                BackupContainer.closeAllFS();
            }
            actions.removeAll(done);
            progress.clearInfos();
        }));
        progress.setInfos(1, false);
        curr_profile.nfo.stats.fixed = new Date();
        System.out.println("Fix total duration : " + DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start)));
    }

    public int getActionsRemain() {
        AtomicInteger actions_remain = new AtomicInteger(0);
        this.curr_scan.actions.forEach((Consumer<Collection<ContainerAction>>)((Consumer<Collection>)actions -> actions_remain.addAndGet(actions.size())));
        return actions_remain.get();
    }
}

