/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.torrent;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jrm.io.torrent.Torrent;
import jrm.io.torrent.TorrentFile;
import jrm.io.torrent.bencoding.Reader;
import jrm.io.torrent.bencoding.Utils;
import jrm.io.torrent.bencoding.types.BByteString;
import jrm.io.torrent.bencoding.types.BDictionary;
import jrm.io.torrent.bencoding.types.BInt;
import jrm.io.torrent.bencoding.types.BList;
import jrm.io.torrent.bencoding.types.IBencodable;

public class TorrentParser {
    public static Torrent parseTorrent(String filePath) throws IOException {
        Reader r = new Reader(new File(filePath));
        List<IBencodable> x = r.read();
        if (x.size() != 1) {
            throw new Error("Parsing .torrent yielded wrong number of bencoding structs.");
        }
        try {
            return TorrentParser.parseTorrent(x.get(0));
        }
        catch (ParseException e) {
            System.err.println("Error parsing torrent!");
            return null;
        }
    }

    private static Torrent parseTorrent(Object o) throws ParseException {
        if (o instanceof BDictionary) {
            BDictionary torrentDictionary = (BDictionary)o;
            BDictionary infoDictionary = TorrentParser.parseInfoDictionary(torrentDictionary);
            Torrent t = new Torrent();
            t.setAnnounce(TorrentParser.parseAnnounce(torrentDictionary));
            t.setInfo_hash(Utils.SHAsum(infoDictionary.bencode()));
            t.setName(TorrentParser.parseTorrentLocation(infoDictionary));
            t.setPieceLength(TorrentParser.parsePieceLength(infoDictionary));
            t.setPieces(TorrentParser.parsePiecesHashes(infoDictionary));
            t.setPiecesBlob(TorrentParser.parsePiecesBlob(infoDictionary));
            t.setFileList(TorrentParser.parseFileList(infoDictionary));
            t.setComment(TorrentParser.parseComment(torrentDictionary));
            t.setCreatedBy(TorrentParser.parseCreatorName(torrentDictionary));
            t.setCreationDate(TorrentParser.parseCreationDate(torrentDictionary));
            t.setAnnounceList(TorrentParser.parseAnnounceList(torrentDictionary));
            t.setTotalSize(TorrentParser.parseSingleFileTotalSize(infoDictionary));
            t.setSingleFileTorrent(null != infoDictionary.find(new BByteString("length")));
            return t;
        }
        throw new ParseException("Could not parse Object to BDictionary", 0);
    }

    private static Long parseSingleFileTotalSize(BDictionary info) {
        if (null != info.find(new BByteString("length"))) {
            return ((BInt)info.find(new BByteString("length"))).getValue();
        }
        return null;
    }

    private static BDictionary parseInfoDictionary(BDictionary dictionary) {
        if (null != dictionary.find(new BByteString("info"))) {
            return (BDictionary)dictionary.find(new BByteString("info"));
        }
        return null;
    }

    private static Date parseCreationDate(BDictionary dictionary) {
        if (null != dictionary.find(new BByteString("creation date"))) {
            return new Date(Long.parseLong(dictionary.find(new BByteString("creation date")).toString()));
        }
        return null;
    }

    private static String parseCreatorName(BDictionary dictionary) {
        if (null != dictionary.find(new BByteString("created by"))) {
            return dictionary.find(new BByteString("created by")).toString();
        }
        return null;
    }

    private static String parseComment(BDictionary dictionary) {
        if (null != dictionary.find(new BByteString("comment"))) {
            return dictionary.find(new BByteString("comment")).toString();
        }
        return null;
    }

    private static Long parsePieceLength(BDictionary info) {
        if (null != info.find(new BByteString("piece length"))) {
            return ((BInt)info.find(new BByteString("piece length"))).getValue();
        }
        return null;
    }

    private static String parseTorrentLocation(BDictionary info) {
        if (null != info.find(new BByteString("name"))) {
            return info.find(new BByteString("name")).toString();
        }
        return null;
    }

    private static String parseAnnounce(BDictionary dictionary) {
        if (null != dictionary.find(new BByteString("announce"))) {
            return dictionary.find(new BByteString("announce")).toString();
        }
        return null;
    }

    private static byte[] parsePiecesBlob(BDictionary info) {
        if (null != info.find(new BByteString("pieces"))) {
            return ((BByteString)info.find(new BByteString("pieces"))).getData();
        }
        throw new Error("Info dictionary does not contain pieces bytestring!");
    }

    private static List<String> parsePiecesHashes(BDictionary info) {
        if (null != info.find(new BByteString("pieces"))) {
            ArrayList<String> sha1HexRenders = new ArrayList<String>();
            byte[] piecesBlob = ((BByteString)info.find(new BByteString("pieces"))).getData();
            if (piecesBlob.length % 20 == 0) {
                int hashCount = piecesBlob.length / 20;
                for (int currHash = 0; currHash < hashCount; ++currHash) {
                    byte[] currHashByteBlob = Arrays.copyOfRange(piecesBlob, 20 * currHash, 20 * (currHash + 1));
                    String sha1 = Utils.bytesToHex(currHashByteBlob);
                    sha1HexRenders.add(sha1);
                }
            } else {
                throw new Error("Error parsing SHA1 piece hashes. Bytecount was not a multiple of 20.");
            }
            return sha1HexRenders;
        }
        throw new Error("Info dictionary does not contain pieces bytestring!");
    }

    private static List<TorrentFile> parseFileList(BDictionary info) {
        if (null != info.find(new BByteString("files"))) {
            ArrayList<TorrentFile> fileList = new ArrayList<TorrentFile>();
            BList filesBList = (BList)info.find(new BByteString("files"));
            Iterator<IBencodable> fileBDicts = filesBList.getIterator();
            while (fileBDicts.hasNext()) {
                IBencodable fileObject = fileBDicts.next();
                if (!(fileObject instanceof BDictionary)) continue;
                BDictionary fileBDict = (BDictionary)fileObject;
                BList filePaths = (BList)fileBDict.find(new BByteString("path"));
                BInt fileLength = (BInt)fileBDict.find(new BByteString("length"));
                LinkedList<String> paths = new LinkedList<String>();
                Iterator<IBencodable> filePathsIterator = filePaths.getIterator();
                while (filePathsIterator.hasNext()) {
                    paths.add(filePathsIterator.next().toString());
                }
                fileList.add(new TorrentFile(fileLength.getValue(), paths));
            }
            return fileList;
        }
        return null;
    }

    private static List<String> parseAnnounceList(BDictionary dictionary) {
        if (null != dictionary.find(new BByteString("announce-list"))) {
            LinkedList<String> announceUrls = new LinkedList<String>();
            BList announceList = (BList)dictionary.find(new BByteString("announce-list"));
            Iterator<IBencodable> subLists = announceList.getIterator();
            while (subLists.hasNext()) {
                BList subList = (BList)subLists.next();
                Iterator<IBencodable> elements = subList.getIterator();
                while (elements.hasNext()) {
                    BByteString tracker = (BByteString)elements.next();
                    announceUrls.add(tracker.toString());
                }
            }
            return announceUrls;
        }
        return null;
    }
}

