/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.naming.DXAttribute;
import com.ca.directory.jxplorer.editor.editablebinary;
import com.ca.directory.jxplorer.editor.editablestring;
import java.util.logging.Logger;

public class AttributeValue
implements editablebinary,
editablestring {
    DXAttribute baseAttribute;
    public Object value;
    Object backup;
    String[] options = null;
    boolean editable = true;
    private static final Logger log = Logger.getLogger(AttributeValue.class.getName());
    boolean naming;

    public AttributeValue(DXAttribute att, Object v) {
        this.baseAttribute = att;
        this.value = v;
        this.backup = v;
        this.naming = false;
        if (att.hasOptions()) {
            this.setOptions(att.getOptions());
        }
    }

    public AttributeValue(DXAttribute att, Object v, boolean editable) {
        this(att, v);
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public DXAttribute getBaseAttribute() {
        return this.baseAttribute;
    }

    public void setNamingStatus(boolean state) {
        this.naming = state;
    }

    public boolean isNaming() {
        return this.naming;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public void setOptions(String[] ops) {
        this.options = ops;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void update(Object data) {
        this.value = data;
        if (this.baseAttribute.isString()) {
            this.value = this.getStringValue();
        }
    }

    @Override
    public void setValue(byte[] b) {
        this.update(b);
    }

    @Override
    public void setStringValue(String b) {
        this.update(b);
    }

    @Override
    public byte[] getValue() {
        if (this.isNonStringData()) {
            if (this.value instanceof String) {
                log.warning("warning - Attribute Value " + this.value + " mis represented as byte array data");
                return null;
            }
            return (byte[])this.value;
        }
        return null;
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }

    public void reset() {
        this.value = this.backup;
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        if (this.isNonStringData()) {
            return this.value instanceof byte[] && ((byte[])this.value).length == 0;
        }
        return this.value.toString().length() == 0;
    }

    public String toString() {
        if (this.value == null) {
            return " ";
        }
        if (this.value.toString().length() == 0) {
            return " ";
        }
        if (this.isNonStringData()) {
            return CBIntText.get("(non string data)");
        }
        return this.value.toString();
    }

    public String getID() {
        return this.baseAttribute.getID();
    }

    public boolean changed() {
        boolean changed = false;
        changed = this.value == null ? this.backup != null && !"".equals(this.backup) : (!this.isNonStringData() && this.value != null ? !this.value.equals(this.backup) : this.value != this.backup);
        return changed;
    }

    public Object value() {
        return this.value;
    }

    public Object backup() {
        return this.backup;
    }

    public boolean isNonStringData() {
        return !this.baseAttribute.isString();
    }
}

