/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.naming.CBOpenConWin;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.SwingDataListener;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JXOpenConWin
extends CBOpenConWin
implements DataListener {
    private static final Logger log = Logger.getLogger(JXOpenConWin.class.getName());
    private static final HashMap cachedps = new HashMap(20);
    protected JXplorerBrowser browser;
    protected JNDIDataBroker jndiBroker;
    protected JTextField dsmlService;
    protected static final String DSMLV2 = CBIntText.get("DSML v2");

    public JXOpenConWin(JXplorerBrowser jx, JLabel statusDisplay, String clientcerts, String cacerts, String referral, String aliasType) {
        super(jx, JXplorer.APPLICATION_NAME, statusDisplay, clientcerts, cacerts, referral, aliasType, "browse.connection");
        this.browser = jx;
        if (this.browser != null && this.browser.getJndiBroker() != null && this.newCon != null) {
            this.newCon.tracing = this.browser.getJndiBroker().getTracing();
        }
        this.addPasswordHandlingListener();
    }

    private void addPasswordHandlingListener() {
        CBJComboBox templateSelector = this.myTemplater.getLoadComboBox();
        ActionListener[] listeners = templateSelector.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            templateSelector.removeActionListener(listeners[i]);
        }
        templateSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXOpenConWin.this.myTemplater.load();
                JXOpenConWin.this.checkSecurityLevel();
                JXOpenConWin.this.loadPasswordHandling();
            }
        });
        CBButton save = this.myTemplater.getSaveButton();
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXOpenConWin.this.savePasswordHandling();
            }
        });
    }

    @Override
    protected void initGUI(String applicationName, JLabel statusDisplay) {
        super.initGUI(applicationName, statusDisplay);
        this.initSpecificGUI();
    }

    protected void initSpecificGUI() {
        this.version.addItem(DSMLV2);
        this.setReadOnlyHandling();
        this.myTemplater.loadDefault();
        this.loadPasswordHandling();
        this.display.validate();
    }

    protected void setReadOnlyHandling() {
        if (JXConfig.getProperty("lock.read.only").equals("true")) {
            this.readOnly.setSelected(true);
            this.readOnly.setEnabled(false);
            this.readOnlyLabel.setEnabled(false);
        }
    }

    protected void loadPasswordHandling() {
        if (!JXConfig.getProperty("jxplorer.cache.passwords").equals("true")) {
            return;
        }
        if (this.hostName.getText().trim() == "") {
            return;
        }
        int key = this.makePwdKey();
        if (cachedps.containsKey(key)) {
            String p = (String)cachedps.get(key);
            this.password.setText(p);
        }
    }

    protected void savePasswordHandling() {
        if (!JXConfig.getProperty("jxplorer.cache.passwords").equals("true")) {
            return;
        }
        int key = this.makePwdKey();
        cachedps.put(key, new String(this.password.getPassword()));
    }

    private int makePwdKey() {
        String key = new StringBuffer(50).append(this.hostName.getText()).append(this.port.getText()).append(this.baseDN.getText()).append(this.managerDN.getText()).append(this.version.getSelectedItem().toString()).append(this.level.getSelectedIndex()).toString();
        return key.hashCode();
    }

    @Override
    public void addExtraComponent() {
        this.display.makeLight();
        JLabel urlLabel = new JLabel("   " + CBIntText.get("DSML Service") + ": ");
        this.display.add(urlLabel, 0, 2, 1, 1);
        this.dsmlService = new JTextField("", 30);
        this.display.addWide(this.dsmlService, 4);
        urlLabel.setToolTipText(CBIntText.get("The DSML service; e.g.") + " 'dsml/services/DSML?ldapHost=localhost&ldapPort=19289'");
        VersionActionListener versionListener = new VersionActionListener();
        this.version.addActionListener(versionListener);
    }

    @Override
    public void doOK() {
        this.newCon.protocol = this.version.getSelectedItem().equals(DSMLV2) ? "dsml" : "ldap";
        this.addExtraEnvironmentProperties();
        this.savePasswordHandling();
        super.doOK();
    }

    private void addExtraEnvironmentProperties() {
        Properties props = JXConfig.getMyProperties();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("Context") && !key.startsWith("context") && !key.startsWith("com.sun.jndi.ldap") && !key.startsWith("java.security") && !key.startsWith("javax.security")) continue;
            this.newCon.putExtraProperty(key, props.getProperty(key));
        }
    }

    public void reinit(String newclientcerts, String newcacerts, String newreferral, String newaliasType) {
        this.newCon.clientcerts = newclientcerts;
        this.newCon.cacerts = newcacerts;
        this.newCon.referralType = newreferral;
        this.newCon.aliasType = newaliasType;
        this.newCon.tracing = this.jndiBroker == null ? this.browser.getJndiBroker().getTracing() : this.jndiBroker.getTracing();
    }

    @Override
    public void resetTitleAndPassword() {
        this.setTitle(CBIntText.get("Open LDAP/DSML Connection"));
        if (!JXConfig.getProperty("jxplorer.cache.passwords").equals("true")) {
            this.password.setText("");
        }
    }

    @Override
    public void connect(ConnectionData connectData) {
        try {
            this.jndiBroker = this.browser.getJndiBroker();
            this.browser.preConnectionSetup();
            DataQuery query = this.jndiBroker.connect(connectData);
            query.addDataListener(new SwingDataListener(this));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unexpected exception in JXOpenConWin.connect", e);
            e.printStackTrace();
        }
    }

    @Override
    public void dataReady(DataQuery request) {
        if (!(request instanceof JNDIDataBroker.DataConnectionQuery)) {
            log.warning("Incorrect data for connection - cannot connect");
            return;
        }
        if (!request.hasException()) {
            if (this.browser.postConnectionSetup((JNDIDataBroker.DataConnectionQuery)request)) {
                this.setVisible(false);
                ((JNDIDataBroker.DataConnectionQuery)request).conData.clearPasswords();
                this.dispose();
            } else {
                this.browser.disconnect();
            }
        } else {
            new CBErrorWin((Dialog)this, "Error opening connection:\n" + request.getException().getMessage(), request.getException());
            log.log(Level.WARNING, "Error opening connection ", request.getException());
            request.clearException();
            this.setTitle(CBIntText.get("Couldn't Connect: Try Again"));
            this.dispose();
            this.setVisible(true);
            this.userMessage.setText(CBIntText.get("Couldn't Open") + " " + request.getExtendedData("url"));
            this.browser.disconnect();
            request.squelch();
        }
    }

    @Override
    protected String getURL() throws NumberFormatException, URISyntaxException {
        String url = super.getURL();
        if (this.version.getSelectedItem().equals(DSMLV2)) {
            String dsml = this.dsmlService.getText();
            if (dsml.startsWith("/")) {
                dsml = dsml.substring(1);
            }
            if (url.startsWith("ldap://")) {
                url = url.substring(7);
            }
            url = "http://" + url + "/" + dsml;
        }
        log.fine("connecting with url: " + url);
        return url;
    }

    class VersionActionListener
    implements ActionListener {
        VersionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!JXOpenConWin.this.version.getSelectedItem().equals(DSMLV2)) {
                JXOpenConWin.this.dsmlService.setEnabled(false);
                JXOpenConWin.this.dsmlService.setText("");
                JXOpenConWin.this.dsmlService.setBackground(Color.lightGray);
                if (JXOpenConWin.this.level.getItemCount() < JXOpenConWin.this.securityOptions.length) {
                    for (int i = JXOpenConWin.this.level.getItemCount(); i < JXOpenConWin.this.securityOptions.length; ++i) {
                        JXOpenConWin.this.level.addItem(JXOpenConWin.this.securityOptions[i]);
                    }
                }
                JXOpenConWin.this.level.setEnabled(true);
                JXOpenConWin.this.checkSecurityLevel();
            } else {
                JXOpenConWin.this.dsmlService.setEnabled(true);
                JXOpenConWin.this.dsmlService.setBackground(Color.white);
                if (JXOpenConWin.this.level.getSelectedIndex() > 1) {
                    JXOpenConWin.this.level.setSelectedIndex(1);
                }
                for (int i = JXOpenConWin.this.level.getItemCount() - 1; i > 1; --i) {
                    JXOpenConWin.this.level.removeItemAt(i);
                }
                JXOpenConWin.this.level.setEnabled(true);
                JXOpenConWin.this.checkSecurityLevel();
            }
        }
    }
}

