/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.testprovider;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private Base64() {
    }

    public static String binaryToString(byte[] byteArray) {
        return Base64.binaryToString(byteArray, 0);
    }

    public static String binaryToString(byte[] byteArray, int offset) {
        if (byteArray == null) {
            return null;
        }
        int arraySize = byteArray.length;
        int thirdSize = arraySize / 3;
        byte[] base64Data = Base64.encode(byteArray);
        if (base64Data == null) {
            return null;
        }
        return Base64.format(base64Data, offset);
    }

    public static String format(byte[] base64Data, int offset) {
        String data;
        try {
            data = new String(base64Data, "US-ASCII");
        }
        catch (Exception e) {
            data = new String(base64Data);
        }
        StringBuffer buffer = new StringBuffer(data);
        for (int i = 76 - offset; i < base64Data.length; i += 78) {
            buffer.insert(i, "\r\n ");
        }
        return buffer.toString();
    }

    public static byte[] encode(byte[] byteArray) {
        try {
            int arraySize = byteArray.length;
            int outputSize = arraySize % 3 == 0 ? arraySize / 3 * 4 : (arraySize / 3 + 1) * 4;
            byte[] output = new byte[outputSize];
            int bufferLength = 0;
            for (int i = 0; i <= arraySize - 3; i += 3) {
                Base64.convertTriplet(byteArray[i], byteArray[i + 1], byteArray[i + 2], 3, output, bufferLength);
                bufferLength += 4;
            }
            switch (arraySize % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    Base64.convertTriplet(byteArray[arraySize - 1], (byte)0, (byte)0, 1, output, bufferLength);
                    break;
                }
                case 2: {
                    Base64.convertTriplet(byteArray[arraySize - 2], byteArray[arraySize - 1], (byte)0, 2, output, bufferLength);
                }
            }
            return output;
        }
        catch (Base64EncodingException e) {
            return null;
        }
    }

    public static byte[] encodeFormatted(byte[] byteArray, int start, int colSize) throws Base64EncodingException {
        try {
            if (colSize % 4 != 0) {
                throw new Base64EncodingException("error in encodeFormatted - colSize not a multiple of 4.");
            }
            if (start >= colSize) {
                throw new Base64EncodingException("error in encodeFormatted - start is not less than colSize.");
            }
            int arraySize = byteArray.length;
            int outputSize = start + (arraySize % 3 == 0 ? arraySize / 3 * 4 : (arraySize / 3 + 1) * 4);
            outputSize += outputSize / colSize + 1;
            byte[] output = new byte[outputSize];
            for (int i = 0; i < start; ++i) {
                output[i] = 32;
            }
            int bufferLength = start;
            for (int i = 0; i <= arraySize - 3; i += 3) {
                Base64.convertTriplet(byteArray[i], byteArray[i + 1], byteArray[i + 2], 3, output, bufferLength);
                if ((bufferLength += 4) % (colSize + 1) != colSize) continue;
                output[bufferLength++] = 10;
            }
            switch (arraySize % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    Base64.convertTriplet(byteArray[arraySize - 1], (byte)0, (byte)0, 1, output, bufferLength);
                    bufferLength += 4;
                    break;
                }
                case 2: {
                    Base64.convertTriplet(byteArray[arraySize - 2], byteArray[arraySize - 1], (byte)0, 2, output, bufferLength);
                    bufferLength += 4;
                }
            }
            if (bufferLength < outputSize) {
                output[bufferLength++] = 10;
            } else {
                System.err.println("wierdness in formatted base 64 : bufferlength (" + bufferLength + ") != 1 + outputsize (" + outputSize + ")");
            }
            return output;
        }
        catch (Base64EncodingException e) {
            return null;
        }
        catch (Exception e2) {
            System.err.println("unexpected error in base 64 encoding");
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] stringToBinary(String chars) {
        byte[] charArray;
        if (chars == null) {
            return null;
        }
        try {
            charArray = chars.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            charArray = chars.getBytes();
        }
        return Base64.decode(charArray);
    }

    public static byte[] decode(byte[] rawData) {
        try {
            int resultLength = (int)((double)rawData.length * 0.75);
            byte[] result = new byte[resultLength];
            int noBytesWritten = 0;
            int validCharacters = 0;
            byte[] quad = new byte[4];
            int numfound = 0;
            for (int i = 0; i < rawData.length; ++i) {
                byte c = rawData[i];
                if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 43 || c == 47 || c == 61) {
                    quad[numfound++] = c;
                    ++validCharacters;
                } else if (" \r\n\t\f".indexOf((char)c) == -1) {
                    return null;
                }
                if (numfound != 4) continue;
                int bytes = Base64.convertQuad(quad);
                result[noBytesWritten++] = (byte)((bytes & 0xFF0000) >> 16);
                if (c != 61) {
                    result[noBytesWritten++] = (byte)((bytes & 0xFF00) >> 8);
                    result[noBytesWritten++] = (byte)(bytes & 0xFF);
                } else if (rawData[i - 1] != 61) {
                    result[noBytesWritten++] = (byte)((bytes & 0xFF00) >> 8);
                    if ((bytes & 0xFF) > 0) {
                        return null;
                    }
                } else if ((bytes & 0xFF00) > 0) {
                    return null;
                }
                numfound = 0;
            }
            if (validCharacters % 4 != 0) {
                return null;
            }
            byte[] finalResult = new byte[noBytesWritten];
            System.arraycopy(result, 0, finalResult, 0, noBytesWritten);
            return finalResult;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] decode(String chars) throws Base64EncodingException {
        byte[] rawData;
        if (chars == null) {
            return null;
        }
        try {
            rawData = chars.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Base64EncodingException("unable to convert base64 encoded data to bytes using US-ASCII encoding", e);
        }
        int resultLength = (int)((double)rawData.length * 0.75);
        byte[] result = new byte[resultLength];
        int noBytesWritten = 0;
        int validCharacters = 0;
        byte[] quad = new byte[4];
        int numfound = 0;
        for (int i = 0; i < rawData.length; ++i) {
            byte c = rawData[i];
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 43 || c == 47 || c == 61) {
                quad[numfound++] = c;
                ++validCharacters;
            } else if (" \r\n\t\f".indexOf((char)c) == -1) {
                throw new Base64EncodingException("error... bad character (" + (char)c + ") read from base64 encoded string");
            }
            if (numfound != 4) continue;
            int bytes = Base64.convertQuad(quad);
            result[noBytesWritten++] = (byte)((bytes & 0xFF0000) >> 16);
            if (c != 61) {
                result[noBytesWritten++] = (byte)((bytes & 0xFF00) >> 8);
                result[noBytesWritten++] = (byte)(bytes & 0xFF);
            } else if (rawData[i - 1] != 61) {
                result[noBytesWritten++] = (byte)((bytes & 0xFF00) >> 8);
                if ((bytes & 0xFF) > 0) {
                    throw new Base64EncodingException("Warning: Corrupt base64 Encoded Data - contains trailing bits after end of base 64 data.");
                }
            } else if ((bytes & 0xFF00) > 0) {
                throw new Base64EncodingException("Warning: Corrupt base64 Encoded File  - contains trailing bits after end of base64 data.");
            }
            numfound = 0;
        }
        if (validCharacters % 4 != 0) {
            throw new Base64EncodingException("Warning: Corrupt base64 Encoded Data - Length (" + validCharacters + ") of valid characters not divisible by 4.");
        }
        byte[] finalResult = new byte[noBytesWritten];
        System.arraycopy(result, 0, finalResult, 0, noBytesWritten);
        return finalResult;
    }

    private static void convertTriplet(byte a, byte b, byte c, int Num, byte[] buff, int buffpos) throws Base64EncodingException {
        int trip = a << 16 | b << 8 & 0xFF00 | c & 0xFF;
        byte w = (byte)((trip & 0xFC0000) >> 18);
        byte x = (byte)((trip & 0x3F000) >> 12);
        byte y = (byte)((trip & 0xFC0) >> 6);
        byte z = (byte)(trip & 0x3F);
        buff[buffpos] = Base64.convertFrom6Bit(w);
        buff[buffpos + 1] = Base64.convertFrom6Bit(x);
        if (Num == 1) {
            buff[buffpos + 2] = 61;
            buff[buffpos + 3] = 61;
        } else {
            buff[buffpos + 2] = Base64.convertFrom6Bit(y);
            buff[buffpos + 3] = Num == 2 ? 61 : Base64.convertFrom6Bit(z);
        }
    }

    private static byte convertFrom6Bit(byte b) throws Base64EncodingException {
        if (b < 26) {
            return (byte)(65 + b);
        }
        if (b < 52) {
            return (byte)(71 + b);
        }
        if (b < 62) {
            return (byte)(-4 + b);
        }
        if (b == 62) {
            return 43;
        }
        if (b == 63) {
            return 47;
        }
        throw new Base64EncodingException("erroroneous value " + (char)b + " passed in convertFrom6bit");
    }

    private static byte convertTo6Bit(byte c) throws Base64EncodingException {
        if (c == 43) {
            return 62;
        }
        if (c == 47) {
            return 63;
        }
        if (c == 61) {
            return 0;
        }
        if (c <= 57) {
            return (byte)(c - 48 + 52);
        }
        if (c <= 90) {
            return (byte)(c - 65);
        }
        if (c <= 122) {
            return (byte)(c - 97 + 26);
        }
        throw new Base64EncodingException("erroroneous value " + (char)c + " passed in convertTo6bit");
    }

    private static int convertQuad(byte[] quad) throws Base64EncodingException {
        byte a = Base64.convertTo6Bit(quad[0]);
        byte b = Base64.convertTo6Bit(quad[1]);
        byte c = Base64.convertTo6Bit(quad[2]);
        byte d = Base64.convertTo6Bit(quad[3]);
        int ret = (a << 18) + (b << 12) + (c << 6) + d;
        return ret;
    }

    static class Base64EncodingException
    extends Exception {
        public Base64EncodingException(String msg) {
            super(msg);
        }

        public Base64EncodingException(String msg, Exception e) {
            super(msg);
            this.initCause(e);
        }
    }
}

