/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.ChangeListener;
import com.tivo.jipviewer.JipFrame;
import com.tivo.jipviewer.JipMethod;
import com.tivo.jipviewer.JipRun;
import com.tivo.jipviewer.MethodRow;
import com.tivo.jipviewer.MethodRowTableModel;
import com.tivo.jipviewer.TableSorter;
import com.tivo.jipviewer.ValueModel;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodViewer
extends Container
implements ChangeListener,
MouseListener {
    private ValueModel<JipMethod> mModel;
    private JLabel mLabel;
    private JTable mCallers;
    private JTable mSelf;
    private JTable mCallees;
    private JipRun mRun;
    private MethodRowTableModel mSelfModel = new MethodRowTableModel();
    private MethodRowTableModel mCallersModel = new MethodRowTableModel();
    private MethodRowTableModel mCalleesModel = new MethodRowTableModel();
    static int[] svWidth = new int[]{50, 100, 50, 50, 50, 190, 200, 190};

    MethodViewer(JipRun jipRun, ValueModel<JipMethod> valueModel) {
        this.mRun = jipRun;
        this.mModel = valueModel;
        this.mModel.addChangeListener(this);
        this.mLabel = this.makeLabel("method:");
        this.mCallers = MethodViewer.makeTableForMethodRows(this.mCallersModel);
        this.mSelf = MethodViewer.makeTableForMethodRows(this.mSelfModel);
        this.mCallees = MethodViewer.makeTableForMethodRows(this.mCalleesModel);
        this.mCallers.addMouseListener(this);
        this.mCallees.addMouseListener(this);
        this.add(this.makeLabel("called by:"));
        this.add(new JScrollPane(this.mCallers));
        this.add(new JSeparator());
        this.add(this.mLabel);
        this.add(this.mSelf);
        this.add(new JSeparator());
        this.add(this.makeLabel("calls:"));
        this.add(new JScrollPane(this.mCallees));
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void changed(Object object) {
        JipMethod jipMethod = this.mModel.getValue();
        this.mCallersModel.clear();
        this.mSelfModel.clear();
        this.mCalleesModel.clear();
        if (jipMethod != null) {
            MethodRow methodRow;
            HashMap<JipMethod, MethodRow> hashMap = new HashMap<JipMethod, MethodRow>();
            long l = 0L;
            for (JipFrame object2 : this.mRun.allCallers(jipMethod)) {
                JipMethod jipMethod2 = object2.getMethod();
                methodRow = (MethodRow)hashMap.get(jipMethod2);
                if (methodRow == null) {
                    methodRow = new MethodRow(jipMethod2);
                    this.mCallersModel.add(methodRow);
                    hashMap.put(jipMethod2, methodRow);
                }
                methodRow.addFrame(object2);
                l += object2.getTotalTime();
            }
            for (MethodRow methodRow2 : hashMap.values()) {
                methodRow2.setTimeDenominator(l);
            }
            JipRun.PerMethodInfo perMethodInfo = this.mRun.getPerMethod(jipMethod);
            long l2 = perMethodInfo.getAllThreadAllFramesTimeIncludingReentrant();
            methodRow = new MethodRow(jipMethod);
            methodRow.setTimeDenominator(l2);
            for (JipFrame jipFrame : perMethodInfo.allFrames()) {
                methodRow.addFrame(jipFrame);
            }
            this.mSelfModel.add(methodRow);
            hashMap = new HashMap();
            for (JipFrame jipFrame : this.mRun.allCallees(jipMethod)) {
                JipMethod jipMethod3 = jipFrame.getMethod();
                MethodRow methodRow3 = (MethodRow)hashMap.get(jipMethod3);
                if (methodRow3 == null) {
                    methodRow3 = new MethodRow(jipMethod3);
                    methodRow3.setTimeDenominator(l2);
                    this.mCalleesModel.add(methodRow3);
                    hashMap.put(jipMethod3, methodRow3);
                }
                methodRow3.addFrame(jipFrame);
            }
        }
    }

    static JTable makeTableForMethodRows(TableModel tableModel) {
        TableSorter tableSorter = new TableSorter(tableModel);
        JTable jTable = new JTable(tableSorter);
        tableSorter.setTableHeader(jTable.getTableHeader());
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i >= svWidth.length) continue;
            tableColumn.setPreferredWidth(svWidth[i]);
        }
        jTable.doLayout();
        jTable.setDefaultRenderer(Double.class, new MyDoubleRenderer());
        return jTable;
    }

    private JLabel makeLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this.mCallers && mouseEvent.getSource() != this.mCallees) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (mouseEvent.getID() != 500) {
            return;
        }
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        TableSorter tableSorter = (TableSorter)jTable.getModel();
        n = tableSorter.modelIndex(n);
        MethodRowTableModel methodRowTableModel = (MethodRowTableModel)tableSorter.getTableModel();
        MethodRow methodRow = methodRowTableModel.getRow(n);
        this.mModel.setValue(methodRow.getMethod());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static class MyDoubleRenderer
    extends DefaultTableCellRenderer {
        NumberFormat mFormat;

        MyDoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object object) {
            if (this.mFormat == null) {
                this.mFormat = (NumberFormat)NumberFormat.getInstance().clone();
                this.mFormat.setMinimumFractionDigits(2);
            }
            this.setText(this.mFormat.format(object));
        }
    }
}

