/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.ByPackageViewer;
import com.tivo.jipviewer.ChangeListener;
import com.tivo.jipviewer.HelpViewer;
import com.tivo.jipviewer.JipFrame;
import com.tivo.jipviewer.JipMethod;
import com.tivo.jipviewer.JipParser;
import com.tivo.jipviewer.JipRun;
import com.tivo.jipviewer.MethodRow;
import com.tivo.jipviewer.MethodRowTableModel;
import com.tivo.jipviewer.MethodViewer;
import com.tivo.jipviewer.RemoteController;
import com.tivo.jipviewer.TableSorter;
import com.tivo.jipviewer.ValueModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class JipViewer
extends JFrame
implements TreeSelectionListener,
ListSelectionListener,
KeyListener,
ChangeListener {
    private JTable mTable;
    private JTree mCallTree;
    private JTable mMethods;
    private ByPackageViewer mPkgViewer;
    private RemoteController mRemoteController;
    private TreeNode mCallTreeRoot;
    private ValueModel<JipMethod> mMethodModel = new ValueModel();
    private MethodRowTableModel mAllMethodsModel = new MethodRowTableModel();
    private TableSorter mAllMethodsSorterModel;

    public static void main(String[] stringArray) throws Exception {
        String string = "";
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            System.out.println("usage: JipViewer filename");
            System.exit(1);
        }
        JipRun jipRun = JipParser.parse(string);
        long l = jipRun.getTotalTimeForAllThreads();
        long l2 = (long)Math.floor(JipViewer.toMsec(l));
        String string2 = "" + l2 + " msec -- " + string;
        new JipViewer(string2, jipRun);
    }

    public JipViewer(String string, JipRun jipRun) {
        super(string);
        Object object;
        this.addKeyListener(this);
        this.mMethodModel.addChangeListener(this);
        this.mCallTreeRoot = new TreeNode(string);
        this.buildTree(jipRun, this.mCallTreeRoot);
        this.mCallTree = new JTree(this.mCallTreeRoot);
        this.mCallTree.getSelectionModel().setSelectionMode(1);
        this.mCallTree.addTreeSelectionListener(this);
        this.mCallTree.addKeyListener(this);
        List<JipRun.PerMethodInfo> list = jipRun.perMethodsInTotalTimeOrder();
        long l = jipRun.getTotalTimeForAllThreads();
        for (JipRun.PerMethodInfo object22 : list) {
            object = new MethodRow(object22.getMethod());
            for (JipFrame jipFrame : object22.allFrames()) {
                if (!jipFrame.isReentrant()) {
                    ((MethodRow)object).addFrame(jipFrame);
                }
                ((MethodRow)object).setTimeDenominator(l);
            }
            this.mAllMethodsModel.add((MethodRow)object);
        }
        this.mMethods = MethodViewer.makeTableForMethodRows(this.mAllMethodsModel);
        this.mMethods.getSelectionModel().addListSelectionListener(this);
        this.mMethods.addKeyListener(this);
        this.mAllMethodsSorterModel = (TableSorter)this.mMethods.getModel();
        this.mPkgViewer = new ByPackageViewer(jipRun);
        this.mPkgViewer.addKeyListener(this);
        this.mRemoteController = new RemoteController();
        this.mRemoteController.addKeyListener(this);
        MethodViewer methodViewer = new MethodViewer(jipRun, this.mMethodModel);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("call tree", new JScrollPane(this.mCallTree));
        jTabbedPane.addTab("methods", new JScrollPane(this.mMethods));
        jTabbedPane.addTab("by package", new JScrollPane(this.mPkgViewer));
        jTabbedPane.addTab("remote control", this.mRemoteController);
        jTabbedPane.addTab("help", new HelpViewer());
        jTabbedPane.addKeyListener(this);
        jTabbedPane.setMinimumSize(new Dimension(100, 200));
        object = new JSplitPane(0, jTabbedPane, methodViewer);
        this.setContentPane((Container)object);
        this.pack();
        this.setSize(new Dimension(1024, 768));
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JipMethod jipMethod = null;
        ListSelectionModel listSelectionModel = this.mMethods.getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            n = this.mAllMethodsSorterModel.modelIndex(n);
            MethodRow methodRow = this.mAllMethodsModel.getRow(n);
            jipMethod = methodRow.getMethod();
        }
        this.mMethodModel.setValue(jipMethod);
    }

    private void buildTree(JipRun jipRun, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (Long l : jipRun.threads()) {
            int n = 1;
            for (JipFrame jipFrame : jipRun.interactions(l)) {
                String string = "thread " + l + " interaction " + n + " (" + JipViewer.toMsec(jipFrame.getTotalTime()) + " msec)";
                TreeNode treeNode = new TreeNode(string);
                defaultMutableTreeNode.add(treeNode);
                this.buildFrameTree(treeNode, jipFrame);
                ++n;
            }
        }
    }

    private static double toMsec(long l) {
        return Math.floor((double)l / 1000000.0 * 10.0) / 10.0;
    }

    private void buildFrameTree(TreeNode treeNode, JipFrame jipFrame) {
        Comparator<JipFrame> comparator = new Comparator<JipFrame>(){

            @Override
            public int compare(JipFrame jipFrame, JipFrame jipFrame2) {
                long l;
                long l2 = jipFrame.getTotalTime();
                if (l2 > (l = jipFrame2.getTotalTime())) {
                    return -1;
                }
                if (l2 < l) {
                    return 1;
                }
                String string = jipFrame.getMethod().getMethodName();
                String string2 = jipFrame.getMethod().getMethodName();
                return string2.compareToIgnoreCase(string);
            }
        };
        TreeNode treeNode2 = new TreeNode(jipFrame);
        treeNode.add(treeNode2);
        List<JipFrame> list = jipFrame.getChildren();
        Collections.sort(list, comparator);
        for (JipFrame jipFrame2 : list) {
            this.buildFrameTree(treeNode2, jipFrame2);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeNode treeNode = (TreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        JipFrame jipFrame = treeNode.getFrameOrNull();
        JipMethod jipMethod = jipFrame == null ? null : jipFrame.getMethod();
        this.mMethodModel.setValue(jipMethod);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'q') {
            System.exit(0);
        }
    }

    public void changed(Object object) {
        if (object != this.mMethodModel) {
            throw new RuntimeException("i wish i used asserts!");
        }
        JipMethod jipMethod = this.mMethodModel.getValue();
        this.selectInAllMethods(jipMethod);
        this.selectInCallTree(jipMethod);
    }

    private void selectInAllMethods(JipMethod jipMethod) {
        int n;
        if (jipMethod == null) {
            this.mMethods.clearSelection();
            return;
        }
        boolean bl = false;
        int n2 = this.mAllMethodsModel.getRowCount();
        for (n = 0; n < n2; ++n) {
            MethodRow methodRow = this.mAllMethodsModel.getRow(n);
            if (!methodRow.getMethod().equals(jipMethod)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            System.out.println("couldn't find " + jipMethod.getName());
            return;
        }
        int n3 = this.mAllMethodsSorterModel.viewIndex(n);
        this.mMethods.getSelectionModel().setSelectionInterval(n3, n3);
        Rectangle rectangle = this.mMethods.getCellRect(n3, 0, true);
        this.mMethods.scrollRectToVisible(rectangle);
    }

    private void selectInCallTree(JipMethod jipMethod) {
        Serializable serializable;
        JipMethod jipMethod2;
        if (jipMethod == null) {
            this.mCallTree.clearSelection();
            return;
        }
        TreePath treePath = this.mCallTree.getSelectionPath();
        if (treePath != null && (jipMethod2 = (serializable = (TreeNode)treePath.getLastPathComponent()).getMethodOrNull()) != null && jipMethod2.equals(jipMethod)) {
            return;
        }
        serializable = this.mCallTreeRoot.findPathForMethod(jipMethod);
        if (serializable == null) {
            System.out.println("no path to " + jipMethod);
            return;
        }
        this.mCallTree.setSelectionPath((TreePath)serializable);
        this.mCallTree.scrollPathToVisible((TreePath)serializable);
    }

    static class TreeNode
    extends DefaultMutableTreeNode {
        JipFrame mFrame;
        String mLabel;

        TreeNode(JipFrame jipFrame) {
            this.mFrame = jipFrame;
        }

        TreeNode(String string) {
            this.mLabel = string;
        }

        JipFrame getFrameOrNull() {
            return this.mFrame;
        }

        JipMethod getMethodOrNull() {
            return this.mFrame == null ? null : this.mFrame.getMethod();
        }

        public String toString() {
            if (this.mFrame == null) {
                return this.mLabel;
            }
            String string = "(" + JipViewer.toMsec(this.mFrame.getTotalTime()) + " " + JipViewer.toMsec(this.mFrame.getNetTime()) + " " + this.mFrame.getCount() + ") " + this.mFrame.getMethod().getMethodName();
            return string;
        }

        private TreeNode findNodeForMethod(TreeNode treeNode, JipMethod jipMethod) {
            JipMethod jipMethod2 = treeNode.getMethodOrNull();
            if (jipMethod2 != null && jipMethod2.equals(jipMethod)) {
                return treeNode;
            }
            int n = treeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode2 = (TreeNode)treeNode.getChildAt(i);
                TreeNode treeNode3 = this.findNodeForMethod(treeNode2, jipMethod);
                if (treeNode3 == null) continue;
                return treeNode3;
            }
            return null;
        }

        TreePath findPathForMethod(JipMethod jipMethod) {
            TreeNode treeNode = this.findNodeForMethod(this, jipMethod);
            if (treeNode == null) {
                return null;
            }
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (TreeNode treeNode2 = treeNode; treeNode2 != null; treeNode2 = (TreeNode)treeNode2.getParent()) {
                arrayList.add(treeNode2);
            }
            Collections.reverse(arrayList);
            return new TreePath(arrayList.toArray());
        }
    }
}

