/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.JipFrame;
import com.tivo.jipviewer.JipRun;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

class ByPackageViewer
extends Container {
    ByPackageViewer(JipRun jipRun) {
        this.setLayout(new BorderLayout());
        this.add((Component)ByPackageViewer.makeTree(jipRun), "Center");
    }

    static JTree makeTree(JipRun jipRun) {
        TreeNode treeNode = ByPackageViewer.makePackageTree(jipRun);
        return new JTree(treeNode);
    }

    private static TreeNode makePackageTree(JipRun jipRun) {
        TreeNode treeNode = new TreeNode("root");
        for (Long l : jipRun.threads()) {
            for (JipFrame jipFrame : jipRun.interactions(l)) {
                ByPackageViewer.visitFrameForPackaging(treeNode, jipFrame);
            }
        }
        treeNode.computeTotals();
        return treeNode;
    }

    private static void visitFrameForPackaging(TreeNode treeNode, JipFrame jipFrame) {
        String string = jipFrame.getMethod().getPackageName();
        TreeNode treeNode2 = ByPackageViewer.findOrCreateNode(treeNode, string);
        treeNode2.addFrame(jipFrame);
        for (JipFrame jipFrame2 : jipFrame.getChildren()) {
            ByPackageViewer.visitFrameForPackaging(treeNode, jipFrame2);
        }
    }

    private static TreeNode findOrCreateNode(TreeNode treeNode, String string) {
        String string2;
        String string3;
        if (string.equals("")) {
            return treeNode;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Object object = treeNode.children();
        while (object.hasMoreElements()) {
            TreeNode treeNode2 = (TreeNode)object.nextElement();
            if (!treeNode2.getName().equals(string3)) continue;
            return ByPackageViewer.findOrCreateNode(treeNode2, string2);
        }
        object = new TreeNode(string3);
        treeNode.add((MutableTreeNode)object);
        return ByPackageViewer.findOrCreateNode((TreeNode)object, string2);
    }

    static class TreeNode
    extends DefaultMutableTreeNode {
        String mName;
        private double mTimeDenominator = 1.0;
        private long mSelfNetTime;
        private long mSelfCount;
        private long mTotalNetTime;
        private long mTotalCount;

        TreeNode(String string) {
            this.mName = string;
        }

        String getName() {
            return this.mName;
        }

        void addFrame(JipFrame jipFrame) {
            this.mSelfNetTime += jipFrame.getNetTime();
            this.mSelfCount += jipFrame.getCount();
        }

        private void computeTotals() {
            this.computeTotalsHelper();
            if (this.mTotalNetTime > 0L) {
                Enumeration<javax.swing.tree.TreeNode> enumeration = this.breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = (TreeNode)enumeration.nextElement();
                    treeNode.mTimeDenominator = this.mTotalNetTime;
                }
            }
        }

        private void computeTotalsHelper() {
            Enumeration<javax.swing.tree.TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                treeNode.computeTotalsHelper();
                this.mTotalCount += treeNode.mTotalCount;
                this.mTotalNetTime += treeNode.mTotalNetTime;
            }
            this.mTotalCount += this.mSelfCount;
            this.mTotalNetTime += this.mSelfNetTime;
        }

        public String toString() {
            String string = this.mName + "  " + this.toPercent((double)this.mTotalNetTime / this.mTimeDenominator) + " " + TreeNode.toMsec(this.mTotalNetTime) + "ms";
            if (!this.isLeaf() && this.mSelfNetTime != 0L) {
                string = string + "  (self: " + this.toPercent((double)this.mSelfNetTime / this.mTimeDenominator) + " " + TreeNode.toMsec(this.mSelfNetTime) + "ms)";
            }
            return string;
        }

        private static long toMsec(long l) {
            return Math.round((double)l / 1000000.0);
        }

        String toPercent(double d) {
            double d2 = Math.floor(10000.0 * d) / 100.0;
            return Double.toString(d2) + "%";
        }
    }
}

