/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgVolume.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgVolume.
 *
 *****************************************************************************/

%include "tcl3dSwigDefines.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"
%include "osgVolumeHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgVolume;

%}

%include osgVolume/VolumeTechnique

// Classes inherited from VolumeTechnique.
%include osgVolume/FixedFunctionTechnique
%include osgVolume/RayTracedTechnique

%include osgVolume/Layer
%include osgVolume/Locator
%include osgVolume/Property
%include osgVolume/Version
%include osgVolume/Volume
%include osgVolume/VolumeTile
