/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgViewer.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgViewer.
 *
 *****************************************************************************/

%include "osgOpenThreadsHeader.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgGAHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"
%include "osgViewerHeader.i"

%import "osg.i"
%import "osgGA.i"

%{
using namespace osg;
using namespace osgViewer;
%}

%ignore osgViewer::CompositeViewer::getAllThreads;
%ignore osgViewer::CompositeViewer::getOperationThreads;

/* this one needs some thought */
%ignore osgViewer::ScreenCaptureHandler;

%feature("notabstract") osgViewer::Viewer;
%feature("notabstract") osgViewer::GraphicsWindow;
%feature("notabstract") osgViewer::GraphicsWindowEmbedded;

%extend osgViewer::GraphicsWindow {
    int getX () {
        return self->getTraits()->x;
    }
    int getY () {
        return self->getTraits()->y;
    }
    void resized(int x, int y, int width, int height) {
        self->resized (x, y, width, height);
    }
};

%include osgViewer/Renderer

%include osgViewer/View
%include osgViewer/GraphicsWindow
%include osgViewer/Scene

%template(Windows)  std::vector<osgViewer::GraphicsWindow*>;
%template(Contexts) std::vector<osg::GraphicsContext*>;
%template(Cameras)  std::vector<osg::Camera*>;
%template(Scenes)   std::vector<osgViewer::Scene*>;
%template(Views)    std::vector<osgViewer::View*>;

%template(ViewerRef) osg::ref_ptr<osgViewer::Viewer>;

%include osgViewer/ViewerBase
%include osgViewer/Viewer
%include osgViewer/CompositeViewer
%include osgViewer/ViewerEventHandlers

%include osgViewer/Version

// OPA TODO Commented out
//%inline %{
//osgViewer::Viewer *GUIActionAdapterToViewer(osgGA::GUIActionAdapter *aa) {
//  return dynamic_cast<osgViewer::Viewer*>(aa);
//}
//%}
