/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgShadow.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgShadow.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgShadowHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgShadow;

%}

%include osgShadow/OccluderGeometry
%include osgShadow/ShadowTechnique
%include osgShadow/ShadowedScene
%include osgShadow/ShadowMap
%include osgShadow/ShadowTexture
%include osgShadow/ShadowVolume
%ignore osgShadow::ParallelSplitShadowMap::setFragmentShaderGenerator;
%include osgShadow/ParallelSplitShadowMap
%include osgShadow/SoftShadowMap
%include osgShadow/Version
