/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgParticle.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module
 *                      osgParticle.
 *
 *****************************************************************************/

%include "tcl3dMixinVector.i"

%include "osgOpenThreadsHeader.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"
%include "osgSimHeader.i"

%import "osg.i"

%{

// Do not use namespace osg, because of duplicate definition of Program.
using namespace osgParticle;

%}

// %ignore osgParticle::CenteredPlacer;

%include osgParticle/range

%include osgParticle/Shooter
%include osgParticle/RadialShooter

%include osgParticle/Particle

%include osgParticle/Operator
%include osgParticle/AccelOperator
%include osgParticle/AngularAccelOperator
%include osgParticle/FluidFrictionOperator
%include osgParticle/ForceOperator

%include osgParticle/Placer
%include osgParticle/CenteredPlacer
%include osgParticle/BoxPlacer
%include osgParticle/MultiSegmentPlacer
%include osgParticle/PointPlacer
%include osgParticle/SectorPlacer
%include osgParticle/SegmentPlacer

%include osgParticle/ParticleSystem
%include osgParticle/ConnectedParticleSystem
%include osgParticle/ParticleSystemUpdater

%include osgParticle/Counter
%include osgParticle/ConstantRateCounter
%include osgParticle/VariableRateCounter
%include osgParticle/RandomRateCounter

%include osgParticle/ParticleProcessor
%include osgParticle/Emitter
%include osgParticle/ModularEmitter

%include osgParticle/ParticleEffect
%include osgParticle/ExplosionDebrisEffect
%include osgParticle/ExplosionEffect
%include osgParticle/FireEffect
%include osgParticle/PrecipitationEffect
%include osgParticle/SmokeEffect
%include osgParticle/SmokeTrailEffect

%include osgParticle/Program
%include osgParticle/FluidProgram
%include osgParticle/ModularProgram

%include osgParticle/Interpolator
%include osgParticle/LinearInterpolator

%include osgParticle/Version
