/******************************************************************************
 *{@C
 *      Copyright:      2008-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dUtilRandom.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for random functions.
 *
 *****************************************************************************/

#ifndef __TCL3D_UTIL_RANDOM_H__
#define __TCL3D_UTIL_RANDOM_H__

typedef struct randomGenStruct {
    unsigned short r0;
    unsigned short r1;
    unsigned short r2;
} RandomGenStruct;

typedef struct randomGenStruct *randomGen;

#ifdef __cplusplus
   extern "C" {
#endif

    randomGen tcl3dNewRandomGen (unsigned int seed);
    void  tcl3dDeleteRandomGen  (randomGen rGen);
    int   tcl3dGetRandomInt     (randomGen rGen, int rmin, int rmax);
    float tcl3dGetRandomFloat   (randomGen rGen, float rmin, float rmax);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_UTIL_RANDOM_H__ */
