/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on 
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dShapesGlut.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for GLUT compatible shape functions.
 *
 *****************************************************************************/

#ifndef __TCL3D_SHAPES_GLUT_H__
#define __TCL3D_SHAPES_GLUT_H__

#ifdef __cplusplus
   extern "C" {
#endif

    void tcl3dDrawBox(GLfloat size, GLenum type);
    void tcl3dDoughnut(GLfloat r, GLfloat R, GLint nsides, GLint rings);
    void tcl3dDodecahedron(GLenum type);
    void tcl3dOctahedron(GLenum shadeType);
    void tcl3dIcosahedron(GLenum shadeType);
    void tcl3dTetrahedron(GLenum shadeType);
    
    void tcl3dTeapot (GLint grid, GLdouble scale, GLenum type);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_SHAPES_GLUT_H__ */
