/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dCg
 *      Filename:       cg.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG module for wrapping the Cg library.
 *
 *****************************************************************************/

// SWIG interface file for OpenGL extension library cg.h and cgGL.h
// As the cg.h file includes other header files, which rely on the 
// C preprocessor macro expansion functionality, we need to preprocess
// cg.h: The expanded file cgExpanded.h is created in the Makefile.
// Before including the OpenGL specific Cg file cgGl.h we define the
// _cg_h macro, so that cgGl.h does not include the cg.h header file again.

%module cg

%{
#if defined (WIN32)
#include <windows.h>
#include <wingdi.h>
#endif
#include "cgExpanded.h"
#define _cg_h
#include "Cg/cgGL.h"
%}

%include tcl3dDefines.i

#define CGDLL_API                /* Needed for Windows */
#define __cdecl                  /* Needed for Windows */
#define __declspec(dllimport)    /* Needed for Windows */
#define __attribute__(dllimport) /* Needed for MinGW */
#define __w64                    /* Needed for Visual Studio 2003 */

%include cgExpanded.h
#define _cg_h
%include "Cg/cgGL.h"

