/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble;

import com.mitchellbosecke.pebble.attributes.methodaccess.BlacklistMethodAccessValidator;
import com.mitchellbosecke.pebble.attributes.methodaccess.MethodAccessValidator;
import com.mitchellbosecke.pebble.cache.CacheKey;
import com.mitchellbosecke.pebble.cache.PebbleCache;
import com.mitchellbosecke.pebble.cache.tag.ConcurrentMapTagCache;
import com.mitchellbosecke.pebble.cache.tag.NoOpTagCache;
import com.mitchellbosecke.pebble.cache.template.ConcurrentMapTemplateCache;
import com.mitchellbosecke.pebble.cache.template.NoOpTemplateCache;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.ExtensionCustomizer;
import com.mitchellbosecke.pebble.extension.ExtensionRegistry;
import com.mitchellbosecke.pebble.extension.ExtensionRegistryFactory;
import com.mitchellbosecke.pebble.extension.NodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.escaper.EscapingStrategy;
import com.mitchellbosecke.pebble.lexer.LexerImpl;
import com.mitchellbosecke.pebble.lexer.Syntax;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.DelegatingLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.loader.StringLoader;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.parser.ParserImpl;
import com.mitchellbosecke.pebble.parser.ParserOptions;
import com.mitchellbosecke.pebble.template.EvaluationOptions;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PebbleEngine {
    private final Logger logger = LoggerFactory.getLogger(PebbleEngine.class);
    private final Loader<?> loader;
    private final Syntax syntax;
    private final boolean strictVariables;
    private final Locale defaultLocale;
    private final int maxRenderedSize;
    private final PebbleCache<CacheKey, Object> tagCache;
    private final ExecutorService executorService;
    private final PebbleCache<Object, PebbleTemplate> templateCache;
    private final ExtensionRegistry extensionRegistry;
    private final ParserOptions parserOptions;
    private final EvaluationOptions evaluationOptions;

    private PebbleEngine(Loader<?> loader, Syntax syntax, boolean strictVariables, Locale defaultLocale, int maxRenderedSize, PebbleCache<CacheKey, Object> tagCache, PebbleCache<Object, PebbleTemplate> templateCache, ExecutorService executorService, ExtensionRegistry extensionRegistry, ParserOptions parserOptions, EvaluationOptions evaluationOptions) {
        this.loader = loader;
        this.syntax = syntax;
        this.strictVariables = strictVariables;
        this.defaultLocale = defaultLocale;
        this.maxRenderedSize = maxRenderedSize;
        this.tagCache = tagCache;
        this.executorService = executorService;
        this.templateCache = templateCache;
        this.extensionRegistry = extensionRegistry;
        this.parserOptions = parserOptions;
        this.evaluationOptions = evaluationOptions;
    }

    public PebbleTemplate getTemplate(String templateName) {
        return this.getTemplate(templateName, this.loader);
    }

    public PebbleTemplate getLiteralTemplate(String templateName) {
        return this.getTemplate(templateName, new StringLoader());
    }

    private PebbleTemplate getTemplate(String templateName, Loader loader) {
        if (templateName == null) {
            return null;
        }
        if (loader == null) {
            throw new LoaderException(null, "Loader has not yet been specified.");
        }
        Object cacheKey = loader.createCacheKey(templateName);
        return this.templateCache.computeIfAbsent(cacheKey, k -> this.getPebbleTemplate(templateName, loader, cacheKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PebbleTemplate getPebbleTemplate(String templateName, Loader loader, Object cacheKey) {
        Reader templateReader = loader.getReader(cacheKey);
        try {
            this.logger.trace("Tokenizing template named {}", (Object)templateName);
            LexerImpl lexer = new LexerImpl(this.syntax, this.extensionRegistry.getUnaryOperators().values(), this.extensionRegistry.getBinaryOperators().values());
            TokenStream tokenStream = lexer.tokenize(templateReader, templateName);
            this.logger.trace("TokenStream: {}", (Object)tokenStream);
            ParserImpl parser = new ParserImpl(this.extensionRegistry.getUnaryOperators(), this.extensionRegistry.getBinaryOperators(), this.extensionRegistry.getTokenParsers(), this.parserOptions);
            RootNode root = parser.parse(tokenStream);
            PebbleTemplateImpl instance = new PebbleTemplateImpl(this, root, templateName);
            for (NodeVisitorFactory visitorFactory : this.extensionRegistry.getNodeVisitors()) {
                visitorFactory.createVisitor(instance).visit(root);
            }
            PebbleTemplateImpl pebbleTemplateImpl = instance;
            return pebbleTemplateImpl;
        }
        finally {
            try {
                templateReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Loader<?> getLoader() {
        return this.loader;
    }

    public PebbleCache<Object, PebbleTemplate> getTemplateCache() {
        return this.templateCache;
    }

    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public int getMaxRenderedSize() {
        return this.maxRenderedSize;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public PebbleCache<CacheKey, Object> getTagCache() {
        return this.tagCache;
    }

    public EvaluationOptions getEvaluationOptions() {
        return this.evaluationOptions;
    }

    public static class Builder {
        private Loader<?> loader;
        private Syntax syntax;
        private boolean strictVariables = false;
        private boolean enableNewLineTrimming = true;
        private Locale defaultLocale;
        private int maxRenderedSize = -1;
        private ExecutorService executorService;
        private PebbleCache<Object, PebbleTemplate> templateCache;
        private boolean cacheActive = true;
        private PebbleCache<CacheKey, Object> tagCache;
        private boolean literalDecimalTreatedAsInteger = false;
        private boolean greedyMatchMethod = false;
        private boolean literalNumbersAsBigDecimals = false;
        private MethodAccessValidator methodAccessValidator = new BlacklistMethodAccessValidator();
        private final ExtensionRegistryFactory factory = new ExtensionRegistryFactory();

        public Builder loader(Loader<?> loader) {
            this.loader = loader;
            return this;
        }

        public Builder extension(Extension ... extensions) {
            this.factory.extension(extensions);
            return this;
        }

        public Builder syntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public Builder strictVariables(boolean strictVariables) {
            this.strictVariables = strictVariables;
            return this;
        }

        public Builder newLineTrimming(boolean enableNewLineTrimming) {
            this.enableNewLineTrimming = enableNewLineTrimming;
            return this;
        }

        public Builder defaultLocale(Locale defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder maxRenderedSize(int maxRenderedSize) {
            this.maxRenderedSize = maxRenderedSize;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder templateCache(PebbleCache<Object, PebbleTemplate> templateCache) {
            this.templateCache = templateCache;
            return this;
        }

        public Builder tagCache(PebbleCache<CacheKey, Object> tagCache) {
            this.tagCache = tagCache;
            return this;
        }

        public Builder autoEscaping(boolean autoEscaping) {
            this.factory.autoEscaping(autoEscaping);
            return this;
        }

        public Builder allowOverrideCoreOperators(boolean allowOverrideCoreOperators) {
            this.factory.allowOverrideCoreOperators(allowOverrideCoreOperators);
            return this;
        }

        public Builder defaultEscapingStrategy(String strategy) {
            this.factory.defaultEscapingStrategy(strategy);
            return this;
        }

        public Builder addEscapingStrategy(String name, EscapingStrategy strategy) {
            this.factory.addEscapingStrategy(name, strategy);
            return this;
        }

        public Builder cacheActive(boolean cacheActive) {
            this.cacheActive = cacheActive;
            return this;
        }

        public Builder methodAccessValidator(MethodAccessValidator methodAccessValidator) {
            this.methodAccessValidator = methodAccessValidator;
            return this;
        }

        public Builder literalDecimalTreatedAsInteger(boolean literalDecimalTreatedAsInteger) {
            this.literalDecimalTreatedAsInteger = literalDecimalTreatedAsInteger;
            return this;
        }

        public Builder literalNumbersAsBigDecimals(boolean literalNumbersAsBigDecimals) {
            this.literalNumbersAsBigDecimals = literalNumbersAsBigDecimals;
            return this;
        }

        public Builder greedyMatchMethod(boolean greedyMatchMethod) {
            this.greedyMatchMethod = greedyMatchMethod;
            return this;
        }

        public Builder registerExtensionCustomizer(Function<Extension, ExtensionCustomizer> customizer) {
            this.factory.registerExtensionCustomizer(customizer);
            return this;
        }

        public PebbleEngine build() {
            ExtensionRegistry extensionRegistry = this.factory.buildExtensionRegistry();
            if (this.loader == null) {
                ArrayList defaultLoadingStrategies = new ArrayList();
                defaultLoadingStrategies.add(new ClasspathLoader());
                defaultLoadingStrategies.add(new FileLoader());
                this.loader = new DelegatingLoader(defaultLoadingStrategies);
            }
            if (this.defaultLocale == null) {
                this.defaultLocale = Locale.getDefault();
            }
            if (this.cacheActive) {
                if (this.templateCache == null) {
                    this.templateCache = new ConcurrentMapTemplateCache();
                }
                if (this.tagCache == null) {
                    this.tagCache = new ConcurrentMapTagCache();
                }
            } else {
                this.templateCache = new NoOpTemplateCache();
                this.tagCache = new NoOpTagCache();
            }
            if (this.syntax == null) {
                this.syntax = new Syntax.Builder().setEnableNewLineTrimming(this.enableNewLineTrimming).build();
            }
            ParserOptions parserOptions = new ParserOptions();
            parserOptions.setLiteralDecimalTreatedAsInteger(this.literalDecimalTreatedAsInteger);
            parserOptions.setLiteralNumbersAsBigDecimals(this.literalNumbersAsBigDecimals);
            EvaluationOptions evaluationOptions = new EvaluationOptions(this.greedyMatchMethod, this.methodAccessValidator);
            return new PebbleEngine(this.loader, this.syntax, this.strictVariables, this.defaultLocale, this.maxRenderedSize, this.tagCache, this.templateCache, this.executorService, extensionRegistry, parserOptions, evaluationOptions);
        }
    }
}

