/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import megamek.common.net.AbstractConnection;
import megamek.common.net.PacketReadState;

class DataStreamConnection
extends AbstractConnection {
    private DataInputStream in;
    private DataOutputStream out;
    protected boolean zipped = false;
    protected int encoding = -1;
    protected int len = 0;
    protected PacketReadState state = PacketReadState.Header;

    public DataStreamConnection(Socket socket, int n) {
        super(socket, n);
    }

    public DataStreamConnection(String string, int n, int n2) {
        super(string, n, n2);
    }

    protected AbstractConnection.INetworkPacket readNetworkPacket() throws Exception {
        NetworkPacket networkPacket = null;
        if (this.in == null) {
            this.in = new DataInputStream(new BufferedInputStream(this.getInputStream(), 1024));
            this.state = PacketReadState.Header;
        }
        switch (this.state) {
            case Header: {
                if (this.in.available() < 9) {
                    return null;
                }
                this.zipped = this.in.readBoolean();
                this.encoding = this.in.readInt();
                this.len = this.in.readInt();
                this.state = PacketReadState.Data;
            }
            case Data: {
                if ((this.len < 1000 || this.in.available() < 500) && this.in.available() < this.len) {
                    return null;
                }
                byte[] byArray = new byte[this.len];
                this.in.readFully(byArray);
                networkPacket = new NetworkPacket(this.zipped, this.encoding, byArray);
                this.state = PacketReadState.Header;
                return networkPacket;
            }
        }
        assert (false);
        assert (false);
        return null;
    }

    protected void sendNetworkPacket(byte[] byArray, boolean bl) throws Exception {
        if (this.out == null) {
            this.out = new DataOutputStream(new BufferedOutputStream(this.getOutputStream()));
        }
        this.out.writeBoolean(bl);
        this.out.writeInt(this.marshallingType);
        this.out.writeInt(byArray.length);
        this.out.write(byArray);
    }

    public synchronized void flush() {
        super.flush();
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close();
        }
    }

    private static class NetworkPacket
    implements AbstractConnection.INetworkPacket {
        private boolean compressed;
        private int marshallingType;
        private byte[] data;

        NetworkPacket(boolean bl, int n, byte[] byArray) {
            this.compressed = bl;
            this.marshallingType = n;
            this.data = byArray;
        }

        public int getMarshallingType() {
            return this.marshallingType;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean isCompressed() {
            return this.compressed;
        }
    }
}

