/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import megamek.client.ui.Messages;

public class CommonHelpDialog
extends JDialog {
    private static final long serialVersionUID = 5189627839475444823L;
    private JTextArea lblHelp;

    public CommonHelpDialog(JFrame jFrame, File file) {
        super(jFrame);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CommonHelpDialog.this.quit();
            }
        });
        this.setLayout(new BorderLayout());
        this.lblHelp = new JTextArea(Messages.getString("CommonHelpDialog.noHelp.Message"));
        this.lblHelp.setEditable(false);
        this.lblHelp.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(this.lblHelp, 22, 32);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(Messages.getString("CommonHelpDialog.Close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonHelpDialog.this.quit();
            }
        });
        this.getContentPane().add((Component)jButton, "South");
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width / 2, dimension.height / 2);
        this.pack();
        this.setSize(dimension2);
        this.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        this.setFile(file);
    }

    public void setFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        if (file == null) {
            this.setTitle(Messages.getString("CommonHelpDialog.noHelp.title"));
            stringBuffer.append(Messages.getString("CommonHelpDialog.noHelp.Message"));
        } else {
            this.setTitle(Messages.getString("CommonHelpDialog.helpFile") + file.getName());
            boolean bl = true;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" \n");
                    }
                    stringBuffer.append(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                if (!bl) {
                    stringBuffer.append("\n \n");
                }
                stringBuffer.append(Messages.getString("CommonHelpDialog.errorReading")).append(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        this.lblHelp.setText(stringBuffer.toString());
    }

    void quit() {
        this.setVisible(false);
    }
}

