/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.common.Coords;
import megamek.common.IHex;

class PlayerViewTransform
extends ViewTransform
implements MouseBehaviorCallback {
    static final Quat4d rotfix = C.mkquat(1.0, 0.0, 0.0, 1.5707963267948966);

    String getName() {
        return "Player View";
    }

    public void centerOnHex(Coords coords, IHex iHex) {
        if (coords == null || iHex == null) {
            return;
        }
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        multiTransformGroup.getTransformGroup(0).setTransform(new Transform3D(rotfix, new Vector3d((Tuple3d)BoardModel.getHexLocation(coords, iHex.getElevation())), 1.0));
    }

    void reset() {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        TransformGroup transformGroup = multiTransformGroup.getTransformGroup(1);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        transformGroup.setTransform(transform3D);
        TransformGroup transformGroup2 = multiTransformGroup.getTransformGroup(3);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotX(1.0471975511965976);
        transformGroup2.setTransform(transform3D2);
        TransformGroup transformGroup3 = multiTransformGroup.getTransformGroup(4);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3d(0.0, 0.0, 600.0));
        transformGroup3.setTransform(transform3D3);
    }

    protected void setup() {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        View view = this.universe.getViewer().getView();
        view.setProjectionPolicy(1);
        view.setScreenScalePolicy(0);
        TransformGroup transformGroup = multiTransformGroup.getTransformGroup(1);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        transformGroup.setTransform(transform3D);
        TransformGroup transformGroup2 = multiTransformGroup.getTransformGroup(2);
        Transform3D transform3D2 = new Transform3D();
        transformGroup2.setTransform(transform3D2);
        TransformGroup transformGroup3 = multiTransformGroup.getTransformGroup(3);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX(1.0471975511965976);
        transformGroup3.setTransform(transform3D3);
        TransformGroup transformGroup4 = multiTransformGroup.getTransformGroup(4);
        transformGroup4.setTransform(new Transform3D(new Quat4d(), new Vector3d(0.0, 0.0, 600.0), 1.0));
        Transform3D transform3D4 = new Transform3D();
        transform3D4.lookAt(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0));
        transform3D4.invert();
        multiTransformGroup.getTransformGroup(5).setTransform(transform3D4);
        MouseWheelZoom mouseWheelZoom = new MouseWheelZoom(transformGroup4);
        mouseWheelZoom.setFactor(-10.0);
        this.controllers.addChild((Node)mouseWheelZoom);
        mouseWheelZoom.setSchedulingBounds((Bounds)BoardModel.bounds);
        MouseRotate mouseRotate = new MouseRotate(transformGroup3);
        mouseRotate.setFactor(0.0, -0.002);
        this.controllers.addChild((Node)mouseRotate);
        mouseRotate.setSchedulingBounds((Bounds)BoardModel.bounds);
        MouseRotate mouseRotate2 = new MouseRotate(transformGroup);
        mouseRotate2.setFactor(-0.002, 0.0);
        this.controllers.addChild((Node)mouseRotate2);
        mouseRotate2.setSchedulingBounds((Bounds)BoardModel.bounds);
        MouseTranslate mouseTranslate = new MouseTranslate(transformGroup2);
        mouseTranslate.setFactor(-0.5);
        this.controllers.addChild((Node)mouseTranslate);
        mouseTranslate.setSchedulingBounds((Bounds)BoardModel.bounds);
        mouseTranslate.setupCallback((MouseBehaviorCallback)this);
        KeyNavigatorBehavior keyNavigatorBehavior = new KeyNavigatorBehavior(transformGroup2);
        this.controllers.addChild((Node)keyNavigatorBehavior);
        keyNavigatorBehavior.setSchedulingBounds((Bounds)BoardModel.bounds);
    }

    void zoom(int n) {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        TransformGroup transformGroup = multiTransformGroup.getTransformGroup(4);
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        Vector3d vector3d = new Vector3d();
        transform3D.get(vector3d);
        vector3d.z -= (double)(n * 4) * 30.0;
        transform3D.setTranslation(vector3d);
        transformGroup.setTransform(transform3D);
    }

    Node makeViewRelative(Node node, double d) {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        Transform3D transform3D = new Transform3D();
        multiTransformGroup.getTransformGroup(1).getTransform(transform3D);
        Transform3D transform3D2 = new Transform3D();
        multiTransformGroup.getTransformGroup(3).getTransform(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        Transform3D transform3D4 = new Transform3D();
        transform3D4.rotX(1.5707963267948966);
        transform3D3.setTranslation(new Vector3d(0.0, -d, 1.0));
        TransformGroup transformGroup = new TransformGroup(transform3D2);
        transformGroup.setCapability(18);
        TransformGroup transformGroup2 = new TransformGroup(transform3D3);
        TransformGroup transformGroup3 = new TransformGroup(transform3D);
        transformGroup3.setCapability(18);
        TransformGroup transformGroup4 = new TransformGroup(transform3D4);
        transformGroup4.addChild((Node)transformGroup3);
        transformGroup3.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)transformGroup);
        transformGroup.addChild(node);
        BranchGroup branchGroup = new BranchGroup();
        MouseRotate mouseRotate = new MouseRotate(transformGroup);
        mouseRotate.setFactor(0.0, -0.002);
        branchGroup.addChild((Node)mouseRotate);
        mouseRotate.setSchedulingBounds((Bounds)BoardModel.bounds);
        MouseRotate mouseRotate2 = new MouseRotate(transformGroup3);
        mouseRotate2.setFactor(-0.002, 0.0);
        branchGroup.addChild((Node)mouseRotate2);
        mouseRotate2.setSchedulingBounds((Bounds)BoardModel.bounds);
        branchGroup.addChild((Node)transformGroup4);
        return branchGroup;
    }

    public void transformChanged(int n, Transform3D transform3D) {
        if (n != 1) {
            return;
        }
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        Transform3D transform3D2 = new Transform3D();
        multiTransformGroup.getTransformGroup(0).getTransform(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        multiTransformGroup.getTransformGroup(1).getTransform(transform3D3);
        Vector3d vector3d = new Vector3d();
        transform3D.get(vector3d);
        Point3d point3d = new Point3d((Tuple3d)vector3d);
        transform3D3.transform(point3d);
        transform3D2.transform(point3d);
        transform3D2.setTranslation(new Vector3d((Tuple3d)point3d));
        multiTransformGroup.getTransformGroup(0).setTransform(transform3D2);
        multiTransformGroup.getTransformGroup(2).setTransform(new Transform3D());
    }
}

