/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import megamek.client.ui.AWT.DialogOptionListener;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;

public class DialogOptionComponent
extends Panel
implements MouseListener,
ItemListener {
    private static final long serialVersionUID = 4062277493444205351L;
    IOption option;
    private Checkbox checkbox;
    private Choice choice;
    private TextField textField;
    private Label label;
    private DialogOptionListener parent;

    public DialogOptionComponent(DialogOptionListener dialogOptionListener, IOption iOption) {
        this(dialogOptionListener, iOption, true);
    }

    public DialogOptionComponent(DialogOptionListener dialogOptionListener, IOption iOption, boolean bl) {
        this.parent = dialogOptionListener;
        this.option = iOption;
        this.addMouseListener(this);
        this.setLayout(new BorderLayout());
        switch (iOption.getType()) {
            case 0: {
                this.checkbox = new Checkbox(iOption.getDisplayableName(), iOption.booleanValue());
                this.checkbox.addMouseListener(this);
                this.checkbox.addItemListener(this);
                this.add((Component)this.checkbox, "Center");
                if (bl) break;
                this.checkbox.setEnabled(false);
                break;
            }
            case 4: {
                this.choice = new Choice();
                this.choice.addMouseListener(this);
                this.label = new Label(iOption.getDisplayableName());
                this.label.addMouseListener(this);
                this.add((Component)this.label, "West");
                this.add((Component)this.choice, "Center");
                if (bl) break;
                this.choice.setEnabled(false);
                break;
            }
            default: {
                this.textField = new TextField(iOption.stringValue(), iOption.getTextFieldLength());
                this.textField.addMouseListener(this);
                this.label = new Label(iOption.getDisplayableName());
                this.label.addMouseListener(this);
                if (iOption.isLabelBeforeTextField()) {
                    this.add((Component)this.label, "Center");
                    this.add((Component)this.textField, "West");
                } else {
                    this.add((Component)this.textField, "West");
                    this.add((Component)this.label, "Center");
                }
                if (bl) break;
                this.textField.setEnabled(false);
            }
        }
    }

    public boolean hasChanged() {
        return !this.option.getValue().equals(this.getValue());
    }

    public Object getValue() {
        String string = "";
        switch (this.option.getType()) {
            case 0: {
                return new Boolean(this.checkbox.getState());
            }
            case 1: {
                string = this.textField.getText();
                if (string.trim().equals("")) {
                    string = "0";
                }
                return Integer.valueOf(string);
            }
            case 2: {
                string = this.textField.getText();
                if (string.trim().equals("")) {
                    string = "0";
                }
                return Float.valueOf(string);
            }
            case 3: {
                return this.textField.getText();
            }
            case 4: {
                return this.choice.getSelectedItem();
            }
        }
        return null;
    }

    public IOption getOption() {
        return this.option;
    }

    public void setEditable(boolean bl) {
        switch (this.option.getType()) {
            case 0: {
                this.checkbox.setEnabled(bl);
                break;
            }
            case 4: {
                this.choice.setEnabled(bl);
                break;
            }
            default: {
                this.textField.setEnabled(bl);
            }
        }
    }

    public void setState(boolean bl) {
        this.checkbox.setState(bl);
    }

    public void setSelected(String string) {
        this.choice.select(string);
    }

    public void addValue(String string) {
        this.choice.add(string);
    }

    public void resetToDefault() {
        switch (this.option.getType()) {
            case 0: {
                this.checkbox.setState((Boolean)this.option.getDefault());
                break;
            }
            case 4: {
                this.choice.select(0);
                break;
            }
            default: {
                this.textField.setText(String.valueOf(this.option.getDefault()));
            }
        }
    }

    public IBasicOption changedOption() {
        return new BasicOption(this.option.getName(), this.getValue());
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.parent.showDescFor(this.option);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.parent.optionClicked(this, this.option, this.checkbox.getState());
    }

    private static class BasicOption
    implements IBasicOption,
    Serializable {
        private static final long serialVersionUID = -8128677074350169153L;
        private String name;
        private Object value;

        BasicOption(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

