/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.options;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rundeck.client.api.model.DateInfo;
import org.rundeck.client.tool.options.JobIdentOptions;
import picocli.CommandLine;

public class RunBaseOptions
extends JobIdentOptions {
    @CommandLine.Option(names={"-l", "--loglevel"}, description={"Run the command using the specified LEVEL. LEVEL can be debug, verbose, info, warning, error."}, defaultValue="info")
    private Loglevel loglevel;
    @CommandLine.Option(names={"-u", "--user"}, description={"A username to run the job as, (runAs access required)."})
    private String user;
    @CommandLine.Option(names={"-@", "--at"}, description={"Run the job at the specified date/time. ISO8601 format (yyyy-MM-dd'T'HH:mm:ssXX)"})
    private DateInfo runAtDate;
    @CommandLine.Option(names={"-d", "--delay"}, description={"Run the job at a certain time from now. Format: ##[smhdwMY] where ## is an integer and the units are seconds, minutes, hours, days, weeks, Months, Years. Can combine units, e.g. \"2h30m\", \"20m30s\""})
    private String runDelay;
    public static Pattern RUN_DELAY_PATTERN = Pattern.compile("(\\d+[smhdwMY]\\s*)+");
    @CommandLine.Option(names={"--raw"}, description={"Treat option values as raw text, so that '-opt @value' is sent literally"})
    private boolean rawOptions;
    @CommandLine.Parameters(paramLabel="-OPT VAL or -OPTFILE @filepath", description={"Job options as \"-opt value\". Upload files as \"-opt @path\" or \"-opt@ path\"."})
    private List<String> commandString;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public boolean isUser() {
        return this.user != null;
    }

    public boolean isRunAtDate() {
        return this.runAtDate != null;
    }

    public boolean isRunDelay() {
        return this.runDelay != null;
    }

    @Override
    public void validate() {
        Matcher m;
        if (this.isRunDelay() && !(m = RUN_DELAY_PATTERN.matcher(this.getRunDelay())).matches()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "-d/--delay is not valid: " + this.getRunDelay() + ", must match: " + RUN_DELAY_PATTERN);
        }
    }

    public Loglevel getLoglevel() {
        return this.loglevel;
    }

    public String getUser() {
        return this.user;
    }

    public DateInfo getRunAtDate() {
        return this.runAtDate;
    }

    public String getRunDelay() {
        return this.runDelay;
    }

    public boolean isRawOptions() {
        return this.rawOptions;
    }

    public List<String> getCommandString() {
        return this.commandString;
    }

    @Override
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    public void setLoglevel(Loglevel loglevel) {
        this.loglevel = loglevel;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setRunAtDate(DateInfo runAtDate) {
        this.runAtDate = runAtDate;
    }

    public void setRunDelay(String runDelay) {
        this.runDelay = runDelay;
    }

    public void setRawOptions(boolean rawOptions) {
        this.rawOptions = rawOptions;
    }

    public void setCommandString(List<String> commandString) {
        this.commandString = commandString;
    }

    @Override
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    public static enum Loglevel {
        debug,
        verbose,
        info,
        warning,
        error;

    }
}

