/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.system;

import java.io.IOException;
import java.util.function.Function;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.ExecutionMode;
import org.rundeck.client.api.model.SystemInfo;
import org.rundeck.client.api.model.SystemMode;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.QuietOption;
import picocli.CommandLine;
import retrofit2.Call;

@CommandLine.Command(description={"Manage Execution Mode"}, name="mode")
public class Mode
extends BaseCommand {
    @CommandLine.Command(description={"Show execution mode\nWhen --testactive or --testpassive are used, the exit code will be 0 if the test is successful, 1 otherwise."})
    public int info(@CommandLine.Mixin ModeInfo opts) throws IOException, InputError {
        if (opts.isTestPassive() && opts.isTestActive()) {
            throw new InputError("--testactive and --testpassive cannot be combined");
        }
        SystemInfo systemInfo = (SystemInfo)this.apiCall(RundeckApi::systemInfo);
        Object executionMode = systemInfo.system.getExecutions().get("executionMode");
        boolean modeIsActive = "active".equals(executionMode);
        boolean testpass = true;
        String message = "Execution Mode is currently:";
        if (opts.isTestActive() && !modeIsActive || opts.isTestPassive() && modeIsActive) {
            testpass = false;
            this.getRdOutput().warning(message);
        } else {
            this.getRdOutput().info(message);
        }
        this.getRdOutput().output(executionMode);
        return testpass ? 0 : 1;
    }

    @CommandLine.Command(description={"Set execution mode Active"})
    public boolean active(@CommandLine.Mixin QuietOption opts) throws IOException, InputError {
        return this.changeMode(opts, ExecutionMode.active, RundeckApi::executionModeEnable);
    }

    @CommandLine.Command(description={"Set execution mode Passive"})
    public boolean passive(@CommandLine.Mixin QuietOption opts) throws IOException, InputError {
        return this.changeMode(opts, ExecutionMode.passive, RundeckApi::executionModeDisable);
    }

    boolean changeMode(QuietOption opts, ExecutionMode expected, Function<RundeckApi, Call<SystemMode>> operation) throws InputError, IOException {
        if (!opts.isQuiet()) {
            this.getRdOutput().info(String.format("Setting execution mode to %s...", new Object[]{expected}));
        }
        SystemMode mode = (SystemMode)this.apiCall(operation);
        if (!opts.isQuiet()) {
            this.getRdOutput().info("Execution Mode is now:");
            this.getRdOutput().output((Object)mode.getExecutionMode());
        }
        return expected.equals((Object)mode.getExecutionMode());
    }

    static class ModeInfo {
        @CommandLine.Option(names={"-A", "--testactive"}, description={"Test whether the execution mode is active: fail if not"})
        boolean testActive;
        @CommandLine.Option(names={"-P", "--testpassive"}, description={"Test whether the execution mode is passive: fail if not"})
        boolean testPassive;

        ModeInfo() {
        }

        public boolean isTestActive() {
            return this.testActive;
        }

        public boolean isTestPassive() {
            return this.testPassive;
        }

        public void setTestActive(boolean testActive) {
            this.testActive = testActive;
        }

        public void setTestPassive(boolean testPassive) {
            this.testPassive = testPassive;
        }
    }
}

