/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.repository;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.repository.RepositoryResponseHandler;
import org.rundeck.client.tool.extension.RdCommandExtension;
import org.rundeck.client.tool.extension.RdOutput;
import org.rundeck.client.tool.extension.RdTool;
import picocli.CommandLine;

@CommandLine.Command(description={"Install a plugin from your plugin repository into your Rundeck instance"}, name="install")
public class InstallPlugin
implements RdCommandExtension,
RdOutput,
Callable<Boolean> {
    private RdTool rdTool;
    private CommandOutput rdOutput;
    @CommandLine.Option(names={"-r", "--repository"}, description={"Repository name that contains the plugin."}, required=true)
    String repoName;
    @CommandLine.Option(names={"--id", "-i"}, description={"Id of the plugin you want to install"}, required=true)
    String pluginId;
    @CommandLine.Option(names={"--version", "-v"}, description={"(Optional) Specific version of the plugin you want to install"})
    String version;

    @Override
    public Boolean call() throws InputError, IOException {
        RepositoryResponseHandler.handle(this.rdTool.apiWithErrorResponse(api -> {
            if (this.version != null) {
                return api.installPlugin(this.repoName, this.pluginId, this.version);
            }
            return api.installPlugin(this.repoName, this.pluginId);
        }), this.rdOutput);
        return true;
    }

    @Override
    public void setRdTool(RdTool rdTool) {
        this.rdTool = rdTool;
    }

    @Override
    public void setRdOutput(CommandOutput rdOutput) {
        this.rdOutput = rdOutput;
    }
}

