/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.projects;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.RequestBody;
import org.rundeck.client.api.RequestFailed;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.ScmActionInputsResult;
import org.rundeck.client.api.model.ScmActionPerform;
import org.rundeck.client.api.model.ScmActionResult;
import org.rundeck.client.api.model.ScmConfig;
import org.rundeck.client.api.model.ScmExportItem;
import org.rundeck.client.api.model.ScmImportItem;
import org.rundeck.client.api.model.ScmInputField;
import org.rundeck.client.api.model.ScmPlugin;
import org.rundeck.client.api.model.ScmPluginsResult;
import org.rundeck.client.api.model.ScmProjectStatusResult;
import org.rundeck.client.api.model.ScmSetupInputsResult;
import org.rundeck.client.api.model.ScmSynchState;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.OptionUtil;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.tool.options.ProjectRequiredNameOptions;
import org.rundeck.client.tool.options.VerboseOption;
import org.rundeck.client.tool.util.Colorz;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.ServiceClient;
import picocli.CommandLine;
import retrofit2.Response;

@CommandLine.Command(description={"Manage Project SCM"}, name="scm")
public class SCM
extends BaseCommand {
    static final List<String> INTEGRATIONS = new ArrayList<String>(Arrays.asList("import", "export"));
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    String validate(BaseOpts opts) throws InputError {
        if (!INTEGRATIONS.contains(opts.getIntegration())) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "--integration/-i must be one of: " + INTEGRATIONS);
        }
        if (null != opts.getProject()) {
            ProjectRequiredNameOptions.validateProjectName(opts.getProject(), this.spec);
        }
        return this.getRdTool().projectOrEnv(opts);
    }

    @CommandLine.Command(description={"Get SCM Config for a Project"})
    public void config(@CommandLine.Mixin BaseOpts opts, @CommandLine.Option(names={"--file", "-f"}, description={"If specified, write config to a file (json format)"}) File file) throws IOException, InputError {
        String project = this.validate(opts);
        ScmConfig scmConfig1 = (ScmConfig)this.apiCall(api -> api.getScmConfig(project, opts.getIntegration()));
        HashMap<String, String> basic = new HashMap<String, String>();
        basic.put("Project", scmConfig1.project);
        basic.put("SCM Plugin type", scmConfig1.type);
        basic.put("SCM Plugin integration", scmConfig1.integration);
        this.getRdOutput().info(basic);
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        map.put("config", scmConfig1.config);
        if (file != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.writeValue(file, map);
            this.getRdOutput().info("Wrote config to file: " + file);
        } else {
            this.getRdOutput().output(map);
        }
    }

    @CommandLine.Command(description={"Setup SCM Config for a Project"})
    public boolean setup(@CommandLine.Mixin BaseOpts opts, @CommandLine.Mixin TypeOptions typeOptions, @CommandLine.Mixin FileOptions fileOptions) throws IOException, InputError {
        String project = this.validate(opts);
        RequestBody requestBody = RequestBody.create(fileOptions.getFile(), Client.MEDIA_TYPE_JSON);
        ServiceClient.WithErrorResponse<ScmActionResult> response = this.getRdTool().apiWithErrorResponse(api -> api.setupScmConfig(project, opts.getIntegration(), typeOptions.getType(), requestBody));
        if (SCM.hasValidationError(this.getRdOutput(), this.getRdTool().getClient(), response, "Setup config Validation for file: " + fileOptions.getFile().getAbsolutePath(), this.getRdTool().getAppConfig().isAnsiEnabled())) {
            return false;
        }
        ScmActionResult result = this.getRdTool().getClient().checkError(response);
        return this.outputScmActionResult(this.getRdOutput(), result, "Setup");
    }

    private boolean outputScmActionResult(CommandOutput output, ScmActionResult result, String name) {
        if (result.success) {
            this.getRdOutput().info(name + " was successful.");
        } else {
            this.getRdOutput().warning(name + " was not successful.");
        }
        if (result.message != null) {
            this.getRdOutput().info("Result: " + result.message);
        }
        if (result.nextAction != null) {
            this.getRdOutput().output(CommandLine.Help.Ansi.AUTO.string("Next Action: @|green " + result.nextAction + "|@"));
        }
        return result.success;
    }

    @CommandLine.Command(description={"Get SCM Status for a Project"})
    public boolean status(@CommandLine.Mixin BaseOpts opts) throws IOException, InputError {
        String project = this.validate(opts);
        ScmProjectStatusResult result = (ScmProjectStatusResult)this.apiCall(api -> api.getScmProjectStatus(project, opts.getIntegration()));
        this.getRdOutput().output(result.toMap());
        return result.synchState == ScmSynchState.CLEAN;
    }

    @CommandLine.Command(description={"Enable plugin "})
    public void enable(@CommandLine.Mixin BaseOpts opts, @CommandLine.Mixin TypeOptions options) throws IOException, InputError {
        String project = this.validate(opts);
        this.apiCall(api -> api.enableScmPlugin(project, opts.getIntegration(), options.getType()));
    }

    @CommandLine.Command(description={"Disable plugin "})
    public void disable(@CommandLine.Mixin BaseOpts opts, @CommandLine.Mixin TypeOptions options) throws IOException, InputError {
        String project = this.validate(opts);
        this.apiCall(api -> api.disableScmPlugin(project, opts.getIntegration(), options.getType()));
    }

    @CommandLine.Command(description={"Get SCM Setup inputs"})
    public void setupinputs(@CommandLine.Mixin BaseOpts opts, @CommandLine.Mixin TypeOptions options, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        String project = this.validate(opts);
        ScmSetupInputsResult result = (ScmSetupInputsResult)this.apiCall(api -> api.getScmSetupInputs(project, opts.getIntegration(), options.getType()));
        if (verboseOption.isVerbose()) {
            this.getRdOutput().output(result);
            return;
        }
        this.getRdOutput().output(result.fields.stream().map(ScmInputField::asMap).collect(Collectors.toList()));
    }

    @CommandLine.Command(description={"Get SCM action inputs"})
    public void inputs(@CommandLine.Mixin BaseOpts opts, @CommandLine.Mixin ActionInputsOptions options, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        String project = this.validate(opts);
        ScmActionInputsResult result = (ScmActionInputsResult)this.apiCall(api -> api.getScmActionInputs(project, opts.getIntegration(), options.getAction()));
        if (verboseOption.isVerbose()) {
            this.getRdOutput().output(result);
            return;
        }
        this.getRdOutput().output(result.title + ": " + result.description);
        this.getRdOutput().output("Fields:");
        this.getRdOutput().output(result.fields.stream().map(ScmInputField::asMap).collect(Collectors.toList()));
        this.getRdOutput().output("Items:");
        if ("export".equals(opts.getIntegration())) {
            this.getRdOutput().output(result.exportItems.stream().map(ScmExportItem::asMap).collect(Collectors.toList()));
        } else {
            this.getRdOutput().output(result.importItems.stream().map(ScmImportItem::asMap).collect(Collectors.toList()));
        }
    }

    @CommandLine.Command(description={"Perform SCM action"})
    public boolean perform(@CommandLine.Mixin BaseOpts opts, @CommandLine.Mixin ActionPerformOptions options) throws IOException, InputError {
        ScmActionPerform perform = this.performFromOptions(options);
        String project = this.validate(opts);
        boolean export = "export".equals(opts.getIntegration());
        if (options.isAllItems() || export && (options.isAllDeletedItems() || options.isAllModifiedItems()) || !export && (options.isAllTrackedItems() || options.isAllUntrackedItems())) {
            ScmActionInputsResult inputs = (ScmActionInputsResult)this.apiCall(api -> api.getScmActionInputs(project, opts.getIntegration(), options.getAction()));
            if (export) {
                List<ScmExportItem> exportItems = inputs.exportItems;
                if (options.isAllItems() || options.isAllModifiedItems()) {
                    perform.setItems(exportItems.stream().filter(a -> !a.getDeleted()).map(a -> a.itemId).collect(Collectors.toList()));
                }
                if (options.isAllItems() || options.isAllDeletedItems()) {
                    perform.setDeleted(exportItems.stream().filter(ScmExportItem::getDeleted).map(a -> a.itemId).collect(Collectors.toList()));
                }
            } else {
                List<ScmImportItem> importItems = inputs.importItems;
                perform.setItems(importItems.stream().filter(a -> !a.deleted && (options.isAllItems() || options.isAllTrackedItems() && a.tracked != false || options.isAllUntrackedItems() && a.tracked == false)).map(a -> a.itemId).collect(Collectors.toList()));
                perform.setDeletedJobs(importItems.stream().filter(a -> a.deleted && a.job != null && (options.isAllItems() || options.isAllTrackedItems() && a.tracked != false || options.isAllUntrackedItems() && a.tracked == false)).map(a -> a.job.jobId).collect(Collectors.toList()));
            }
        }
        ServiceClient.WithErrorResponse<ScmActionResult> response = this.getRdTool().apiWithErrorResponse(api -> api.performScmAction(project, opts.getIntegration(), options.getAction(), perform));
        if (SCM.hasValidationError(this.getRdOutput(), this.getRdTool().getClient(), response, "Action " + options.getAction(), this.getRdTool().getAppConfig().isAnsiEnabled())) {
            return false;
        }
        ScmActionResult result = this.getRdTool().getClient().checkError(response);
        return this.outputScmActionResult(this.getRdOutput(), result, "Action " + options.getAction());
    }

    private ScmActionPerform performFromOptions(ActionPerformOptions options) throws InputError {
        ScmActionPerform perform = new ScmActionPerform();
        if (null != options.getFields()) {
            perform.setInput(OptionUtil.parseKeyValueMap(options.getFields(), null, "="));
        } else {
            perform.setInput(new HashMap<String, String>());
        }
        ArrayList item = options.getItem();
        perform.setItems(item != null ? item : new ArrayList());
        ArrayList job = options.getJob();
        perform.setJobs(job != null ? job : new ArrayList());
        ArrayList delete = options.getDelete();
        perform.setDeleted(delete != null ? delete : new ArrayList());
        return perform;
    }

    @CommandLine.Command(description={"List SCM plugins"})
    public void plugins(@CommandLine.Mixin BaseOpts opts) throws IOException, InputError {
        String project = this.validate(opts);
        ScmPluginsResult result = (ScmPluginsResult)this.apiCall(api -> api.listScmPlugins(project, opts.getIntegration()));
        this.getRdOutput().output(result.plugins.stream().map(ScmPlugin::toMap).collect(Collectors.toList()));
    }

    private static boolean hasValidationError(CommandOutput output, ServiceClient<RundeckApi> serviceClient, ServiceClient.WithErrorResponse<ScmActionResult> errorResponse, String name, boolean colorize) {
        Response<ScmActionResult> response = errorResponse.getResponse();
        if (errorResponse.isError400()) {
            try {
                ScmActionResult error = serviceClient.readError(errorResponse.getErrorBody(), ScmActionResult.class, Client.MEDIA_TYPE_JSON);
                if (null != error) {
                    output.error(String.format("%s failed", name));
                    if (null != error.message) {
                        output.warning(error.message);
                    }
                    Optional<Map<?, ?>> errorData = Optional.ofNullable(error.toMap());
                    errorData.ifPresent(map -> output.output(colorize ? Colorz.colorizeMapRecurse(map, "yellow") : map));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RequestFailed(String.format("%s failed: (error: %d %s)", name, response.code(), response.message()), response.code(), response.message());
            }
        }
        return !response.isSuccessful();
    }

    public static class ActionPerformOptions
    extends ActionInputsOptions {
        @CommandLine.Option(names={"--field", "-f"}, arity="1..*", description={"Field input values, space separated key=value list"})
        private List<String> fields;
        @CommandLine.Option(names={"--item", "-I"}, arity="1..*", description={"Items to include, space separated list"})
        private List<String> item;
        @CommandLine.Option(names={"-A", "--allitems"}, description={"Include all items from the result of calling Inputs in export or import action"})
        boolean allItems;
        @CommandLine.Option(names={"-M", "--allmodified"}, description={"Include all modified (not deleted) items from the result of calling Inputs in Export action (export only)"})
        boolean allModifiedItems;
        @CommandLine.Option(names={"-D", "--alldeleted"}, description={"Include all deleted items from the result of calling Inputs in Export action (export only)"})
        boolean allDeletedItems;
        @CommandLine.Option(names={"-T", "--alltracked"}, description={"Include all tracked (not new) items from the result of calling Inputs in Import action (import only)"})
        boolean allTrackedItems;
        @CommandLine.Option(names={"-U", "--alluntracked"}, description={"Include all untracked (new) items from the result of calling Inputs in Import action (import only)"})
        boolean allUntrackedItems;
        @CommandLine.Option(names={"--job", "-j"}, arity="1..*", description={"Job IDs to include, space separated list"})
        List<String> job;
        @CommandLine.Option(names={"--delete", "-d"}, arity="1..*", description={"Job IDs or Item Ids to delete, space separated list"})
        List<String> delete;

        public List<String> getFields() {
            return this.fields;
        }

        public List<String> getItem() {
            return this.item;
        }

        public boolean isAllItems() {
            return this.allItems;
        }

        public boolean isAllModifiedItems() {
            return this.allModifiedItems;
        }

        public boolean isAllDeletedItems() {
            return this.allDeletedItems;
        }

        public boolean isAllTrackedItems() {
            return this.allTrackedItems;
        }

        public boolean isAllUntrackedItems() {
            return this.allUntrackedItems;
        }

        public List<String> getJob() {
            return this.job;
        }

        public List<String> getDelete() {
            return this.delete;
        }

        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void setItem(List<String> item) {
            this.item = item;
        }

        public void setAllItems(boolean allItems) {
            this.allItems = allItems;
        }

        public void setAllModifiedItems(boolean allModifiedItems) {
            this.allModifiedItems = allModifiedItems;
        }

        public void setAllDeletedItems(boolean allDeletedItems) {
            this.allDeletedItems = allDeletedItems;
        }

        public void setAllTrackedItems(boolean allTrackedItems) {
            this.allTrackedItems = allTrackedItems;
        }

        public void setAllUntrackedItems(boolean allUntrackedItems) {
            this.allUntrackedItems = allUntrackedItems;
        }

        public void setJob(List<String> job) {
            this.job = job;
        }

        public void setDelete(List<String> delete) {
            this.delete = delete;
        }
    }

    public static class ActionInputsOptions {
        @CommandLine.Option(names={"--action", "-a"}, description={"Action ID"}, required=true)
        private String action;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }

    static class FileOptions {
        @CommandLine.Option(names={"--file", "-f"}, description={"Config file (json format)"}, required=true)
        private File file;

        FileOptions() {
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    static class TypeOptions {
        @CommandLine.Option(names={"--type", "-t"}, description={"Plugin type"}, required=true)
        private String type;

        TypeOptions() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    static class BaseOpts
    extends ProjectNameOptions {
        @CommandLine.Option(names={"--integration", "-i"}, completionCandidates=IntegrationCandidates.class, description={"Integration type: ${COMPLETION-CANDIDATES}"}, required=true)
        private String integration;

        BaseOpts() {
        }

        public String getIntegration() {
            return this.integration;
        }

        public void setIntegration(String integration) {
            this.integration = integration;
        }
    }

    static class IntegrationCandidates
    extends ArrayList<String> {
        IntegrationCandidates() {
            super(INTEGRATIONS);
        }
    }
}

