/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.enterprise.license;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.enterprise.BaseExtension;
import org.rundeck.client.tool.commands.enterprise.api.EnterpriseApi;
import org.rundeck.client.tool.commands.enterprise.api.model.LicenseResponse;
import org.rundeck.client.tool.commands.enterprise.api.model.LicenseStoreResponse;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.util.Format;
import picocli.CommandLine;

@CommandLine.Command(name="license", description={"Manage Rundeck Enterprise License"})
public class License
extends BaseExtension {
    public static final MediaType LICENSE_KEY_MEDIA_TYPE = MediaType.parse("application/x-rundeck-license");

    @CommandLine.Command(description={"license status"})
    public boolean status(@CommandLine.Mixin StatusOpts opts) throws InputError, IOException {
        RdTool.apiVersionCheck("license status", 41, this.getClient().getApiVersion());
        LicenseResponse response = (LicenseResponse)this.getClient().apiCall(EnterpriseApi::verifyLicense);
        if (opts.getOutputFormat() != null) {
            Function<LicenseResponse, String> outformat = Format.formatter(opts.getOutputFormat(), LicenseResponse::asMap, "%", "");
            this.getOutput().output(outformat.apply(response));
        } else {
            String status = String.format("Status: %s", response.getState());
            if (response.isActive()) {
                this.getOutput().info(status);
            } else {
                this.getOutput().warning(status);
            }
            if (response.getReason() != null) {
                this.getOutput().info(response.getReason());
            }
            if (response.isShouldWarn()) {
                this.getOutput().warning(response.getWarning());
            }
            if (opts.isVerbose()) {
                this.getOutput().output(response);
            }
        }
        if (opts.remaining != null && response.getRemaining() < opts.getRemaining()) {
            if (opts.outputFormat == null) {
                this.getOutput().error(String.format("Days remaining: %d < %d", response.getRemaining(), opts.getRemaining()));
            }
            return false;
        }
        return !opts.isStatus() || response.isActive();
    }

    @CommandLine.Command(description={"Store license"})
    public void store(@CommandLine.Option(names={"--agree"}, description={"Agree to the license"}) boolean agree, @CommandLine.Option(names={"-f", "--file"}, description={"Rundeck Enterprise License Key File"}, required=true) File file) throws InputError, IOException {
        RdTool.apiVersionCheck("Store License", 41, this.getClient().getApiVersion());
        RequestBody body = RequestBody.create(file, LICENSE_KEY_MEDIA_TYPE);
        LicenseStoreResponse response = (LicenseStoreResponse)this.getClient().apiCall(api -> api.storeLicense(body, agree));
        this.getOutput().output(response);
    }

    static class StatusOpts {
        @CommandLine.Option(names={"-v", "--verbose"}, description={"Show verbose output"})
        private boolean verbose;
        @CommandLine.Option(names={"-s", "--status"}, description={"Succeed if license status is active, fail if not active."})
        boolean status;
        @CommandLine.Option(names={"-r", "--remaining"}, description={"Fail if fewer than the specified days remain in license."})
        Integer remaining;
        @CommandLine.Option(names={"-%", "--outformat"}, description={"Output format specifier for license data. You can use \"%%key\" where key is one of: applicationVersion, gracePeriod, reason, validSince, contactEmail, shouldWarn, active, edition, type, perpetual, invalidCode, remaining, baseUrl, editions, application, serverUUIDs, validUntil, warning, company, state, issueDate, licenseId, graceUntil. E.g. \"%%state, %%remaining\""})
        String outputFormat;

        StatusOpts() {
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public boolean isStatus() {
            return this.status;
        }

        public Integer getRemaining() {
            return this.remaining;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public void setRemaining(Integer remaining) {
            this.remaining = remaining;
        }

        public void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }
    }
}

