/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.enterprise.cluster;

import java.io.IOException;
import java.util.function.BiFunction;
import org.rundeck.client.api.model.ExecutionMode;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.enterprise.BaseExtension;
import org.rundeck.client.tool.commands.enterprise.api.EnterpriseApi;
import org.rundeck.client.tool.commands.enterprise.api.model.EnterpriseModeResponse;
import org.rundeck.client.tool.extension.RdTool;
import picocli.CommandLine;
import retrofit2.Call;

@CommandLine.Command(name="mode", description={"Change Execution Mode of Cluster Members"})
public class Mode
extends BaseExtension {
    @CommandLine.Command(description={"Set cluster member execution mode Active"})
    public boolean active(@CommandLine.Mixin Options options) throws IOException, InputError {
        return this.changeMode(ExecutionMode.active, options, EnterpriseApi::executionModeEnable);
    }

    @CommandLine.Command(description={"Set cluster member execution mode Passive"})
    public boolean passive(@CommandLine.Mixin Options options) throws IOException, InputError {
        return this.changeMode(ExecutionMode.passive, options, EnterpriseApi::executionModeDisable);
    }

    boolean changeMode(ExecutionMode expected, Options options, BiFunction<EnterpriseApi, String, Call<EnterpriseModeResponse>> operation) throws InputError, IOException {
        RdTool.apiVersionCheck("change cluster member execution mode", 41, this.getClient().getApiVersion());
        if (!options.isQuiet()) {
            this.getOutput().info(String.format("Setting Execution Mode to %s for cluster member %s...", new Object[]{expected, options.getUuid()}));
        }
        EnterpriseModeResponse mode = (EnterpriseModeResponse)this.getClient().apiCall(e -> (Call)operation.apply((EnterpriseApi)e, options.getUuid()));
        if (!options.isQuiet()) {
            this.getOutput().info(String.format("Execution Mode change is %s for cluster member %s:", mode.getStatus(), options.getUuid()));
            this.getOutput().output((Object)mode.getExecutionMode());
        }
        return expected.equals((Object)mode.getExecutionMode());
    }

    static class Options {
        @CommandLine.Option(names={"-q", "--quiet"}, description={"Reduce output."})
        boolean quiet;
        @CommandLine.Option(names={"-u", "--uuid"}, description={"Cluster member UUID"}, required=true)
        String uuid;

        Options() {
        }

        public boolean isQuiet() {
            return this.quiet;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }
    }
}

