/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobFileUploadResult;
import org.rundeck.client.api.model.JobItem;
import org.rundeck.client.api.model.JobRun;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.Executions;
import org.rundeck.client.tool.commands.GetInput;
import org.rundeck.client.tool.commands.Jobs;
import org.rundeck.client.tool.commands.jobs.Files;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.tool.options.ExecutionOutputFormatOption;
import org.rundeck.client.tool.options.FollowOptions;
import org.rundeck.client.tool.options.JobIdentOptions;
import org.rundeck.client.tool.options.NodeFilterBaseOptions;
import org.rundeck.client.tool.options.RunBaseOptions;
import org.rundeck.client.util.Format;
import org.rundeck.client.util.Quoting;
import picocli.CommandLine;
import retrofit2.Call;

@CommandLine.Command(description={"Run a Job."}, name="run", showEndOfOptionsDelimiterInUsageHelp=true)
public class Run
extends BaseCommand
implements Callable<Integer> {
    public static final int SEC_MS = 1000;
    public static final int MIN_MS = 60000;
    public static final int HOUR_MS = 3600000;
    public static final int DAY_MS = 86400000;
    public static final int WEEK_MS = 604800000;
    public static final int RUN_FAILED_EXIT_CODE = 2;
    public static final int RUN_SUCCEED_EXIT_CODE = 0;
    @CommandLine.Mixin
    final RunBaseOptions options = new RunBaseOptions();
    @CommandLine.Mixin
    final FollowOptions followOptions = new FollowOptions();
    @CommandLine.Mixin
    final NodeFilterBaseOptions nodeFilterOptions = new NodeFilterBaseOptions();
    @CommandLine.Mixin
    final ExecutionOutputFormatOption outputFormatOption = new ExecutionOutputFormatOption();

    @Override
    public Integer call() throws IOException, InputError {
        String started;
        Execution execution;
        String loglevel;
        this.options.validate();
        String jobId = Run.getJobIdFromOpts(this.options, this.getRdOutput(), this.getRdTool(), () -> this.getRdTool().projectOrEnv(this.options));
        if (null == jobId) {
            throw new InputError("jobId is required");
        }
        Date runat = null;
        String string = loglevel = null != this.options.getLoglevel() ? this.options.getLoglevel().toString().toUpperCase() : null;
        if (this.getRdTool().getClient().getApiVersion() >= 18) {
            JobRun request = new JobRun();
            request.setLoglevel(loglevel);
            request.setFilter(this.nodeFilterOptions.getFilter());
            request.setAsUser(this.options.getUser());
            List<String> commandString = this.options.getCommandString();
            boolean rawOptions = this.options.isRawOptions();
            HashMap<String, String> jobopts = new HashMap<String, String>();
            HashMap<String, File> fileinputs = new HashMap<String, File>();
            String key = null;
            if (null != commandString) {
                boolean isfile = false;
                for (String part : commandString) {
                    if (key == null && part.startsWith("-")) {
                        key = part.substring(1);
                        if (!key.endsWith("@")) continue;
                        key = key.substring(0, key.length() - 1);
                        isfile = true;
                        continue;
                    }
                    if (key == null) continue;
                    String filepath = null;
                    if (!rawOptions && part.charAt(0) == '@' && !isfile) {
                        filepath = part.substring(1);
                        isfile = true;
                    }
                    if (isfile) {
                        File file = new File(filepath != null ? filepath : part);
                        fileinputs.put(key, file);
                    }
                    jobopts.put(key, part);
                    key = null;
                    isfile = false;
                }
            }
            if (key != null) {
                throw new InputError(String.format("Incorrect job options, expected: \"-%s value\", but saw only \"-%s\"", key, key));
            }
            if (fileinputs.size() > 0 && this.getRdTool().getClient().getApiVersion() < 19) {
                this.getRdOutput().warning(String.format("APIv19 is required for option file inputs (using %d). The option values will be used verbatim.", this.getRdTool().getClient().getApiVersion()));
            } else if (fileinputs.size() > 0) {
                File file;
                for (String optionName : fileinputs.keySet()) {
                    file = (File)fileinputs.get(optionName);
                    if (!Files.invalidInputFile(file)) continue;
                    throw new InputError("File Option -" + optionName + ": File cannot be read: " + file);
                }
                for (String optionName : fileinputs.keySet()) {
                    file = (File)fileinputs.get(optionName);
                    JobFileUploadResult jobFileUploadResult = Files.uploadFileForJob(this.getRdTool(), file, jobId, optionName);
                    String fileid = jobFileUploadResult.getFileIdForOption(optionName);
                    jobopts.put(optionName, fileid);
                    this.getRdOutput().info(String.format("File Upload OK (%s -> %s)", file, fileid));
                }
            }
            request.setOptions(jobopts);
            if (this.options.isRunAtDate()) {
                try {
                    runat = this.options.getRunAtDate().toDate("yyyy-MM-dd'T'HH:mm:ssXX");
                    request.setRunAtTime(runat);
                }
                catch (ParseException e) {
                    throw new InputError("-@/--at date format is not valid", e);
                }
            } else if (this.options.isRunDelay()) {
                runat = this.parseDelayTime(this.options.getRunDelay());
                request.setRunAtTime(runat);
                this.getRdOutput().info(String.format("Scheduling execution in %s, at: %s", this.options.getRunDelay(), Format.date(runat, "yyyy-MM-dd'T'HH:mm:ssXX")));
            }
            execution = (Execution)this.apiCall(api -> api.runJob(jobId, request));
        } else {
            execution = (Execution)this.apiCall(api -> api.runJob(jobId, Quoting.joinStringQuoted(this.options.getCommandString()), loglevel, this.nodeFilterOptions.getFilter(), this.options.getUser()));
        }
        String string2 = started = runat != null ? "scheduled" : "started";
        if (!this.followOptions.isFollow()) {
            if (!this.outputFormatOption.isOutputFormat() && !this.outputFormatOption.isVerbose()) {
                this.getRdOutput().info(String.format("Execution %s%n", started));
            }
            Executions.outputExecutionList(this.outputFormatOption, this.getRdOutput(), this.getRdTool().getAppConfig(), Stream.builder().add(execution).build());
        } else {
            this.getRdOutput().info(String.format("Execution %s: %s%n", started, execution.toBasicString()));
        }
        if (runat != null && this.followOptions.isFollow()) {
            Date now = new Date();
            long diff = runat.getTime() - now.getTime();
            this.getRdOutput().info(String.format("Waiting until scheduled execution starts...(in %dms)", diff));
            while (now.compareTo(runat) < 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                now = new Date();
            }
            this.getRdOutput().info("Started.");
        }
        return Executions.maybeFollow(this.getRdTool(), this.followOptions, this.outputFormatOption, execution.getId(), this.getRdOutput()) ? 0 : 2;
    }

    public static String getJobIdFromOpts(JobIdentOptions options, CommandOutput out, RdTool rdTool, GetInput<String> project) throws InputError, IOException {
        String job;
        String[] parts;
        if (options.isId()) {
            return options.getId();
        }
        if (!options.isJob()) {
            throw new InputError("-j job or -i id is required");
        }
        String proj = project.get();
        List jobItems = (List)rdTool.apiCallDowngradable(arg_0 -> Run.lambda$getJobIdFromOpts$3(proj, parts = Jobs.splitJobNameParts(job = options.getJob()), arg_0));
        if (jobItems.size() != 1) {
            out.error(String.format("Could not find a unique job with name: %s%n", job));
            if (jobItems.size() > 0) {
                out.error(String.format("Found %d matching jobs:%n", jobItems.size()));
                for (JobItem jobItem : jobItems) {
                    out.error(String.format("* %s%n", jobItem.toBasicString()));
                }
            } else {
                out.error("Found 0 matching jobs.");
            }
            return null;
        }
        JobItem jobItem = (JobItem)jobItems.get(0);
        out.info(String.format("Found matching job: %s%n", jobItem.toBasicString()));
        return jobItem.getId();
    }

    private Date parseDelayTime(String delayString) {
        long delayms = System.currentTimeMillis();
        Pattern p = Pattern.compile("(?<digits>\\d+)(?<unit>[smhdwMY])\\s*");
        Matcher matcher = p.matcher(delayString);
        int months = 0;
        int years = 0;
        while (matcher.find()) {
            long unitms;
            String digit = matcher.group("digits");
            String unit = matcher.group("unit");
            int count = Integer.parseInt(digit);
            switch (unit) {
                case "s": {
                    unitms = 1000L;
                    break;
                }
                case "m": {
                    unitms = 60000L;
                    break;
                }
                case "h": {
                    unitms = 3600000L;
                    break;
                }
                case "d": {
                    unitms = 86400000L;
                    break;
                }
                case "w": {
                    unitms = 604800000L;
                    break;
                }
                default: {
                    unitms = 0L;
                }
            }
            if ("M".equals(unit)) {
                months += count;
            } else if ("Y".equals(unit)) {
                years += count;
            }
            delayms += (long)count * unitms;
        }
        Date date = new Date(delayms);
        if (months > 0 || years > 0) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
            gregorianCalendar.setTime(date);
            if (months > 0) {
                gregorianCalendar.add(2, months);
            }
            if (years > 0) {
                gregorianCalendar.add(1, years);
            }
            date = gregorianCalendar.getTime();
        }
        return date;
    }

    private static /* synthetic */ Call lambda$getJobIdFromOpts$3(String proj, String[] parts, RundeckApi api) {
        return api.listJobs(proj, null, null, parts[1], parts[0]);
    }
}

