/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.rundeck.client.api.model.KeyStorageItem;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.ServiceClient;
import org.rundeck.client.util.Util;
import picocli.CommandLine;

@CommandLine.Command(description={"Manage Keys via the Key Storage Facility."}, name="keys")
public class Keys
extends BaseCommand {
    public static final String P_PATH_IS_REQUIRED = "-p/--path is required";
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    void validateRequired(Opts opts) {
        String path1 = opts.getPath().keysPath();
        if (path1.length() < 1) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), P_PATH_IS_REQUIRED);
        }
    }

    @CommandLine.Command(description={"List the keys and directories at a given path, or at the root by default."}, aliases={"ls"})
    public boolean list(@CommandLine.Mixin OptionalPath opts) throws IOException, InputError {
        KeyStorageItem keyStorageItem = (KeyStorageItem)this.apiCall(api -> api.listKeyStorage(opts.getPath().keysPath()));
        this.getRdOutput().output(keyStorageItem.toBasicString());
        if (keyStorageItem.getType() == KeyStorageItem.KeyItemType.directory) {
            this.getRdOutput().output(keyStorageItem.getResources().stream().sorted().map(KeyStorageItem::toBasicString).collect(Collectors.toList()));
            return true;
        }
        this.getRdOutput().error(String.format("Path is not a directory: %s", opts.getPath()));
        return false;
    }

    @CommandLine.Command(description={"Get metadata about the given path"})
    public void info(@CommandLine.Mixin Opts opts) throws IOException, InputError {
        KeyStorageItem keyStorageItem = (KeyStorageItem)this.apiCall(api -> api.listKeyStorage(this.keysPath(opts.getPath().keysPath())));
        this.getRdOutput().output(String.format("Path: %s", keyStorageItem.getPath()));
        this.getRdOutput().output(String.format("Type: %s", new Object[]{keyStorageItem.getType()}));
        if (keyStorageItem.getType() == KeyStorageItem.KeyItemType.directory) {
            this.getRdOutput().output(String.format("Directory: %d entries", keyStorageItem.getResources().size()));
        } else {
            this.getRdOutput().output(String.format("Name: %s", keyStorageItem.getName()));
            this.getRdOutput().output("Metadata:");
            this.getRdOutput().output(keyStorageItem.getMetaString("  "));
        }
    }

    private String keysPath(String path) {
        if (path.startsWith("keys/")) {
            return path.substring(5);
        }
        return path;
    }

    @CommandLine.Command(description={"Get the contents of a public key"})
    public boolean get(@CommandLine.Mixin GetOpts options) throws IOException, InputError {
        block28: {
            this.validateRequired(options);
            KeyStorageItem keyStorageItem = (KeyStorageItem)this.apiCall(api -> api.listKeyStorage(options.getPath().keysPath()));
            if (keyStorageItem.getType() != KeyStorageItem.KeyItemType.file) {
                this.getRdOutput().error(String.format("Requested path (%s) is not a file", options.getPath()));
                return false;
            }
            if (keyStorageItem.getFileType() != KeyStorageItem.KeyFileType.publicKey) {
                this.getRdOutput().error(String.format("Requested path (%s) is not a public key. Type: %s", new Object[]{options.getPath(), keyStorageItem.getFileType()}));
                return false;
            }
            try (ResponseBody body = (ResponseBody)this.apiCall(api -> api.getPublicKey(options.getPath().keysPath()));){
                if (!ServiceClient.hasAnyMediaType(body.contentType(), Client.MEDIA_TYPE_GPG_KEYS)) {
                    throw new IllegalStateException("Unexpected response format: " + body.contentType());
                }
                InputStream inputStream2 = body.byteStream();
                File outFile = options.getFile();
                if (outFile != null) {
                    try (FileOutputStream out = new FileOutputStream(outFile);){
                        long total = Util.copyStream(inputStream2, out);
                        this.getRdOutput().info(String.format("Wrote %d bytes of %s to file %s%n", total, body.contentType(), outFile));
                        break block28;
                    }
                }
                Util.copyStream(inputStream2, System.out);
            }
        }
        return true;
    }

    @CommandLine.Command(aliases={"rm"}, description={"Delete the key at the given opts.getPath()."})
    public void delete(@CommandLine.Mixin Opts opts) throws IOException, InputError {
        this.validateRequired(opts);
        this.apiCall(api -> api.deleteKeyStorage(opts.getPath().keysPath()));
        this.getRdOutput().info(String.format("Deleted: %s", opts.getPath()));
    }

    @CommandLine.Command(description={"Create a new key entry."})
    public void create(@CommandLine.Mixin Upload options) throws IOException, InputError {
        this.validateRequired(options);
        RequestBody requestBody = Keys.prepareKeyUpload(options);
        KeyStorageItem keyStorageItem = (KeyStorageItem)this.apiCall(api -> api.createKeyStorage(options.getPath().keysPath(), requestBody));
        this.getRdOutput().info(String.format("Created: %s", keyStorageItem.toBasicString()));
    }

    static RequestBody prepareKeyUpload(Upload options) throws IOException, InputError {
        RequestBody requestBody;
        MediaType contentType = Keys.getUploadContentType(options.getType());
        if (null == contentType) {
            throw new InputError(String.format("Type is not supported: %s", new Object[]{options.getType()}));
        }
        if (options.getType() != KeyStorageItem.KeyFileType.password && !options.isFile()) {
            throw new InputError(String.format("File (-f/--file) is required for type: %s", new Object[]{options.getType()}));
        }
        if (options.getType() == KeyStorageItem.KeyFileType.password && !options.isFile() && !options.isPrompt()) {
            throw new InputError(String.format("File (-f/--file) or -P/--prompt is required for type: %s", new Object[]{options.getType()}));
        }
        if (options.isFile()) {
            File input = options.getFile();
            BasicFileAttributes basicFileAttributes = Files.readAttributes(input.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (!input.canRead() || !basicFileAttributes.isRegularFile()) {
                throw new InputError(String.format("File is not readable or does not exist: %s", input));
            }
            if (options.getType() == KeyStorageItem.KeyFileType.password) {
                char c;
                int limit;
                CharBuffer buffer = CharBuffer.allocate((int)basicFileAttributes.size());
                buffer.mark();
                try (InputStreamReader read = new InputStreamReader(Files.newInputStream(input.toPath(), new OpenOption[0]), options.isCharset() ? Charset.forName(options.getCharset()) : Charset.defaultCharset());){
                    int len = read.read(buffer);
                    while (len > 0) {
                        len = read.read(buffer);
                    }
                }
                buffer.reset();
                for (limit = 0; limit < buffer.length() && (c = buffer.charAt(limit)) != '\r' && c != '\n'; ++limit) {
                }
                buffer.limit(limit);
                if (buffer.length() == 0) {
                    throw new IllegalStateException("No content found in file: " + input);
                }
                ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(buffer);
                requestBody = RequestBody.create(Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit()), contentType);
            } else {
                requestBody = RequestBody.create(input, contentType);
            }
        } else {
            char[] chars = System.console().readPassword("Enter password: ", new Object[0]);
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars));
            requestBody = RequestBody.create(Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit()), contentType);
        }
        return requestBody;
    }

    @CommandLine.Command(description={"Update an existing key entry"})
    public void update(@CommandLine.Mixin Upload options) throws IOException, InputError {
        this.validateRequired(options);
        RequestBody requestBody = Keys.prepareKeyUpload(options);
        KeyStorageItem keyStorageItem = (KeyStorageItem)this.apiCall(api -> api.updateKeyStorage(options.getPath().keysPath(), requestBody));
        this.getRdOutput().info(String.format("Updated: %s", keyStorageItem.toBasicString()));
    }

    private static MediaType getUploadContentType(KeyStorageItem.KeyFileType type) {
        switch (type) {
            case privateKey: {
                return Client.MEDIA_TYPE_OCTET_STREAM;
            }
            case publicKey: {
                return Client.MEDIA_TYPE_GPG_KEYS;
            }
            case password: {
                return Client.MEDIA_TYPE_X_RUNDECK_PASSWORD;
            }
        }
        return null;
    }

    static class Upload
    extends Opts {
        @CommandLine.Option(names={"-t", "--type"}, description={"Type of key to store: ${COMPLETION-CANDIDATES}"}, required=true)
        private KeyStorageItem.KeyFileType type;
        @CommandLine.Option(names={"-f", "--file"}, description={"File path for reading the upload contents."})
        private File file;
        @CommandLine.Option(names={"--charset"}, description={"Encoding charset of the File, e.g. 'UTF-8'. If not specified, the JVM default will be used."})
        private String charset;
        @CommandLine.Option(names={"-P", "--prompt"}, description={"(password type only) prompt on console for the password value, if -f is not specified."})
        private boolean prompt;

        Upload() {
        }

        boolean isFile() {
            return this.file != null;
        }

        boolean isCharset() {
            return this.charset != null;
        }

        public KeyStorageItem.KeyFileType getType() {
            return this.type;
        }

        public File getFile() {
            return this.file;
        }

        public String getCharset() {
            return this.charset;
        }

        public boolean isPrompt() {
            return this.prompt;
        }

        public void setType(KeyStorageItem.KeyFileType type) {
            this.type = type;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setPrompt(boolean prompt) {
            this.prompt = prompt;
        }
    }

    static class GetOpts
    extends Opts {
        @CommandLine.Option(names={"-f", "--file"}, description={"File path for storing the public key. If unset, the output will be written to stdout."})
        private File file;

        GetOpts() {
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    static class OptionalPath
    implements HasPath {
        @CommandLine.Option(names={"-p", "--path"}, description={"Storage path in the form 'path/to/file', or 'keys/path/to/file'."}, converter={PathConverter.class}, defaultValue="")
        private Path path;

        OptionalPath() {
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }
    }

    static class Opts
    implements HasPath {
        @CommandLine.Option(names={"-p", "--path"}, description={"Storage path in the form 'path/to/file', or 'keys/path/to/file'."}, converter={PathConverter.class}, required=true)
        private Path path;

        Opts() {
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }
    }

    static interface HasPath {
        public Path getPath();
    }

    public static class Path {
        final String pathString;

        public Path(String pathString) {
            this.pathString = pathString;
        }

        public String keysPath() {
            if (this.pathString.startsWith("keys/")) {
                return this.pathString.substring(5);
            }
            return this.pathString;
        }

        public String toString() {
            return this.pathString;
        }
    }

    static class PathConverter
    implements CommandLine.ITypeConverter<Path> {
        PathConverter() {
        }

        @Override
        public Path convert(String value) throws Exception {
            return new Path(value);
        }
    }
}

