/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ResponseBody;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.AbortResult;
import org.rundeck.client.api.model.BulkExecutionDelete;
import org.rundeck.client.api.model.BulkExecutionDeleteResponse;
import org.rundeck.client.api.model.ExecLog;
import org.rundeck.client.api.model.ExecOutput;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.ExecutionList;
import org.rundeck.client.api.model.ExecutionStateResponse;
import org.rundeck.client.api.model.Paging;
import org.rundeck.client.api.model.executions.MetricsResponse;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.tool.options.ExecutionIdOption;
import org.rundeck.client.tool.options.ExecutionOutputFormatOption;
import org.rundeck.client.tool.options.ExecutionsFollowOptions;
import org.rundeck.client.tool.options.FollowOptions;
import org.rundeck.client.tool.options.OutputFormat;
import org.rundeck.client.tool.options.PagingResultOptions;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.tool.options.QueryOptions;
import org.rundeck.client.util.Format;
import org.rundeck.client.util.RdClientConfig;
import org.rundeck.client.util.ServiceClient;
import org.rundeck.client.util.Util;
import picocli.CommandLine;

@CommandLine.Command(name="executions", description={"List running executions, attach and follow their output, or kill them."})
public class Executions
extends BaseCommand {
    private static final ObjectMapper JSON = new ObjectMapper();

    @CommandLine.Command(description={"Attempt to kill an execution by ID."})
    public boolean kill(@CommandLine.Mixin ExecutionIdOption options) throws IOException, InputError {
        if (null == options.getId()) {
            throw new InputError("-e is required");
        }
        AbortResult abortResult = (AbortResult)this.apiCall(api -> api.abortExecution(options.getId()));
        AbortResult.Reason abort = abortResult.abort;
        Execution execution = abortResult.execution;
        boolean failed = null != abort && "failed".equals(abort.status);
        this.getRdOutput().output(String.format("Kill [%s] result: %s", options.getId(), abort != null ? abort.status : null));
        if (null != execution) {
            this.getRdOutput().output(String.format("Execution [%s] status: %s", options.getId(), execution.getStatus()));
        }
        if (failed) {
            this.getRdOutput().warning(String.format("Kill request failed: %s", abort.reason));
        }
        return !failed;
    }

    @CommandLine.Command(description={"Delete an execution by ID."})
    public void delete(@CommandLine.Mixin ExecutionIdOption options) throws IOException, InputError {
        this.apiCall(api -> api.deleteExecution(options.getId()));
        this.getRdOutput().info(String.format("Delete [%s] succeeded.", options.getId()));
    }

    @CommandLine.Command(description={"Follow the output of an execution. Restart from the beginning, or begin tailing as it runs."})
    public boolean follow(@CommandLine.Mixin ExecutionsFollowOptions options) throws IOException, InputError {
        int max = 500;
        ExecOutput output = Executions.startFollowOutput(this.getRdTool(), max, options.isRestart(), options.getId(), options.getTail(), true);
        return Executions.followOutput(this.getRdTool().getClient(), output, options.isProgress(), options.isQuiet(), options.getId(), max, this.getRdOutput(), options.isOutputFormat() ? Format.formatter(options.getOutputFormat(), ExecLog::toMap, "%", "") : null, Executions.waitUnlessInterrupt(2000));
    }

    public static ExecOutput startFollowOutput(RdTool rdTool, long max, boolean restart, String id, long tail, boolean compacted) throws IOException, InputError {
        ExecOutput out = restart ? (ExecOutput)rdTool.apiCallDowngradable(api -> api.getOutput(id, 0L, 0L, max, compacted)) : (ExecOutput)rdTool.apiCallDowngradable(api -> api.getOutput(id, tail));
        return out;
    }

    public static boolean followOutput(ServiceClient<RundeckApi> serviceClient, ExecOutput output, boolean progress, boolean quiet, String id, long max, CommandOutput out, Function<ExecLog, String> formatter, BooleanSupplier waitFunc) throws IOException {
        return Executions.followOutput(serviceClient, output, id, max, true, entries -> {
            if (progress && !entries.isEmpty()) {
                out.output(".");
            } else if (!quiet) {
                for (ExecLog entry : entries) {
                    String outval;
                    String string = outval = formatter != null ? (String)formatter.apply(entry) : entry.log;
                    if ("WARN".equals(entry.level)) {
                        out.warning(outval);
                        continue;
                    }
                    if ("ERROR".equals(entry.level)) {
                        out.error(outval);
                        continue;
                    }
                    out.output(outval);
                }
            }
        }, waitFunc);
    }

    public static boolean followOutput(ServiceClient<RundeckApi> serviceClient, ExecOutput output, String id, long max, boolean compacted, Consumer<List<ExecLog>> receiver, BooleanSupplier waitFunc) throws IOException {
        boolean done = false;
        String status = null;
        ExecOutput execOutput = output;
        while (!done) {
            receiver.accept(execOutput.decompactEntries());
            status = execOutput.execState;
            done = execOutput.execCompleted && execOutput.completed;
            if (done) continue;
            if (!waitFunc.getAsBoolean()) break;
            ExecOutput passOutput = execOutput;
            execOutput = (ExecOutput)serviceClient.apiCall((T api) -> api.getOutput(id, passOutput.offset, passOutput.lastModified, max, compacted));
        }
        return "succeeded".equals(status);
    }

    @CommandLine.Command(description={"Get info about a single execution by ID."})
    public void info(@CommandLine.Mixin ExecutionIdOption options, @CommandLine.Mixin ExecutionOutputFormatOption outputFormatOption) throws IOException, InputError {
        Execution execution = (Execution)this.apiCall(api -> api.getExecution(options.getId()));
        Executions.outputExecutionList(outputFormatOption, this.getRdOutput(), this.getRdTool().getAppConfig(), Stream.of(execution));
    }

    @CommandLine.Command(description={"Get detail about the node and step state of an execution by ID."})
    public void state(@CommandLine.Mixin ExecutionIdOption options) throws IOException, InputError {
        ExecutionStateResponse response = (ExecutionStateResponse)this.apiCall(api -> api.getExecutionState(options.getId()));
        this.getRdOutput().info(response.execInfoString(this.getRdTool().getAppConfig()));
        this.getRdOutput().output(response.nodeStatusString());
    }

    @CommandLine.Command(description={"List all running executions for a project."})
    public void list(@CommandLine.Mixin ExecutionOutputFormatOption outputFormatOption, @CommandLine.Mixin PagingResultOptions paging, @CommandLine.Mixin ProjectNameOptions projectNameOptions) throws IOException, InputError {
        int offset = paging.isOffset() ? paging.getOffset() : 0;
        int max = paging.isMax() ? paging.getMax() : 20;
        String project = this.getRdTool().projectOrEnv(projectNameOptions);
        ExecutionList executionList = (ExecutionList)this.apiCall(api -> api.runningExecutions(project, offset, max));
        if (!outputFormatOption.isOutputFormat()) {
            this.getRdOutput().info(String.format("Running executions: %d items%n", executionList.getPaging().getCount()));
        }
        Executions.outputExecutionList(outputFormatOption, this.getRdOutput(), this.getRdTool().getAppConfig(), executionList.getExecutions().stream());
    }

    @CommandLine.Command(description={"Query previous executions for a project."})
    public ExecutionList query(@CommandLine.Mixin QueryCmd options, @CommandLine.Mixin PagingResultOptions paging, @CommandLine.Mixin ExecutionOutputFormatOption outputFormatOption) throws IOException, InputError {
        return this.query(false, options, options, paging, outputFormatOption);
    }

    public ExecutionList query(boolean disableInteractive, HasJobIdList jobIdList, BaseQuery options, PagingResultOptions paging, ExecutionOutputFormatOption outputFormatOption) throws IOException, InputError {
        boolean interactive;
        CommandOutput out = this.getRdOutput();
        int offset = paging.isOffset() ? paging.getOffset() : 0;
        int max = paging.isMax() ? paging.getMax() : 20;
        Map<String, String> query = this.createQueryParams(options, max, offset);
        boolean bl = interactive = !disableInteractive && !options.isNonInteractive();
        if (this.getRdTool().getAppConfig().getString("RD_FORMAT", null) != null) {
            interactive = false;
        }
        boolean autopage = interactive || options.isAutoLoadPages();
        String project = this.getRdTool().projectOrEnv(options);
        ExecutionList result = null;
        boolean verboseInfo = !outputFormatOption.isOutputFormat() && !autopage || interactive;
        ArrayList allResults = new ArrayList();
        while (offset >= 0) {
            ExecutionList executionList;
            query.put("offset", Integer.toString(offset));
            result = executionList = (ExecutionList)this.apiCall(api -> api.listExecutions(project, query, jobIdList.getJobIdList(), options.getExcludeJobIdList(), options.getJobList(), options.getExcludeJobList()));
            Paging page = executionList.getPaging();
            if (verboseInfo) {
                out.info(page);
            }
            allResults.add(executionList.getExecutions().stream());
            if (interactive) {
                Executions.outputExecutionList(outputFormatOption, out, this.getRdTool().getAppConfig(), executionList.getExecutions().stream());
            }
            if (verboseInfo && !autopage) {
                out.info(page.moreResults("-o", page.hasMoreResults() && !disableInteractive ? ", or --autopage for all" : null));
            }
            if (!autopage || !page.hasMoreResults()) break;
            offset = page.nextPageOffset();
            if (!interactive) continue;
            int maxpage = page.maxPagenum();
            int nextpage = page.pagenum() + 1;
            int i = Util.readPrompt(String.format("Enter page to load 1-%d [default: %d]: ", maxpage, nextpage), input -> {
                if ("".equals(input) || "n".equalsIgnoreCase((String)input) || "next".equalsIgnoreCase((String)input)) {
                    return Optional.of(0);
                }
                if ("exit".equalsIgnoreCase((String)input) || "quit".equalsIgnoreCase((String)input) || "q".equalsIgnoreCase((String)input)) {
                    return Optional.of(-1);
                }
                try {
                    int value = Integer.parseInt(input);
                    if (value > maxpage) {
                        out.warning(String.format("Maximum page number is: %d", maxpage));
                        return Optional.empty();
                    }
                    if (value < 1) {
                        out.warning("Minimum page number is: 1");
                        return Optional.empty();
                    }
                    return Optional.of(value);
                }
                catch (NumberFormatException e) {
                    out.error(String.format("Not a valid number: %s", input));
                    return Optional.empty();
                }
            }, -1);
            if (i > 0) {
                offset = page.getMax() * (i - 1);
                continue;
            }
            if (i == 0) {
                offset = page.nextPageOffset();
                continue;
            }
            offset = -1;
        }
        if (!interactive) {
            Executions.outputExecutionList(outputFormatOption, out, this.getRdTool().getAppConfig(), allResults.stream().flatMap(a -> a));
        }
        return result;
    }

    private Map<String, String> createQueryParams(QueryOptions options, Integer max, Integer offset) {
        HashMap<String, String> query = new HashMap<String, String>();
        if (max != null) {
            query.put("max", Integer.toString(max));
        }
        if (offset != null) {
            query.put("offset", Integer.toString(offset));
        }
        if (options.isRecentFilter()) {
            query.put("recentFilter", options.getRecentFilter());
        }
        if (options.isOlderFilter()) {
            query.put("olderFilter", options.getOlderFilter());
        }
        if (options.isStatusFilter()) {
            query.put("statusFilter", options.getStatusFilter());
        }
        if (options.isUserFilter()) {
            query.put("userFilter", options.getUserFilter());
        }
        if (options.isAdhoc()) {
            query.put("adhoc", "true");
        } else if (options.isJob()) {
            query.put("adhoc", "false");
        }
        if (options.isGroupPath()) {
            query.put("groupPath", options.getGroupPath());
        }
        if (options.isExcludeGroupPath()) {
            query.put("excludeGroupPath", options.getExcludeGroupPath());
        }
        if (options.isExcludeGroupPathExact()) {
            query.put("excludeGroupPathExact", options.getExcludeGroupPathExact());
        }
        if (options.isJobFilter()) {
            query.put("jobFilter", options.getJobFilter());
        }
        if (options.isExcludeJobFilter()) {
            query.put("excludeJobFilter", options.getExcludeJobFilter());
        }
        if (options.isJobExactFilter()) {
            query.put("jobExactFilter", options.getJobExactFilter());
        }
        if (options.isExcludeJobExactFilter()) {
            query.put("excludeJobExactFilter", options.getExcludeJobExactFilter());
        }
        return query;
    }

    public static void outputExecutionList(OutputFormat options, CommandOutput out, RdClientConfig config, Stream<Execution> executions) {
        if (options.isVerbose()) {
            out.output(executions.map(e -> e.getInfoMap(config)).collect(Collectors.toList()));
            return;
        }
        Function<Execution, Object> outformat = options.isOutputFormat() ? Format.formatter(options.getOutputFormat(), e -> e.getInfoMap(config), "%", "") : e -> e.toExtendedString(config);
        executions.forEach(e -> out.output(outformat.apply((Execution)e)));
    }

    @CommandLine.Command(description={"Delete all executions for a job."})
    public boolean deleteall(@CommandLine.Mixin DeleteAllExecCmd options) throws IOException, InputError {
        String s;
        if (!options.isConfirm() && !"y".equals(s = System.console().readLine("Really delete all executions for job %s? (y/N) ", options.getId()))) {
            this.getRdOutput().warning("Not deleting executions.");
            return false;
        }
        BulkExecutionDeleteResponse result = (BulkExecutionDeleteResponse)this.apiCall(api -> api.deleteAllJobExecutions(options.getId()));
        if (!result.isAllsuccessful()) {
            this.getRdOutput().error(String.format("Failed to delete %d executions:", result.getFailedCount()));
            this.getRdOutput().error(result.getFailures().stream().map(BulkExecutionDeleteResponse.DeleteFailure::toString).collect(Collectors.toList()));
        } else {
            this.getRdOutput().info(String.format("Deleted %d executions.", result.getSuccessCount()));
        }
        return result.isAllsuccessful();
    }

    @CommandLine.Command(description={"Find and delete executions in a project. Use the query options to find and delete executions, or specify executions with the `idlist` option."})
    public boolean deletebulk(@CommandLine.Mixin BulkDeleteCmd options, @CommandLine.Mixin PagingResultOptions paging, @CommandLine.Mixin ExecutionOutputFormatOption outputFormatOption) throws IOException, InputError {
        String s;
        List<String> execIds;
        if (options.isIdlist()) {
            execIds = Arrays.asList(options.getIdlist().split("\\s*,\\s*"));
        } else {
            ExecutionList executionList = this.query(true, options, options, paging, outputFormatOption);
            execIds = executionList.getExecutions().stream().map(Execution::getId).collect(Collectors.toList());
            if (execIds.size() < 1) {
                if (!options.isRequire()) {
                    this.getRdOutput().info("No executions found to delete");
                } else {
                    this.getRdOutput().warning("No executions found to delete");
                }
                return !options.isRequire();
            }
        }
        if (!options.isConfirm() && !"y".equals(s = System.console().readLine("Really delete %d executions? (y/N) ", execIds.size()))) {
            this.getRdOutput().warning("Not deleting executions.");
            return false;
        }
        List<String> finalExecIds = execIds;
        BulkExecutionDeleteResponse result = (BulkExecutionDeleteResponse)this.apiCall(api -> api.deleteExecutions(new BulkExecutionDelete(finalExecIds)));
        if (!result.isAllsuccessful()) {
            this.getRdOutput().error(String.format("Failed to delete %d executions:", result.getFailedCount()));
            this.getRdOutput().error(result.getFailures().stream().map(BulkExecutionDeleteResponse.DeleteFailure::toString).collect(Collectors.toList()));
        } else {
            this.getRdOutput().info(String.format("Deleted %d executions.", result.getSuccessCount()));
        }
        return result.isAllsuccessful();
    }

    public static boolean maybeFollow(RdTool rdTool, FollowOptions options, OutputFormat formatOptions, String id, CommandOutput output) throws IOException, InputError {
        if (!options.isFollow()) {
            return true;
        }
        ExecOutput execOutputCall = Executions.startFollowOutput(rdTool, 500L, true, id, 0L, true);
        return Executions.followOutput(rdTool.getClient(), execOutputCall, options.isProgress(), options.isQuiet(), id, 500L, output, formatOptions.isOutputFormat() ? Format.formatter(formatOptions.getOutputFormat(), ExecLog::toMap, "%", "") : null, Executions.waitUnlessInterrupt(2000));
    }

    private static BooleanSupplier waitUnlessInterrupt(int millis) {
        return () -> {
            try {
                Thread.sleep(millis);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        };
    }

    @CommandLine.Command(description={"Obtain metrics over the result set of an execution query."})
    public void metrics(@CommandLine.Mixin MetricsCmd options) throws IOException, InputError {
        MetricsResponse result;
        this.getRdTool().requireApiVersion("metrics", 29);
        if (!"xml".equalsIgnoreCase(this.getRdTool().getAppConfig().getString("RD_FORMAT", "xml")) && options.isRawXML()) {
            throw new InputError("You cannot use RD_FORMAT env var with --xml");
        }
        Map<String, String> query = this.createQueryParams(options, null, null);
        if (options.isProject()) {
            if ("XML".equalsIgnoreCase(this.getRdTool().getAppConfig().getString("RD_FORMAT", null)) || options.isRawXML()) {
                try (ResponseBody response = (ResponseBody)this.apiCall(api -> api.executionMetricsXML(options.getProject(), query, options.getJobIdList(), options.getExcludeJobIdList(), options.getJobList(), options.getExcludeJobList()));){
                    this.getRdOutput().output(response.string());
                }
                return;
            }
            result = (MetricsResponse)this.apiCall(api -> api.executionMetrics(options.getProject(), query, options.getJobIdList(), options.getExcludeJobIdList(), options.getJobList(), options.getExcludeJobList()));
        } else {
            if ("XML".equalsIgnoreCase(this.getRdTool().getAppConfig().getString("RD_FORMAT", null)) || options.isRawXML()) {
                try (ResponseBody response = (ResponseBody)this.apiCall(api -> api.executionMetricsXML(query, options.getJobIdList(), options.getExcludeJobIdList(), options.getJobList(), options.getExcludeJobList()));){
                    this.getRdOutput().output(response.string());
                }
                return;
            }
            result = (MetricsResponse)this.apiCall(api -> api.executionMetrics(query, options.getJobIdList(), options.getExcludeJobIdList(), options.getJobList(), options.getExcludeJobList()));
        }
        if (!options.isOutputFormat()) {
            if (result.getTotal() == null || result.getTotal() < 1L) {
                this.getRdOutput().info("No results.");
                return;
            }
            this.getRdOutput().info(String.format("Showing stats for %d matching executions.", result.getTotal()));
            this.getRdOutput().output(result);
            return;
        }
        this.getRdOutput().output(Format.format(options.getOutputFormat(), result, "%", ""));
    }

    static class MetricsCmd
    extends QueryOptions
    implements OutputFormat {
        @CommandLine.Option(names={"--xml"}, description={"Get the result in raw xml. Note: cannot be combined with RD_FORMAT env variable."})
        private boolean rawXML;
        @CommandLine.Option(names={"--jobids", "-i"}, arity="1..*", description={"Job ID list to include"})
        private List<String> jobIdList;
        @CommandLine.Option(names={"-%", "--outformat"}, description={"Output format specifier for execution metrics data. You can use \"%key\" where key is one of: total,failed-with-retry,failed,succeeded,duration-avg,duration-min,duration-max. E.g. \"%total %failed %succeeded\""})
        private String outputFormat;
        @CommandLine.Option(names={"--verbose", "-v"}, description={"Show verbose output"})
        private boolean verbose;

        MetricsCmd() {
        }

        public boolean isJobIdList() {
            return this.jobIdList != null && this.jobIdList.size() > 0;
        }

        @Override
        public boolean isOutputFormat() {
            return this.outputFormat != null;
        }

        public boolean isRawXML() {
            return this.rawXML;
        }

        public List<String> getJobIdList() {
            return this.jobIdList;
        }

        @Override
        public String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public boolean isVerbose() {
            return this.verbose;
        }

        public void setRawXML(boolean rawXML) {
            this.rawXML = rawXML;
        }

        public void setJobIdList(List<String> jobIdList) {
            this.jobIdList = jobIdList;
        }

        public void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }
    }

    static class BulkDeleteCmd
    extends BaseQuery
    implements HasJobIdList {
        @CommandLine.Option(names={"--confirm", "-y"}, description={"Force confirmation of delete request."})
        private boolean confirm;
        @CommandLine.Option(names={"-i", "--idlist"}, description={"Comma separated list of Execution IDs"})
        private String idlist;
        @CommandLine.Option(names={"--jobids"}, arity="1..*", description={"Job ID list to include"})
        private List<String> jobIdList;
        @CommandLine.Option(names={"-R", "--require"}, description={"Treat 0 query results as failure, otherwise succeed if no executions were returned"})
        private boolean require;

        BulkDeleteCmd() {
        }

        public boolean isIdlist() {
            return this.idlist != null;
        }

        public boolean isConfirm() {
            return this.confirm;
        }

        public String getIdlist() {
            return this.idlist;
        }

        @Override
        public List<String> getJobIdList() {
            return this.jobIdList;
        }

        public boolean isRequire() {
            return this.require;
        }

        public void setConfirm(boolean confirm) {
            this.confirm = confirm;
        }

        public void setIdlist(String idlist) {
            this.idlist = idlist;
        }

        public void setJobIdList(List<String> jobIdList) {
            this.jobIdList = jobIdList;
        }

        public void setRequire(boolean require) {
            this.require = require;
        }
    }

    static interface HasJobIdList {
        public List<String> getJobIdList();

        default public boolean isJobIdList() {
            return this.getJobIdList() != null && this.getJobIdList().size() > 0;
        }
    }

    static class DeleteAllExecCmd {
        @CommandLine.Option(names={"--confirm", "-y"}, description={"Force confirmation of delete request."})
        private boolean confirm;
        @CommandLine.Option(names={"-i", "--id"}, description={"Job ID"})
        private String id;

        DeleteAllExecCmd() {
        }

        public boolean isConfirm() {
            return this.confirm;
        }

        public String getId() {
            return this.id;
        }

        public void setConfirm(boolean confirm) {
            this.confirm = confirm;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    static class QueryCmd
    extends BaseQuery
    implements HasJobIdList {
        @CommandLine.Option(names={"--jobids", "-i"}, arity="1..*", description={"Job ID list to include"})
        private List<String> jobIdList;

        QueryCmd() {
        }

        @Override
        public List<String> getJobIdList() {
            return this.jobIdList;
        }

        public void setJobIdList(List<String> jobIdList) {
            this.jobIdList = jobIdList;
        }
    }

    static class BaseQuery
    extends QueryOptions {
        @CommandLine.Option(names={"--noninteractive"}, description={"Don't use interactive prompts to load more pages if there are more paged results (query command only)"})
        private boolean nonInteractive;
        @CommandLine.Option(names={"--autopage"}, description={"Automatically load more results in non-interactive mode if there are more paged results. (query command only)"})
        private boolean autoLoadPages;

        BaseQuery() {
        }

        public boolean isNonInteractive() {
            return this.nonInteractive;
        }

        public boolean isAutoLoadPages() {
            return this.autoLoadPages;
        }

        public void setNonInteractive(boolean nonInteractive) {
            this.nonInteractive = nonInteractive;
        }

        public void setAutoLoadPages(boolean autoLoadPages) {
            this.autoLoadPages = autoLoadPages;
        }
    }
}

