/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.rundeck.client.api.model.AdhocResponse;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.Executions;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.AdhocBaseOptions;
import org.rundeck.client.tool.options.ExecutionOutputFormatOption;
import org.rundeck.client.tool.options.FollowOptions;
import org.rundeck.client.tool.options.NodeFilterBaseOptions;
import org.rundeck.client.util.Quoting;
import org.rundeck.client.util.Util;
import picocli.CommandLine;

@CommandLine.Command(description={"Run adhoc command or script on matching nodes."}, name="adhoc", showEndOfOptionsDelimiterInUsageHelp=true)
public class Adhoc
extends BaseCommand
implements Callable<Boolean> {
    @CommandLine.Mixin
    AdhocBaseOptions options;
    @CommandLine.Mixin
    ExecutionOutputFormatOption outputFormatOption;
    @CommandLine.Mixin
    FollowOptions followOptions;
    @CommandLine.Mixin
    NodeFilterBaseOptions nodeFilterOptions;

    @Override
    public Boolean call() throws IOException, InputError {
        AdhocResponse adhocResponse;
        String project = this.getRdTool().projectOrEnv(this.options);
        if (this.options.getScriptFile() != null || this.options.isStdin()) {
            String filename;
            RequestBody scriptFileBody;
            if (this.options.getScriptFile() != null) {
                File input = this.options.getScriptFile();
                if (!input.canRead() || !input.isFile()) {
                    throw new InputError(String.format("File is not readable or does not exist: %s", input));
                }
                scriptFileBody = RequestBody.create(input, MediaType.parse("application/octet-stream"));
                filename = input.getName();
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                long bytes = Util.copyStream(System.in, byteArrayOutputStream);
                scriptFileBody = RequestBody.create(byteArrayOutputStream.toByteArray(), MediaType.parse("application/octet-stream"));
                filename = "script.sh";
            }
            adhocResponse = (AdhocResponse)this.getRdTool().apiCall(api -> api.runScript(project, MultipartBody.Part.createFormData("scriptFile", filename, scriptFileBody), this.options.getThreadcount(), this.options.isKeepgoing(), Quoting.joinStringQuoted(this.options.getCommandString()), this.options.getScriptInterpreter(), this.options.isArgsQuoted(), this.options.getFileExtension(), this.nodeFilterOptions.getFilter()));
        } else if (this.options.getUrl() != null) {
            adhocResponse = (AdhocResponse)this.getRdTool().apiCall(api -> api.runUrl(project, this.options.getUrl(), this.options.getThreadcount(), this.options.isKeepgoing(), Quoting.joinStringQuoted(this.options.getCommandString()), this.options.getScriptInterpreter(), this.options.isArgsQuoted(), this.options.getFileExtension(), this.nodeFilterOptions.getFilter()));
        } else if (this.options.getCommandString() != null && this.options.getCommandString().size() > 0) {
            adhocResponse = (AdhocResponse)this.getRdTool().apiCall(api -> api.runCommand(project, Quoting.joinStringQuoted(this.options.getCommandString()), this.options.getThreadcount(), this.options.isKeepgoing(), this.nodeFilterOptions.getFilter()));
        } else {
            throw new InputError("-s, -u, or -- command string, was expected");
        }
        Execution execution = (Execution)this.getRdTool().apiCall(api -> api.getExecution(adhocResponse.execution.getId()));
        if (this.followOptions.isFollow()) {
            this.getRdOutput().info("Started execution " + execution.toExtendedString(this.getRdTool().getAppConfig()));
        } else {
            if (this.outputFormatOption.getOutputFormat() == null) {
                this.getRdOutput().info(adhocResponse.message);
            }
            Executions.outputExecutionList(this.outputFormatOption, this.getRdOutput(), this.getRdTool().getAppConfig(), Stream.of(execution));
        }
        return Executions.maybeFollow(this.getRdTool(), this.followOptions, this.outputFormatOption, adhocResponse.execution.getId(), this.getRdOutput());
    }
}

