/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.ext.acl;

import com.dtolabs.rundeck.core.authorization.AclSubject;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.RuleEvaluator;
import com.dtolabs.rundeck.core.authorization.Validation;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.core.auth.AuthResources;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import picocli.CommandLine;

@CommandLine.Command(name="acl", description={"Generate, Test, and Validate ACLPolicy files"})
public class Acl
extends BaseCommand {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    private static final Comparator<Decision> comparator = Comparator.comparing(Decision::getAction);

    private static boolean notEmpty(List<String> groups2) {
        return groups2 != null && !groups2.isEmpty();
    }

    static AclSubject createSubject(Subject subject) {
        Set<Urn> urnPrincipals;
        String username;
        Set<Username> userPrincipals = subject.getPrincipals(Username.class);
        if (userPrincipals.size() > 0) {
            Username usernamep = userPrincipals.iterator().next();
            username = usernamep.getName();
        } else {
            username = null;
        }
        Set<Group> groupPrincipals = subject.getPrincipals(Group.class);
        final HashSet<String> groupNames = new HashSet<String>();
        if (groupPrincipals.size() > 0) {
            for (Group groupPrincipal : groupPrincipals) {
                groupNames.add(groupPrincipal.getName());
            }
        }
        final String urnName = (urnPrincipals = subject.getPrincipals(Urn.class)).size() > 0 ? (String)urnPrincipals.stream().findFirst().map(Urn::getName).orElse(null) : null;
        return new AclSubject(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public Set<String> getGroups() {
                return groupNames;
            }

            @Override
            public String getUrn() {
                return urnName;
            }
        };
    }

    @CommandLine.Command(description={"List ACL Policies"}, mixinStandardHelpOptions=true)
    public void list(@CommandLine.Mixin AclOptions opts) {
        Map<String, String> resourceMap;
        HashMap<String, String> res;
        RuleEvaluator authorization = this.createAuthorization(opts);
        Subject subject = this.createSubject(opts);
        String subjdesc = opts.isGroups() ? "group " + opts.getGroups() : "username " + opts.getUser();
        this.info("# Application Context access for " + subjdesc + "\n");
        if (opts.isProject()) {
            res = new HashMap<String, String>();
            res.put("name", opts.getProject());
            resourceMap = AuthorizationUtil.resource("project", res);
            this.logDecisions("project named \"" + opts.getProject() + "\"", authorization, subject, this.resources(resourceMap), new HashSet<String>(AuthResources.appProjectActions), Acl.createAppEnv(), opts);
        } else {
            this.info("\n(No project (-p) specified, skipping Application context actions for a specific project.)\n");
        }
        if (null != opts.getProjectAcl()) {
            res = new HashMap();
            res.put("name", opts.getProjectAcl());
            resourceMap = AuthorizationUtil.resource("project_acl", res);
            this.logDecisions("project_acl for Project named \"" + opts.getProjectAcl() + "\"", authorization, subject, this.resources(resourceMap), new HashSet<String>(AuthResources.appProjectAclActions), Acl.createAppEnv(), opts);
        } else {
            this.info("\n(No project_acl (-P) specified, skipping Application context actions for a ACLs for a specific project.)\n");
        }
        if (null != opts.getAppStorage()) {
            Map<String, String> resourceMap2 = this.createStorageResource(opts);
            this.logDecisions("storage path \"" + opts.getAppStorage() + "\"", authorization, subject, this.resources(resourceMap2), new HashSet<String>(AuthResources.storageActions), Acl.createAppEnv(), opts);
        } else {
            this.info("\n(No storage path (-s) specified, skipping Application context actions for a specific storage path.)\n");
        }
        for (String kind : AuthResources.appKindActionsByType.keySet()) {
            this.logDecisions(kind, authorization, subject, this.resources(AuthorizationUtil.resourceTypeRule(kind)), new HashSet<String>((Collection)AuthResources.appKindActionsByType.get(kind)), Acl.createAppEnv(), opts);
        }
        if (null == opts.getProject()) {
            this.info("\n(No project (-p) specified, skipping Project context listing.)");
            return;
        }
        Set<Attribute> projectEnv = this.createAuthEnvironment(opts.getProject());
        this.info("\n# Project \"" + opts.getProject() + "\" access for " + subjdesc + "\n");
        this.logDecisions("Adhoc executions", authorization, subject, this.resources(this.createProjectAdhocResource()), new HashSet<String>(AuthResources.projectAdhocActions), projectEnv, opts);
        if (null != opts.getJob()) {
            resourceMap = this.createProjectJobResource(opts);
            this.logDecisions("Job \"" + opts.getJob() + "\"", authorization, subject, this.resources(resourceMap), new HashSet<String>(AuthResources.projectJobActions), projectEnv, opts);
        } else if (null != opts.getJobUUID()) {
            resourceMap = this.createProjectJobUUIDResource(opts);
            this.logDecisions("Job UUID\"" + opts.getJobUUID() + "\"", authorization, subject, this.resources(resourceMap), new HashSet<String>(AuthResources.projectJobActions), projectEnv, opts);
        } else {
            this.info("\n(No job name(-j) or uuid (-i) specified, skipping Project context actions for a specific job.)\n");
        }
        if (null != opts.getNode() || null != opts.getTags()) {
            this.logDecisions("Node " + (null != opts.getNode() ? "\"" + opts.getNode() + "\"" : "") + (null != opts.getTags() ? " tags: " + opts.getTags() : ""), authorization, subject, this.resources(this.createProjectNodeResource(opts)), new HashSet<String>(AuthResources.projectNodeActions), projectEnv, opts);
        } else {
            this.info("\n(No node (-n) or tags (-t) specified, skipping Project context actions for a specific node or node tags.)\n");
        }
        for (String kind : AuthResources.projKindActionsByType.keySet()) {
            this.logDecisions(kind, authorization, subject, this.resources(AuthorizationUtil.resourceTypeRule(kind)), new HashSet<String>((Collection)AuthResources.projKindActionsByType.get(kind)), projectEnv, opts);
        }
    }

    private RuleEvaluator createAuthorization(AclOptions opts) {
        return RuleEvaluator.createRuleEvaluator(this.createPolicies(opts), Acl::createSubject);
    }

    private boolean applyArgValidate(TestOptions opts) {
        if (opts.isValidate()) {
            Validation validation = this.validatePolicies(opts);
            if (opts.isVerbose() && !validation.isValid()) {
                this.reportValidation(validation);
            }
            if (!validation.isValid()) {
                this.log("The validation " + (validation.isValid() ? "passed" : "failed"));
                return false;
            }
        }
        return true;
    }

    @CommandLine.Command(description={"Test ACL Policies"})
    public boolean test(@CommandLine.Mixin TestOptions opts) {
        Set<Decision> testResult;
        if (!this.applyArgValidate(opts)) {
            return false;
        }
        RuleEvaluator authorization = this.createAuthorization(opts);
        AuthRequest authRequest = this.createAuthRequestFromArgs(opts);
        HashSet<Map<String, String>> resource = this.resources(authRequest.resourceMap);
        boolean expectAuthorized = true;
        boolean expectDenied = false;
        if (null != authRequest.actions && authRequest.actions.size() > 0) {
            testResult = authorization.evaluate(resource, authRequest.subject, authRequest.actions, authRequest.environment);
        } else if (null != authRequest.denyActions && authRequest.denyActions.size() > 0) {
            expectAuthorized = false;
            expectDenied = true;
            testResult = authorization.evaluate(resource, authRequest.subject, authRequest.denyActions, authRequest.environment);
        } else {
            throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("ALLOW") + " or " + this.optionDisplayString("DENY") + " is required");
        }
        boolean testPassed = true;
        boolean wasAllowed = true;
        boolean wasDenied = false;
        for (Decision decision : testResult) {
            if (!decision.isAuthorized()) {
                wasAllowed = false;
            }
            if (expectAuthorized && !decision.isAuthorized() || expectDenied && decision.isAuthorized()) {
                this.log("Result: " + (Object)((Object)decision.explain().getCode()));
                this.verbose(opts, decision.toString());
                switch (decision.explain().getCode()) {
                    case REJECTED_NO_SUBJECT_OR_ENV_FOUND: {
                        this.log("Meaning: No rules were found among the aclpolicies that match the subject (user,group) and context (" + (authRequest.isAppContext() ? "application" : "project") + ") and resource (" + authRequest.resourceMap + ")");
                        break;
                    }
                    case REJECTED_DENIED: {
                        this.log("Meaning: A matching rule declared that the requested action be DENIED.");
                        wasDenied = true;
                    }
                }
                testPassed = false;
                continue;
            }
            if (decision.explain().getCode() == Explanation.Code.REJECTED_DENIED) {
                wasDenied = true;
            }
            if (!opts.isVerbose()) continue;
            this.log(decision.toString());
        }
        this.log("The decision was: " + (wasAllowed ? "allowed" : (wasDenied ? "denied" : "not allowed")));
        if (opts.isVerbose() && !testPassed) {
            this.log("Policies to allow the requested actions:");
            this.generateYaml(authRequest, System.out);
        } else if (opts.isVerbose() && !testPassed && expectAuthorized && wasDenied) {
            this.log("No new policy can allow the requested action.\nDENY rules will always prevent access, even if ALLOW rules also match. \nTo allow it, you must remove the DENY rule.");
        }
        this.log("The test " + (testPassed ? "passed" : "failed"));
        return testPassed;
    }

    @CommandLine.Command(description={"Create ACL Policies"})
    public void create(@CommandLine.Mixin AclCreateOptions opts) throws IOException {
        List<Object> reqs = new ArrayList<AuthRequest>();
        if (opts.isFile() || opts.isStdin()) {
            reqs = this.readRequests(opts);
        } else {
            reqs.add(this.createAuthRequestFromArgs(opts));
        }
        for (AuthRequest authRequest : reqs) {
            this.generateYaml(authRequest, System.out);
        }
    }

    @CommandLine.Command(description={"Validate ACL Policies"})
    public boolean validate(@CommandLine.Mixin AclOptions opts) {
        Validation validation = this.validatePolicies(opts);
        this.reportValidation(validation);
        this.log("The validation " + (validation.isValid() ? "passed" : "failed"));
        return validation.isValid();
    }

    private HashSet<Map<String, String>> resources(Map<String, String> resourceMap) {
        HashSet<Map<String, String>> resource = new HashSet<Map<String, String>>();
        Collections.addAll(resource, resourceMap);
        return resource;
    }

    private void logDecisions(String title, RuleEvaluator authorization, Subject subject, HashSet<Map<String, String>> resource, HashSet<String> actions, Set<Attribute> env, AclOptions opts) {
        Set<Decision> evaluate = authorization.evaluate(resource, subject, actions, env);
        for (Decision decision : this.sortByAction(evaluate)) {
            this.log((decision.isAuthorized() ? "+" : (decision.explain().getCode() == Explanation.Code.REJECTED_DENIED ? "!" : "-")) + " " + decision.getAction() + ": " + title + (decision.isAuthorized() ? "" : " [" + (Object)((Object)decision.explain().getCode()) + "]"));
            if (decision.isAuthorized() || decision.explain().getCode() != Explanation.Code.REJECTED_DENIED) continue;
            this.verbose(opts, "  " + decision.explain().toString());
        }
    }

    private void verbose(AclOptions opts, String s) {
        if (opts.isVerbose()) {
            this.info(s);
        }
    }

    private void info(String s) {
        this.getRdTool().getRdApp().getOutput().info(s);
    }

    private void log(String s) {
        this.getRdTool().getRdApp().getOutput().output(s);
    }

    private void warn(String s) {
        this.getRdTool().getRdApp().getOutput().warning(s);
    }

    private Set<Decision> sortByAction(Set<Decision> evaluate) {
        TreeSet<Decision> sorted2 = new TreeSet<Decision>(comparator);
        sorted2.addAll(evaluate);
        return sorted2;
    }

    String optionDisplayString(String value) {
        return "--" + value.toLowerCase();
    }

    private AuthRequest createAuthRequestFromArgs(AclCreateOptions opts) {
        ArrayList<String> invalid;
        HashMap<String, String> res;
        Map<String, String> resourceMap;
        if (null == opts.getContext()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("CONTEXT") + " is required. Choose one of: \n  -c " + (Object)((Object)Context.application) + "\n    Access to projects, users, storage, system info, execution management.\n  -c " + (Object)((Object)Context.project) + "\n    Access to jobs, nodes, events, within a project.");
        }
        if (opts.getContext() == Context.project && !opts.isProject()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "--project is required. Choose the name of a project, or .*: \n  -p myproject\n  -p '.*'");
        }
        boolean appContext = opts.getContext() == Context.application;
        Set<Attribute> environment = appContext ? Acl.createAppEnv() : this.createAuthEnvironment(opts.getProject());
        Subject subject = this.createSubject(opts);
        if (opts.getContext() == Context.application && opts.getResource() != null) {
            if (!AuthResources.appTypes.contains(opts.getResource().toLowerCase())) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "--resource invalid resource type: " + opts.getResource() + "  resource types in application context:     " + String.join((CharSequence)"\n    ", AuthResources.appTypes));
            }
            resourceMap = AuthorizationUtil.resource(opts.getResource().toLowerCase(), null);
        } else if (opts.getContext() == Context.project && opts.getResource() != null) {
            if (!AuthResources.projectTypes.contains(opts.getResource().toLowerCase())) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "--resource invalid resource type: " + opts.getResource() + "  resource types in project context:     " + String.join((CharSequence)"\n    ", AuthResources.projectTypes));
            }
            resourceMap = AuthorizationUtil.resource(opts.getResource().toLowerCase(), null);
        } else if (opts.getContext() == Context.application && opts.getProject() != null) {
            res = new HashMap<String, String>();
            res.put("name", opts.getProject());
            resourceMap = AuthorizationUtil.resource("project", res);
        } else if (opts.getContext() == Context.application && opts.getProjectAcl() != null) {
            res = new HashMap();
            res.put("name", opts.getProjectAcl());
            resourceMap = AuthorizationUtil.resource("project_acl", res);
        } else if (opts.getContext() == Context.application && opts.getAppStorage() != null) {
            resourceMap = this.createStorageResource(opts);
        } else if (opts.getContext() == Context.project && opts.getJob() != null) {
            resourceMap = this.createProjectJobResource(opts);
        } else if (opts.getContext() == Context.project && opts.getJobUUID() != null) {
            resourceMap = this.createProjectJobUUIDResource(opts);
        } else if (opts.getContext() == Context.project && (opts.getNode() != null || opts.getTags() != null)) {
            resourceMap = this.createProjectNodeResource(opts);
        } else if (opts.getContext() == Context.project && opts.isProjectAdhoc()) {
            resourceMap = this.createProjectAdhocResource();
        } else if (opts.getContext() == Context.project && null != opts.getGenericType()) {
            if (!AuthResources.projectKinds.contains(opts.getGenericType().toLowerCase())) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "--generic invalid generic kind: " + opts.getGenericType() + "  generic kinds in this context:     " + String.join((CharSequence)"\n    ", AuthResources.projectKinds));
            }
            resourceMap = AuthorizationUtil.resourceTypeRule(opts.getGenericType().toLowerCase());
        } else if (opts.getContext() == Context.application && null != opts.getGenericType()) {
            if (!AuthResources.appKinds.contains(opts.getGenericType().toLowerCase())) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "--generic invalid generic kind: " + opts.getGenericType() + "  generic kind in this context:     " + String.join((CharSequence)"\n    ", AuthResources.appKinds));
            }
            resourceMap = AuthorizationUtil.resourceTypeRule(opts.getGenericType().toLowerCase());
        } else {
            if (opts.getContext() == Context.project) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Project-context resource option is required.Possible options:\n  Job: " + this.optionDisplayString("JOB") + "\n    View, modify, create*, delete*, run, and kill specific jobs,\n    and toggle whether schedule and/or execution are enabled.\n    * Create and delete also require additional " + this.optionDisplayString("GENERIC") + " level access.\n  Adhoc: " + this.optionDisplayString("ADHOC") + "\n    View, run, and kill adhoc commands.\n  Node: " + this.optionDisplayString("NODE") + "\n      : " + this.optionDisplayString("TAGS") + "\n    View and run on specific nodes by name or tag.\n  Resource: " + this.optionDisplayString("RESOURCE") + "\n    Specify the resource type directly. " + this.optionDisplayString("ATTRS") + " should also be used.\n    resource types in this context: \n    " + String.join((CharSequence)"\n    ", AuthResources.projectTypes) + "\n  Generic: " + this.optionDisplayString("GENERIC") + "\n    Create and delete jobs.\n    View and manage nodes.\n    View events.\n    generic kinds in this context: \n    " + String.join((CharSequence)"\n    ", AuthResources.projectKinds));
            }
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Application-context resource option is required.Possible options:\n  Project: " + this.optionDisplayString("PROJECT") + "\n    Visibility, import, export, config, and delete executions.\n    *Note: Project create requires additional " + this.optionDisplayString("GENERIC") + " level access.\n  Project ACLs: " + this.optionDisplayString("PROJECT_ACL") + "\n    CRUD access for the project ACLs.\n  Storage: " + this.optionDisplayString("STORAGE") + "\n    CRUD access for the key storage system.\n  Resource: " + this.optionDisplayString("RESOURCE") + "\n    Specify the resource type directly. " + this.optionDisplayString("ATTRS") + " should also be used.\n    resource types in this context: \n    " + String.join((CharSequence)"\n    ", AuthResources.appTypes) + "\n  Generic: " + this.optionDisplayString("GENERIC") + "\n    Create projects, read system info, manage system ACLs, manage users, change\n      execution mode, manage plugins.\n    generic kinds in this context: \n    " + String.join((CharSequence)"\n    ", AuthResources.appKinds));
        }
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        boolean attrsHelp = false;
        if (opts.isAttributes()) {
            attrsHelp = this.parseAttrsMap(opts, attrsMap);
        }
        if (!attrsHelp && attrsMap.size() > 0) {
            resourceMap.putAll(attrsMap);
        } else if (attrsHelp && null != opts.getResource() && !opts.getResource().equalsIgnoreCase("adhoc")) {
            List<String> possibleAttrs = (opts.getContext() == Context.application ? AuthResources.appResAttrsByType : AuthResources.projResAttrsByType).get(opts.getResource().toLowerCase());
            throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("ATTRS") + " should be specified when " + this.optionDisplayString("RESOURCE") + " is used. Possible attributes for resource type " + opts.getResource() + " in this context:\n  " + String.join((CharSequence)"\n  ", possibleAttrs));
        }
        ArrayList<String> possibleActions = new ArrayList<String>(Collections.singletonList("*"));
        if (opts.getContext() == Context.application && null != opts.getResource()) {
            possibleActions.addAll((Collection<String>)AuthResources.appResActionsByType.get(opts.getResource()));
        } else if (opts.getContext() == Context.project && null != opts.getResource()) {
            possibleActions.addAll((Collection<String>)AuthResources.projResActionsByType.get(opts.getResource()));
        } else if (opts.getContext() == Context.application && opts.getAppStorage() != null) {
            possibleActions.addAll(AuthResources.storageActions);
        } else if (opts.getContext() == Context.application && opts.getProject() != null) {
            possibleActions.addAll(AuthResources.appProjectActions);
        } else if (opts.getContext() == Context.application && opts.getProjectAcl() != null) {
            possibleActions.addAll(AuthResources.appProjectAclActions);
        } else if (opts.getContext() == Context.application && opts.getGenericType() != null) {
            possibleActions.addAll((Collection<String>)AuthResources.appKindActionsByType.get(opts.getGenericType().toLowerCase()));
        } else if (opts.getContext() == Context.project && opts.getGenericType() != null) {
            possibleActions.addAll((Collection<String>)AuthResources.projKindActionsByType.get(opts.getGenericType().toLowerCase()));
        } else if (opts.getContext() == Context.project && (opts.getJob() != null || opts.getJobUUID() != null)) {
            possibleActions.addAll(AuthResources.projectJobActions);
        } else if (opts.getContext() == Context.project && opts.isProjectAdhoc()) {
            possibleActions.addAll(AuthResources.projectAdhocActions);
        } else if (opts.getContext() == Context.project && (opts.getNode() != null || opts.getTags() != null)) {
            possibleActions.addAll(AuthResources.projectNodeActions);
        }
        if (null == opts.getAllowAction() && null == opts.getDenyAction()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("ALLOW") + " or " + this.optionDisplayString("DENY") + " is required. Possible actions in this context: \n  " + String.join((CharSequence)"\n  ", possibleActions));
        }
        if (null != opts.getAllowAction()) {
            invalid = new ArrayList<String>();
            for (String s : opts.getAllowAction()) {
                if (possibleActions.contains(s)) continue;
                invalid.add(s);
            }
            if (invalid.size() > 0) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("ALLOW") + " specified invalid actions. These actions are not valid for the context:  " + String.join((CharSequence)"\n  ", invalid) + "Possible actions in this context: \n  " + String.join((CharSequence)"\n  ", possibleActions));
            }
        }
        if (null != opts.getDenyAction()) {
            invalid = new ArrayList();
            for (String s : opts.getDenyAction()) {
                if (possibleActions.contains(s)) continue;
                invalid.add(s);
            }
            if (invalid.size() > 0) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("DENY") + " specified invalid actions. These actions are not valid for the context:\n  " + String.join((CharSequence)"\n  ", invalid) + "\n\nPossible actions in this context:\n  " + String.join((CharSequence)"\n  ", possibleActions));
            }
        }
        AuthRequest request = new AuthRequest();
        request.resourceMap = resourceMap;
        request.subject = subject;
        if (null != opts.getAllowAction()) {
            request.actions = new HashSet<String>(opts.getAllowAction());
        }
        request.environment = environment;
        if (null != opts.getDenyAction()) {
            request.denyActions = new HashSet<String>(opts.getDenyAction());
        }
        request.regexMatch = opts.isRegex();
        request.containsMatch = opts.getContext() == Context.project && opts.getTags() != null;
        return request;
    }

    private boolean parseAttrsMap(AclCreateOptions opts, Map<String, String> attrsMap) {
        boolean help = opts.getAttributes().size() < 1;
        for (String attribute : opts.getAttributes()) {
            if (attribute.indexOf("=") > 0) {
                String[] split = attribute.split("=", 2);
                if ("".equals(split[1]) || "?".equals(split[1])) {
                    help = true;
                }
                attrsMap.put(split[0], split[1]);
                continue;
            }
            help = true;
        }
        return help;
    }

    private Map<String, String> createProjectNodeResource(AclOptions opts) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (null != opts.getNode()) {
            res.put("nodename", opts.getNode());
        }
        if (null != opts.getTags()) {
            res.put("tags", String.join((CharSequence)",", opts.getTags()));
        }
        Map<String, String> resourceMap = AuthorizationUtil.resource("node", res);
        return resourceMap;
    }

    private Map<String, String> createProjectJobResource(AclOptions opts) {
        HashMap<String, String> res = new HashMap<String, String>();
        int nx = opts.getJob().lastIndexOf("/");
        if (nx >= 0) {
            res.put("group", opts.getJob().substring(0, nx));
            res.put("name", opts.getJob().substring(nx + 1));
        } else {
            res.put("group", "");
            res.put("name", opts.getJob());
        }
        Map<String, String> resourceMap = AuthorizationUtil.resource("job", res);
        return resourceMap;
    }

    private Map<String, String> createProjectJobUUIDResource(AclOptions opts) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("uuid", opts.getJobUUID());
        Map<String, String> resourceMap = AuthorizationUtil.resource("job", res);
        return resourceMap;
    }

    private Map<String, String> createProjectAdhocResource() {
        return AuthorizationUtil.resource("adhoc", new HashMap<String, String>());
    }

    private Map<String, String> createStorageResource(AclOptions opts) {
        HashMap<String, String> res = new HashMap<String, String>();
        int nx = opts.getAppStorage().lastIndexOf("/");
        res.put("path", opts.getAppStorage());
        if (nx >= 0) {
            res.put("name", opts.getAppStorage().substring(nx + 1));
        } else {
            res.put("name", opts.getAppStorage());
        }
        Map<String, String> resourceMap = AuthorizationUtil.resource("storage", res);
        return resourceMap;
    }

    private Subject createSubject(AclOptions opts) {
        if (opts.getGroups() == null && opts.getUser() == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), this.optionDisplayString("GROUPS") + " or " + this.optionDisplayString("USER") + " are required.   -u user1,user2... \n  -g group1,group2... \n    Groups control access for a set of users, and correspond\n    to authorization roles.");
        }
        Subject subject = this.makeSubject(opts.getUser(), opts.getGroups());
        return subject;
    }

    private Subject makeSubject(String argUser1user, Collection<String> groupsList1) {
        Subject t = new Subject();
        String user = argUser1user != null ? argUser1user : "user";
        t.getPrincipals().add(new Username(user));
        if (null != groupsList1) {
            for (String s : groupsList1) {
                t.getPrincipals().add(new Group(s));
            }
        }
        return t;
    }

    private void reportValidation(Validation validation) {
        for (Map.Entry<String, List<String>> entry : validation.getErrors().entrySet()) {
            String ident = entry.getKey();
            List<String> value = entry.getValue();
            this.warn(ident + ":");
            for (String s : value) {
                this.warn("\t" + s);
            }
        }
    }

    private Validation validatePolicies(AclOptions opts) {
        Validation validation;
        ValidationSet validationSet = new ValidationSet();
        if (null != opts.getFile()) {
            if (!opts.getFile().isFile()) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "File: " + opts.getFile() + ", does not exist or is not a file");
            }
            validation = YamlProvider.validate(YamlProvider.sourceFromFile(opts.getFile(), validationSet), validationSet);
        } else if (null != opts.getDir()) {
            if (!opts.getDir().isDirectory()) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "File: " + opts.getDir() + ", does not exist or is not a directory");
            }
            validation = YamlProvider.validate(YamlProvider.asSources(opts.getDir()), validationSet);
        } else {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "-f or -d are required");
        }
        return validation;
    }

    private List<AuthRequest> readRequests(AclCreateOptions opts) throws IOException {
        ArrayList<AuthRequest> reqs = new ArrayList<AuthRequest>();
        InputStreamReader input = opts.isStdin() ? new InputStreamReader(System.in) : new FileReader(opts.getFile());
        try (BufferedReader reader = new BufferedReader(input);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains("Decision for:")) {
                    int i = line.indexOf("authorized: false");
                    if (i <= 0) {
                        this.verbose(opts, "skip line: " + line);
                        continue;
                    }
                    ParsePart res = this.parsePart("res", line, ", ", false);
                    if (null == res) {
                        this.verbose(opts, "no res< " + line);
                        continue;
                    }
                    Map<String, String> resourceMap = res.resourceMap;
                    res = this.parsePart("subject", line = line.substring(res.len), " ", true);
                    if (null == res) {
                        this.verbose(opts, "no subject<: " + line);
                        continue;
                    }
                    Map<String, String> subjMap = res.resourceMap;
                    Subject subject = this.createSubject(subjMap);
                    if (null == subject) {
                        this.verbose(opts, "parse subject< failed: " + subjMap + ": " + line);
                        continue;
                    }
                    res = this.parseString("action", line = line.substring(res.len));
                    if (null == res) {
                        this.verbose(opts, "no action<: " + line);
                        continue;
                    }
                    String action = res.value;
                    res = this.parseString("env", line = line.substring(res.len));
                    if (null == res) {
                        this.verbose(opts, "no env<: " + line);
                        continue;
                    }
                    String env = res.value;
                    line = line.substring(res.len);
                    if (env.lastIndexOf(":") < 0) {
                        this.verbose(opts, "env parse failed: " + line);
                        continue;
                    }
                    AuthRequest request = new AuthRequest();
                    boolean isAppContext = env.equals("rundeck:auth:env:application:rundeck") || env.equals("http://dtolabs.com/rundeck/auth/env/application:rundeck");
                    request.environment = isAppContext ? Acl.createAppEnv() : this.createAuthEnvironment(env.substring(env.lastIndexOf(":") + 1));
                    request.actions = new HashSet<String>(Collections.singletonList(action));
                    request.resourceMap = resourceMap;
                    request.subject = subject;
                    reqs.add(request);
                    continue;
                }
                this.verbose(opts, "did not see start. skip line: " + line);
            }
        }
        return reqs;
    }

    private Subject createSubject(Map<String, String> subjMap) {
        if (null == subjMap.get("Username")) {
            return null;
        }
        if (null == subjMap.get("Group")) {
            return null;
        }
        String group = subjMap.get("Group");
        return this.makeSubject(subjMap.get("Username"), Collections.singletonList(group));
    }

    private ParsePart parsePart(String name, String line, String delimiter, boolean allowMultiple) {
        int v = line.indexOf(name + "<");
        if (v < 0 || v > line.length() - (name.length() + 1)) {
            return null;
        }
        String r1 = line.substring(v + name.length() + 1);
        int v2 = r1.indexOf(">");
        if (v2 < 0) {
            return null;
        }
        String restext = r1.substring(0, v2);
        Map<String, String> resourceMap = this.parseMap(restext, delimiter, allowMultiple);
        if (null == resourceMap) {
            return null;
        }
        int len = v + name.length() + 1 + v2 + 1;
        ParsePart parsePart = new ParsePart();
        parsePart.len = len;
        parsePart.resourceMap = resourceMap;
        return parsePart;
    }

    private ParsePart parseString(String name, String line) {
        int v = line.indexOf(name + "<");
        if (v < 0 || v > line.length() - (name.length() + 1)) {
            return null;
        }
        String r1 = line.substring(v + name.length() + 1);
        int v2 = r1.indexOf(">");
        if (v2 < 0) {
            return null;
        }
        String restext = r1.substring(0, v2);
        int len = v + (name.length() + 1) + v2 + 1;
        ParsePart parsePart = new ParsePart();
        parsePart.value = restext;
        parsePart.len = len;
        return parsePart;
    }

    private Map<String, String> parseMap(String restext, String delimiter, boolean allowMultiple) {
        String[] split = restext.split(Pattern.quote(delimiter));
        if (split.length < 1) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String aSplit : split) {
            String[] s = aSplit.split(":", 2);
            if (s.length < 2) {
                return null;
            }
            if (result.containsKey(s[0]) && allowMultiple) {
                if (result.get(s[0]) instanceof Collection) {
                    ((Collection)result.get(s[0])).add(s[1]);
                    continue;
                }
                if (!(result.get(s[0]) instanceof String)) continue;
                ArrayList<String> strings = new ArrayList<String>();
                strings.add((String)result.get(s[0]));
                strings.add(s[1]);
                result.put(s[0], strings);
                continue;
            }
            result.put(s[0], s[1]);
        }
        return this.flattenMap(result);
    }

    private Map<String, String> flattenMap(HashMap<String, Object> input) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : input.keySet()) {
            if (input.get(s) instanceof Collection) {
                result.put(s, String.join((CharSequence)",", (Collection)input.get(s)));
                continue;
            }
            result.put(s, input.get(s).toString());
        }
        return result;
    }

    private void generateYaml(AuthRequest authRequest, PrintStream out) {
        Map<String, ?> data = Acl.toDataMap(authRequest);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        out.println("# create or append this to a .aclpolicy file");
        out.println("---");
        yaml.dump(data, new OutputStreamWriter(out));
    }

    public static Map<String, ?> toDataMap(AuthRequest authRequest) {
        HashMap<String, Object> s;
        HashMap<String, Object> stringHashMap = new HashMap<String, Object>();
        if (authRequest.environment.equals(Acl.createAppEnv())) {
            HashMap<String, String> s2 = new HashMap<String, String>();
            s2.put("application", "rundeck");
            stringHashMap.put("context", s2);
        } else {
            String project = authRequest.environment.iterator().next().value;
            s = new HashMap<String, Object>();
            s.put("project", project);
            stringHashMap.put("context", s);
        }
        Set<Username> principals = authRequest.subject.getPrincipals(Username.class);
        if (principals.iterator().next().getName().equals("user")) {
            s = new HashMap();
            ArrayList<String> strings = new ArrayList<String>();
            for (Group group : authRequest.subject.getPrincipals(Group.class)) {
                strings.add(group.getName());
            }
            s.put("group", strings.size() > 1 ? strings : strings.iterator().next());
            stringHashMap.put("by", s);
        } else {
            s = new HashMap();
            s.put("username", principals.iterator().next().getName());
            stringHashMap.put("by", s);
        }
        String type = authRequest.resourceMap.get("type");
        HashMap<String, String> resource = new HashMap<String, String>(authRequest.resourceMap);
        resource.remove("type");
        HashMap s3 = new HashMap();
        ArrayList maps = new ArrayList();
        s3.put(type, maps);
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (resource.size() > 0) {
            r.put(authRequest.regexMatch ? "match" : (authRequest.containsMatch ? "contains" : "equals"), resource);
        }
        if (authRequest.actions != null && authRequest.actions.size() > 0) {
            r.put("allow", authRequest.actions.size() > 1 ? new ArrayList<String>(authRequest.actions) : authRequest.actions.iterator().next());
        }
        if (authRequest.denyActions != null && authRequest.denyActions.size() > 0) {
            r.put("deny", authRequest.denyActions.size() > 1 ? new ArrayList<String>(authRequest.denyActions) : authRequest.denyActions.iterator().next());
        }
        maps.add(r);
        HashMap ruleMap = new HashMap(s3);
        stringHashMap.put("for", ruleMap);
        stringHashMap.put("description", authRequest.description != null ? authRequest.description : "generated");
        return stringHashMap;
    }

    private Policies createPolicies(AclOptions options) {
        Policies policies;
        if (options.isFile()) {
            policies = Policies.loadFile(options.getFile());
        } else if (options.isDir()) {
            if (!options.getDir().isDirectory()) {
                throw new RuntimeException("File: " + options.getDir() + ", does not exist or is not a directory");
            }
            policies = Policies.load(options.getDir());
        } else {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("One of %s or %s are required", this.optionDisplayString("file"), this.optionDisplayString("dir")));
        }
        return policies;
    }

    private static Set<Attribute> createAppEnv() {
        return Collections.singleton(new Attribute(URI.create("rundeck:auth:env:application"), "rundeck"));
    }

    private Set<Attribute> createAuthEnvironment(String argProject) {
        return Collections.singleton(new Attribute(URI.create("rundeck:auth:env:project"), argProject));
    }

    private static class AuthRequest {
        String description;
        Map<String, String> resourceMap;
        boolean regexMatch;
        boolean containsMatch;
        Subject subject;
        Set<String> actions;
        Set<Attribute> environment;
        Set<String> denyActions;

        private AuthRequest() {
        }

        boolean isAppContext() {
            return this.environment.equals(Acl.createAppEnv());
        }
    }

    private static class ParsePart {
        int len;
        Map<String, String> resourceMap;
        String value;

        private ParsePart() {
        }
    }

    static class TestOptions
    extends AclCreateOptions {
        @CommandLine.Option(names={"-V"}, description={"Validate all input files."})
        private boolean validate;

        TestOptions() {
        }

        public boolean isValidate() {
            return this.validate;
        }

        public void setValidate(boolean validate) {
            this.validate = validate;
        }
    }

    static class Urn
    implements Principal {
        final String name;

        public Urn(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    static class Group
    implements Principal {
        final String name;

        public Group(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    static class Username
    implements Principal {
        final String name;

        public Username(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    static enum Context {
        project,
        application;

    }

    static class AclCreateOptions
    extends AclOptions {
        @CommandLine.Option(names={"--stdin"}, description={"Read file or stdin for audit log data. (create command)"})
        private boolean stdin;
        @CommandLine.Option(names={"-c", "--context"}, description={"Context: ${COMPLETION-CANDIDATES}."})
        private Context context;
        @CommandLine.Option(names={"-R", "--resource"}, description={"Resource type name."})
        private String resource;
        @CommandLine.Option(names={"-A", "--adhoc"}, description={"Adhoc execution (project context)"})
        private boolean projectAdhoc;
        @CommandLine.Option(names={"-G", "--generic"}, description={"Generic resource kind."})
        private String genericType;
        @CommandLine.Option(names={"-b", "--attrs"}, arity="1..*", description={"Attributes for the resource. A sequence of key=value pairs, multiple pairs can follow with a space. Use a value of '?' to see suggestions."})
        private List<String> attributes;
        @CommandLine.Option(names={"-a", "--allow"}, arity="1..*", description={"Actions to test are allowed (test command) or to allow (create command). Accepts multiple values."})
        private List<String> allowAction;
        @CommandLine.Option(names={"-D", "--deny"}, arity="1..*", description={"Actions to test are denied (test command) or to deny (create command). Accepts multiple values."})
        private List<String> denyAction;
        @CommandLine.Option(names={"-r", "--regex"}, description={"Match the resource using regular expressions. (create command)."})
        private boolean regex;

        AclCreateOptions() {
        }

        boolean isContext() {
            return this.context != null;
        }

        boolean isResource() {
            return this.resource != null;
        }

        boolean isGenericType() {
            return this.genericType != null;
        }

        boolean isAttributes() {
            return Acl.notEmpty(this.attributes);
        }

        boolean isAllowAction() {
            return Acl.notEmpty(this.allowAction);
        }

        boolean isDenyAction() {
            return Acl.notEmpty(this.denyAction);
        }

        public boolean isStdin() {
            return this.stdin;
        }

        public Context getContext() {
            return this.context;
        }

        public String getResource() {
            return this.resource;
        }

        public boolean isProjectAdhoc() {
            return this.projectAdhoc;
        }

        public String getGenericType() {
            return this.genericType;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        public List<String> getAllowAction() {
            return this.allowAction;
        }

        public List<String> getDenyAction() {
            return this.denyAction;
        }

        public boolean isRegex() {
            return this.regex;
        }

        public void setStdin(boolean stdin) {
            this.stdin = stdin;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setProjectAdhoc(boolean projectAdhoc) {
            this.projectAdhoc = projectAdhoc;
        }

        public void setGenericType(String genericType) {
            this.genericType = genericType;
        }

        public void setAttributes(List<String> attributes) {
            this.attributes = attributes;
        }

        public void setAllowAction(List<String> allowAction) {
            this.allowAction = allowAction;
        }

        public void setDenyAction(List<String> denyAction) {
            this.denyAction = denyAction;
        }

        public void setRegex(boolean regex) {
            this.regex = regex;
        }
    }

    static class AclOptions {
        @CommandLine.Option(names={"-f", "--file"}, description={"File path. Load the specified aclpolicy file."})
        private File file;
        @CommandLine.Option(names={"-d", "--dir"}, description={"Directory. Load all policy files in the specified directory."})
        private File dir;
        @CommandLine.Option(names={"-g", "--groups"}, arity="1..*", description={"Subject Groups names to validate (test command) or for by: clause (create command). Accepts multiple values."})
        private List<String> groups;
        @CommandLine.Option(names={"-p", "--project"}, description={"Name of project, used in project context or for application resource."})
        private String project;
        @CommandLine.Option(names={"-P", "--projectacl"}, description={"Project name for ACL policy access, used in application context."})
        String projectAcl;
        @CommandLine.Option(names={"-s", "--storage"}, description={"Storage path/name. (application context)"})
        private String appStorage;
        @CommandLine.Option(names={"-j", "--job"}, description={"Job group/name. (project context)"})
        private String job;
        @CommandLine.Option(names={"-i", "--jobUuid"}, description={"Job uuid. (project context)"})
        private String jobUUID;
        @CommandLine.Option(names={"-n", "--node"}, description={"Node name. (project context)"})
        private String node;
        @CommandLine.Option(names={"-t", "--tags"}, arity="1..*", description={"Node tags. If specified, the resource match will be defined using 'contains'. (project context). Accepts multiple values."})
        private List<String> tags;
        @CommandLine.Option(names={"-u", "--user"}, description={"Subject User names to validate (test command) or for by: clause (create command)."})
        private String user;
        @CommandLine.Option(names={"-v", "--verbose"}, description={"Verbose output."})
        private boolean verbose;

        AclOptions() {
        }

        boolean isFile() {
            return this.file != null;
        }

        boolean isDir() {
            return this.dir != null;
        }

        boolean isGroups() {
            return Acl.notEmpty(this.groups);
        }

        boolean isProject() {
            return this.project != null;
        }

        boolean isProjectAcl() {
            return this.projectAcl != null;
        }

        boolean isAppStorage() {
            return this.appStorage != null;
        }

        boolean isJob() {
            return this.job != null;
        }

        boolean isJobUUID() {
            return this.jobUUID != null;
        }

        boolean isNode() {
            return this.node != null;
        }

        boolean isTags() {
            return Acl.notEmpty(this.tags);
        }

        boolean isUser() {
            return this.user != null;
        }

        public File getFile() {
            return this.file;
        }

        public File getDir() {
            return this.dir;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public String getProject() {
            return this.project;
        }

        public String getProjectAcl() {
            return this.projectAcl;
        }

        public String getAppStorage() {
            return this.appStorage;
        }

        public String getJob() {
            return this.job;
        }

        public String getJobUUID() {
            return this.jobUUID;
        }

        public String getNode() {
            return this.node;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String getUser() {
            return this.user;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public void setGroups(List<String> groups2) {
            this.groups = groups2;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public void setProjectAcl(String projectAcl) {
            this.projectAcl = projectAcl;
        }

        public void setAppStorage(String appStorage) {
            this.appStorage = appStorage;
        }

        public void setJob(String job) {
            this.job = job;
        }

        public void setJobUUID(String jobUUID) {
            this.jobUUID = jobUUID;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }
    }
}

