/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.rundeck.client.api.model.DateInfo;
import org.rundeck.client.util.RdClientConfig;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutionStateResponse {
    private String executionId;
    private String serverNode;
    private String executionState;
    private Boolean completed;
    private Integer stepCount;
    private DateInfo updateTime;
    private DateInfo startTime;
    private DateInfo endTime;
    private List<String> targetNodes;
    private List<String> allNodes;
    private Map<String, List<StepState>> nodes;

    public String execInfoString(RdClientConfig config) {
        return String.format("%s %s %s %s %s", this.executionId, this.executionState, null != this.startTime ? this.startTime.format(config.getDateFormat()) : "-", null != this.updateTime ? this.updateTime.format(config.getDateFormat()) : "-", null != this.endTime ? this.endTime.format(config.getDateFormat()) : "-");
    }

    public String nodeStatusString() {
        if (this.nodes == null) {
            return "No node status.";
        }
        return this.nodes.entrySet().stream().map(nodeEntry -> Optional.ofNullable(nodeEntry.getValue()).map(steps -> steps.stream().map(step -> String.format("%s:%-10s", step.getStepctx(), step.getExecutionState())).collect(Collectors.joining(" ", String.format("%-15s ", (String)nodeEntry.getKey() + ":"), ""))).orElse((String)nodeEntry.getKey() + ": No Status.")).collect(Collectors.joining("\n", "Node Step Status: \n", ""));
    }

    public String toString() {
        return "ExecutionStateResponse{executionId='" + this.executionId + '\'' + ", serverNode='" + this.serverNode + '\'' + ", executionState='" + this.executionState + '\'' + ", completed=" + this.completed + ", stepCount=" + this.stepCount + ", updateTime=" + this.updateTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", targetNodes=" + this.targetNodes + ", allNodes=" + this.allNodes + ", nodes=" + this.nodes + '}';
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getServerNode() {
        return this.serverNode;
    }

    public void setServerNode(String serverNode) {
        this.serverNode = serverNode;
    }

    public String getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(String executionState) {
        this.executionState = executionState;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public Integer getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(Integer stepCount) {
        this.stepCount = stepCount;
    }

    public DateInfo getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(DateInfo updateTime) {
        this.updateTime = updateTime;
    }

    public DateInfo getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateInfo startTime) {
        this.startTime = startTime;
    }

    public DateInfo getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateInfo endTime) {
        this.endTime = endTime;
    }

    public List<String> getTargetNodes() {
        return this.targetNodes;
    }

    public void setTargetNodes(List<String> targetNodes) {
        this.targetNodes = targetNodes;
    }

    public List<String> getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(List<String> allNodes) {
        this.allNodes = allNodes;
    }

    public Map<String, List<StepState>> getNodes() {
        return this.nodes;
    }

    public void setNodes(Map<String, List<StepState>> nodes) {
        this.nodes = nodes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StepState {
        private String stepctx;
        private String executionState;

        public String getStepctx() {
            return this.stepctx;
        }

        public void setStepctx(String stepctx) {
            this.stepctx = stepctx;
        }

        public String getExecutionState() {
            return this.executionState;
        }

        public void setExecutionState(String executionState) {
            this.executionState = executionState;
        }

        public String toString() {
            return "{stepctx='" + this.stepctx + '\'' + ", executionState='" + this.executionState + '\'' + '}';
        }
    }
}

