/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api;

import java.net.URL;
import java.util.List;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.rundeck.client.api.ReadmeFile;
import org.rundeck.client.api.model.ACLPolicy;
import org.rundeck.client.api.model.ACLPolicyItem;
import org.rundeck.client.api.model.AbortResult;
import org.rundeck.client.api.model.AdhocResponse;
import org.rundeck.client.api.model.ApiToken;
import org.rundeck.client.api.model.BulkExecutionDelete;
import org.rundeck.client.api.model.BulkExecutionDeleteResponse;
import org.rundeck.client.api.model.BulkJobDelete;
import org.rundeck.client.api.model.BulkToggleJobExecutionResponse;
import org.rundeck.client.api.model.BulkToggleJobScheduleResponse;
import org.rundeck.client.api.model.CreateToken;
import org.rundeck.client.api.model.DeleteJobsResult;
import org.rundeck.client.api.model.ExecOutput;
import org.rundeck.client.api.model.ExecRetry;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.ExecutionList;
import org.rundeck.client.api.model.ExecutionStateResponse;
import org.rundeck.client.api.model.IdList;
import org.rundeck.client.api.model.ImportResult;
import org.rundeck.client.api.model.JobFileItem;
import org.rundeck.client.api.model.JobFileItemList;
import org.rundeck.client.api.model.JobFileUploadResult;
import org.rundeck.client.api.model.JobItem;
import org.rundeck.client.api.model.JobRun;
import org.rundeck.client.api.model.KeyStorageItem;
import org.rundeck.client.api.model.ProjectConfig;
import org.rundeck.client.api.model.ProjectExportStatus;
import org.rundeck.client.api.model.ProjectImportStatus;
import org.rundeck.client.api.model.ProjectItem;
import org.rundeck.client.api.model.ProjectNode;
import org.rundeck.client.api.model.ProjectReadme;
import org.rundeck.client.api.model.RoleList;
import org.rundeck.client.api.model.ScmActionInputsResult;
import org.rundeck.client.api.model.ScmActionPerform;
import org.rundeck.client.api.model.ScmActionResult;
import org.rundeck.client.api.model.ScmConfig;
import org.rundeck.client.api.model.ScmPluginsResult;
import org.rundeck.client.api.model.ScmProjectStatusResult;
import org.rundeck.client.api.model.ScmSetupInputsResult;
import org.rundeck.client.api.model.Simple;
import org.rundeck.client.api.model.SystemInfo;
import org.rundeck.client.api.model.SystemMode;
import org.rundeck.client.api.model.User;
import org.rundeck.client.api.model.executions.MetricsResponse;
import org.rundeck.client.api.model.metrics.EndpointListResult;
import org.rundeck.client.api.model.metrics.HealthCheckStatus;
import org.rundeck.client.api.model.metrics.MetricsData;
import org.rundeck.client.api.model.repository.ArtifactActionMessage;
import org.rundeck.client.api.model.repository.RepositoryArtifacts;
import org.rundeck.client.api.model.scheduler.ForecastJobItem;
import org.rundeck.client.api.model.scheduler.ScheduledJobItem;
import org.rundeck.client.api.model.scheduler.SchedulerTakeover;
import org.rundeck.client.api.model.scheduler.SchedulerTakeoverResult;
import org.rundeck.client.util.Json;
import org.rundeck.client.util.Xml;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface RundeckApi {
    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/jobs")
    public Call<List<JobItem>> listJobs(@Path(value="project") String var1, @Query(value="jobFilter") String var2, @Query(value="groupPath") String var3, @Query(value="jobExactFilter") String var4, @Query(value="groupPathExact") String var5);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/jobs")
    public Call<List<JobItem>> listJobs(@Path(value="project") String var1, @Query(value="idlist") String var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="job/{jobid}/info")
    public Call<ScheduledJobItem> getJobInfo(@Path(value="jobid") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="jobs/file/{fileid}")
    public Call<JobFileItem> getJobFileInfo(@Path(value="fileid") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="job/{jobid}/input/files")
    public Call<JobFileItemList> listJobFiles(@Path(value="jobid") String var1, @Query(value="fileState") String var2, @Query(value="offset") int var3, @Query(value="max") int var4);

    @Headers(value={"Accept: application/json"})
    @GET(value="job/{jobid}/input/files")
    public Call<JobFileItemList> listJobFiles(@Path(value="jobid") String var1, @Query(value="offset") int var2, @Query(value="max") int var3);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{execid}/input/files")
    public Call<JobFileItemList> listExecutionFiles(@Path(value="execid") String var1, @Query(value="offset") int var2, @Query(value="max") int var3);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{jobid}/input/file")
    public Call<JobFileUploadResult> uploadJobOptionFile(@Path(value="jobid") String var1, @Query(value="optionName") String var2, @Query(value="fileName") String var3, @Body RequestBody var4);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{jobid}/execution/enable")
    public Call<Simple> jobExecutionEnable(@Path(value="jobid") String var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{jobid}/execution/disable")
    public Call<Simple> jobExecutionDisable(@Path(value="jobid") String var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{jobid}/schedule/enable")
    public Call<Simple> jobScheduleEnable(@Path(value="jobid") String var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{jobid}/schedule/disable")
    public Call<Simple> jobScheduleDisable(@Path(value="jobid") String var1);

    @GET(value="project/{project}/jobs/export")
    public Call<ResponseBody> exportJobs(@Path(value="project") String var1, @Query(value="jobFilter") String var2, @Query(value="groupPath") String var3, @Query(value="jobExactFilter") String var4, @Query(value="groupPathExact") String var5, @Query(value="format") String var6);

    @GET(value="project/{project}/jobs/export")
    public Call<ResponseBody> exportJobs(@Path(value="project") String var1, @Query(value="idlist") String var2, @Query(value="format") String var3);

    @Xml
    @Headers(value={"Accept: application/xml"})
    @POST(value="project/{project}/jobs/import")
    public Call<ImportResult> loadJobs(@Path(value="project") String var1, @Body RequestBody var2);

    @Xml
    @Headers(value={"Accept: application/xml"})
    @POST(value="project/{project}/jobs/import")
    public Call<ImportResult> loadJobs(@Path(value="project") String var1, @Body RequestBody var2, @Query(value="format") String var3, @Query(value="dupeOption") String var4, @Query(value="uuidOption") String var5);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="jobs/delete")
    public Call<DeleteJobsResult> deleteJobs(@Query(value="ids") List<String> var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="jobs/delete")
    public Call<DeleteJobsResult> deleteJobsBulk(@Body BulkJobDelete var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="projects")
    public Call<List<ProjectItem>> listProjects();

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}")
    public Call<ProjectItem> getProjectInfo(@Path(value="project") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/resources")
    public Call<Map<String, ProjectNode>> listNodes(@Path(value="project") String var1, @Query(value="filter") String var2);

    @Headers(value={"Accept: application/json"})
    @PUT(value="project/{project}/config")
    public Call<ProjectConfig> setProjectConfiguration(@Path(value="project") String var1, @Body ProjectConfig var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/config")
    public Call<ProjectConfig> getProjectConfiguration(@Path(value="project") String var1);

    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    @PUT(value="project/{project}/config/{key}")
    public Call<ProjectConfig> setProjectConfigurationKey(@Path(value="project") String var1, @Path(value="key") String var2, @Body ProjectConfig var3);

    @DELETE(value="project/{project}/config/{key}")
    public Call<Void> deleteProjectConfigurationKey(@Path(value="project") String var1, @Path(value="key") String var2);

    @Headers(value={"Accept: application/json"})
    @POST(value="projects")
    public Call<ProjectItem> createProject(@Body ProjectItem var1);

    @DELETE(value="project/{project}")
    public Call<Void> deleteProject(@Path(value="project") String var1);

    @Headers(value={"Accept: application/zip"})
    @GET(value="project/{project}/export")
    public Call<ResponseBody> exportProject(@Path(value="project") String var1, @Query(value="executionIds") List<String> var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/export/async")
    public Call<ProjectExportStatus> exportProjectAsync(@Path(value="project") String var1, @Query(value="exportAll") boolean var2, @Query(value="exportJobs") boolean var3, @Query(value="exportExecutions") boolean var4, @Query(value="exportConfigs") boolean var5, @Query(value="exportReadmes") boolean var6, @Query(value="exportAcls") boolean var7, @Query(value="exportScm") boolean var8);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/export/async")
    public Call<ProjectExportStatus> exportProjectAsync(@Path(value="project") String var1, @Query(value="executionIds") List<String> var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/export/status/{token}")
    public Call<ProjectExportStatus> exportProjectStatus(@Path(value="project") String var1, @Path(value="token") String var2);

    @Headers(value={"Accept: application/zip"})
    @GET(value="project/{project}/export/download/{token}")
    public Call<ResponseBody> exportProjectDownload(@Path(value="project") String var1, @Path(value="token") String var2);

    @Headers(value={"Accept: application/json"})
    @PUT(value="project/{project}/import")
    public Call<ProjectImportStatus> importProjectArchive(@Path(value="project") String var1, @Query(value="jobUuidOption") String var2, @Query(value="importExecutions") Boolean var3, @Query(value="importConfig") Boolean var4, @Query(value="importACL") Boolean var5, @Query(value="importScm") Boolean var6, @Query(value="importWebhooks") Boolean var7, @Query(value="whkRegenAuthTokens") Boolean var8, @Query(value="importNodesSources") Boolean var9, @Body RequestBody var10);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/executions/running")
    public Call<ExecutionList> runningExecutions(@Path(value="project") String var1, @Query(value="offset") int var2, @Query(value="max") int var3);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/executions")
    public Call<ExecutionList> listExecutions(@Path(value="project") String var1, @Query(value="offset") int var2, @Query(value="max") int var3, @Query(value="olderFilter") String var4, @Query(value="recentFilter") String var5);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/executions")
    public Call<ExecutionList> listExecutions(@Path(value="project") String var1, @QueryMap Map<String, String> var2, @Query(value="jobIdListFilter") List<String> var3, @Query(value="excludeJobIdListFilter") List<String> var4, @Query(value="jobListFilter") List<String> var5, @Query(value="excludeJobListFilter") List<String> var6);

    @Json
    @Headers(value={"Accept: application/json"})
    @POST(value="executions/delete")
    public Call<BulkExecutionDeleteResponse> deleteExecutions(@Body BulkExecutionDelete var1);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="job/{id}/executions")
    public Call<BulkExecutionDeleteResponse> deleteAllJobExecutions(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{id}/abort")
    public Call<AbortResult> abortExecution(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{id}")
    public Call<Execution> getExecution(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{id}/state")
    public Call<ExecutionStateResponse> getExecutionState(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="execution/{id}")
    public Call<Void> deleteExecution(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{id}/output")
    public Call<ExecOutput> getOutput(@Path(value="id") String var1, @Query(value="lastlines") Long var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{id}/output")
    public Call<ExecOutput> getOutput(@Path(value="id") String var1, @Query(value="offset") Long var2, @Query(value="lastmod") Long var3, @Query(value="maxlines") Long var4);

    @Headers(value={"Accept: application/json"})
    @GET(value="execution/{id}/output")
    public Call<ExecOutput> getOutput(@Path(value="id") String var1, @Query(value="offset") Long var2, @Query(value="lastmod") Long var3, @Query(value="maxlines") Long var4, @Query(value="compacted") Boolean var5);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/run/command")
    public Call<Execution> runCommand(@Path(value="project") String var1, @Query(value="exec") String var2, @Query(value="filter") String var3);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/run/command")
    public Call<AdhocResponse> runCommand(@Path(value="project") String var1, @Query(value="exec") String var2, @Query(value="nodeThreadcount") int var3, @Query(value="nodeKeepgoing") boolean var4, @Query(value="filter") String var5);

    @Multipart
    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/run/script")
    public Call<AdhocResponse> runScript(@Path(value="project") String var1, @Part MultipartBody.Part var2, @Query(value="argString") String var3, @Query(value="scriptInterpreter") String var4, @Query(value="interpreterArgsQuoted") boolean var5, @Query(value="fileExtension") String var6, @Query(value="filter") String var7);

    @Multipart
    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/run/script")
    public Call<AdhocResponse> runScript(@Path(value="project") String var1, @Part MultipartBody.Part var2, @Query(value="nodeThreadcount") int var3, @Query(value="nodeKeepgoing") boolean var4, @Query(value="argString") String var5, @Query(value="scriptInterpreter") String var6, @Query(value="interpreterArgsQuoted") boolean var7, @Query(value="fileExtension") String var8, @Query(value="filter") String var9);

    @Headers(value={"Accept: application/json"})
    @FormUrlEncoded
    @POST(value="project/{project}/run/url")
    public Call<Execution> runUrl(@Path(value="project") String var1, @Field(value="scriptURL") URL var2, @Field(value="argString") String var3, @Field(value="scriptInterpreter") String var4, @Field(value="interpreterArgsQuoted") boolean var5, @Field(value="fileExtension") String var6, @Field(value="filter") String var7);

    @Headers(value={"Accept: application/json"})
    @FormUrlEncoded
    @POST(value="project/{project}/run/url")
    public Call<AdhocResponse> runUrl(@Path(value="project") String var1, @Field(value="scriptURL") URL var2, @Field(value="nodeThreadcount") int var3, @Field(value="nodeKeepgoing") boolean var4, @Field(value="argString") String var5, @Field(value="scriptInterpreter") String var6, @Field(value="interpreterArgsQuoted") boolean var7, @Field(value="fileExtension") String var8, @Field(value="filter") String var9);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{id}/run")
    public Call<Execution> runJob(@Path(value="id") String var1, @Query(value="argString") String var2, @Query(value="loglevel") String var3, @Query(value="filter") String var4);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{id}/executions")
    public Call<Execution> runJob(@Path(value="id") String var1, @Query(value="argString") String var2, @Query(value="loglevel") String var3, @Query(value="filter") String var4, @Query(value="asUser") String var5);

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{id}/executions")
    public Call<Execution> runJob(@Path(value="id") String var1, @Body JobRun var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="storage/keys/{path}")
    public Call<KeyStorageItem> listKeyStorage(@Path(value="path", encoded=true) String var1);

    @Headers(value={"Accept: application/pgp-keys"})
    @GET(value="storage/keys/{path}")
    public Call<ResponseBody> getPublicKey(@Path(value="path", encoded=true) String var1);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="storage/keys/{path}")
    public Call<Void> deleteKeyStorage(@Path(value="path", encoded=true) String var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="storage/keys/{path}")
    public Call<KeyStorageItem> createKeyStorage(@Path(value="path", encoded=true) String var1, @Body RequestBody var2);

    @Headers(value={"Accept: application/json"})
    @PUT(value="storage/keys/{path}")
    public Call<KeyStorageItem> updateKeyStorage(@Path(value="path", encoded=true) String var1, @Body RequestBody var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/acl/")
    public Call<ACLPolicyItem> listAcls(@Path(value="project") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/acl/{name}")
    public Call<ACLPolicy> getAclPolicy(@Path(value="project") String var1, @Path(value="name") String var2);

    @Headers(value={"Accept: application/json"})
    @PUT(value="project/{project}/acl/{name}")
    public Call<ACLPolicy> updateAclPolicy(@Path(value="project") String var1, @Path(value="name") String var2, @Body RequestBody var3);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/acl/{name}")
    public Call<ACLPolicy> createAclPolicy(@Path(value="project") String var1, @Path(value="name") String var2, @Body RequestBody var3);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="project/{project}/acl/{name}")
    public Call<Void> deleteAclPolicy(@Path(value="project") String var1, @Path(value="name") String var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="system/acl/")
    public Call<ACLPolicyItem> listSystemAcls();

    @Headers(value={"Accept: application/json"})
    @GET(value="system/acl/{name}")
    public Call<ACLPolicy> getSystemAclPolicy(@Path(value="name") String var1);

    @Headers(value={"Accept: application/json"})
    @PUT(value="system/acl/{name}")
    public Call<ACLPolicy> updateSystemAclPolicy(@Path(value="name") String var1, @Body RequestBody var2);

    @Headers(value={"Accept: application/json"})
    @POST(value="system/acl/{name}")
    public Call<ACLPolicy> createSystemAclPolicy(@Path(value="name") String var1, @Body RequestBody var2);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="system/acl/{name}")
    public Call<Void> deleteSystemAclPolicy(@Path(value="name") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="system/info")
    public Call<SystemInfo> systemInfo();

    @Headers(value={"Accept: application/json"})
    @POST(value="system/executions/enable")
    public Call<SystemMode> executionModeEnable();

    @Headers(value={"Accept: application/json"})
    @POST(value="system/executions/disable")
    public Call<SystemMode> executionModeDisable();

    @Headers(value={"Accept: application/json"})
    @GET(value="scheduler/jobs")
    public Call<List<ScheduledJobItem>> listSchedulerJobs();

    @Headers(value={"Accept: application/json"})
    @GET(value="scheduler/server/{uuid}/jobs")
    public Call<List<ScheduledJobItem>> listSchedulerJobs(@Path(value="uuid") String var1);

    @Headers(value={"Accept: application/json"})
    @PUT(value="scheduler/takeover")
    public Call<SchedulerTakeoverResult> takeoverSchedule(@Body SchedulerTakeover var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/scm/{integration}/config")
    public Call<ScmConfig> getScmConfig(@Path(value="project") String var1, @Path(value="integration") String var2);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/scm/{integration}/plugin/{type}/setup")
    public Call<ScmActionResult> setupScmConfig(@Path(value="project") String var1, @Path(value="integration") String var2, @Path(value="type") String var3, @Body RequestBody var4);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/scm/{integration}/status")
    public Call<ScmProjectStatusResult> getScmProjectStatus(@Path(value="project") String var1, @Path(value="integration") String var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/scm/{integration}/plugin/{type}/input")
    public Call<ScmSetupInputsResult> getScmSetupInputs(@Path(value="project") String var1, @Path(value="integration") String var2, @Path(value="type") String var3);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/scm/{integration}/action/{action}/input")
    public Call<ScmActionInputsResult> getScmActionInputs(@Path(value="project") String var1, @Path(value="integration") String var2, @Path(value="action") String var3);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/scm/{integration}/action/{action}")
    public Call<ScmActionResult> performScmAction(@Path(value="project") String var1, @Path(value="integration") String var2, @Path(value="action") String var3, @Body ScmActionPerform var4);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/scm/{integration}/plugins")
    public Call<ScmPluginsResult> listScmPlugins(@Path(value="project") String var1, @Path(value="integration") String var2);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/scm/{integration}/plugin/{type}/enable")
    public Call<Void> enableScmPlugin(@Path(value="project") String var1, @Path(value="integration") String var2, @Path(value="type") String var3);

    @Headers(value={"Accept: application/json"})
    @POST(value="project/{project}/scm/{integration}/plugin/{type}/disable")
    public Call<Void> disableScmPlugin(@Path(value="project") String var1, @Path(value="integration") String var2, @Path(value="type") String var3);

    @Headers(value={"Accept: application/json"})
    @GET(value="tokens}")
    public Call<List<ApiToken>> listTokens();

    @Headers(value={"Accept: application/json"})
    @GET(value="tokens/{user}")
    public Call<List<ApiToken>> listTokens(@Path(value="user") String var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="tokens/{user}")
    public Call<ApiToken> createToken(@Path(value="user") String var1);

    @Headers(value={"Accept: application/json"})
    @POST(value="tokens")
    public Call<ApiToken> createToken(@Body CreateToken var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="token/{id}")
    public Call<ApiToken> getToken(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="token/{id}")
    public Call<Void> deleteToken(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/{file}")
    public Call<ProjectReadme> getReadme(@Path(value="project") String var1, @Path(value="file") ReadmeFile var2);

    @Headers(value={"Accept: application/json"})
    @PUT(value="project/{project}/{file}")
    public Call<ProjectReadme> putReadme(@Path(value="project") String var1, @Path(value="file") ReadmeFile var2, @Body RequestBody var3);

    @Headers(value={"Accept: application/json"})
    @DELETE(value="project/{project}/{file}")
    public Call<Void> deleteReadme(@Path(value="project") String var1, @Path(value="file") ReadmeFile var2);

    @Headers(value={"Accept: application/json"})
    @GET(value="user/info/{user}")
    public Call<User> getUserInfo(@Path(value="user") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="user/info/")
    public Call<User> getUserInfo();

    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    @POST(value="user/info/{user}")
    public Call<User> editUserInfo(@Path(value="user") String var1, @Body User var2);

    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    @POST(value="user/info/")
    public Call<User> editUserInfo(@Body User var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="user/list")
    public Call<List<User>> listUsers();

    @Headers(value={"Accept: application/json"})
    @GET(value="user/roles")
    public Call<RoleList> listRoles();

    @Headers(value={"Accept: application/json"})
    @POST(value="job/{id}/retry/{eid}")
    public Call<Execution> retryJob(@Path(value="id") String var1, @Path(value="eid") String var2, @Body ExecRetry var3);

    @Headers(value={"Accept: application/json"})
    @GET(value="plugins/list")
    public Call<List<RepositoryArtifacts>> listPlugins();

    @Headers(value={"Accept: application/json"})
    @POST(value="plugins/{repoName}/upload")
    public Call<ArtifactActionMessage> uploadPlugin(@Path(value="repoName") String var1, @Body RequestBody var2);

    @Headers(value={"Accept: application/json"})
    @POST(value="plugins/{repoName}/install/{pluginId}")
    public Call<ArtifactActionMessage> installPlugin(@Path(value="repoName") String var1, @Path(value="pluginId") String var2);

    @Headers(value={"Accept: application/json"})
    @POST(value="plugins/{repoName}/install/{pluginId}/{version}")
    public Call<ArtifactActionMessage> installPlugin(@Path(value="repoName") String var1, @Path(value="pluginId") String var2, @Path(value="version") String var3);

    @Headers(value={"Accept: application/json"})
    @POST(value="plugins/uninstall/{pluginId}")
    public Call<ArtifactActionMessage> uninstallPlugin(@Path(value="pluginId") String var1);

    @Json
    @Headers(value={"Accept: application/json"})
    @POST(value="jobs/execution/enable")
    public Call<BulkToggleJobExecutionResponse> bulkEnableJobs(@Body IdList var1);

    @Json
    @Headers(value={"Accept: application/json"})
    @POST(value="jobs/execution/disable")
    public Call<BulkToggleJobExecutionResponse> bulkDisableJobs(@Body IdList var1);

    @Json
    @Headers(value={"Accept: application/json"})
    @POST(value="jobs/schedule/enable")
    public Call<BulkToggleJobScheduleResponse> bulkEnableJobSchedule(@Body IdList var1);

    @Json
    @Headers(value={"Accept: application/json"})
    @POST(value="jobs/schedule/disable")
    public Call<BulkToggleJobScheduleResponse> bulkDisableJobSchedule(@Body IdList var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="metrics")
    public Call<EndpointListResult> listMetricsEndpoints();

    @Headers(value={"Accept: application/json"})
    @GET(value="metrics/healthcheck")
    public Call<Map<String, HealthCheckStatus>> getHealthCheckMetrics();

    @Headers(value={"Accept: application/json"})
    @GET(value="metrics/threads")
    public Call<ResponseBody> getThreadMetrics();

    @Headers(value={"Accept: application/json"})
    @GET(value="metrics/ping")
    public Call<ResponseBody> getPing();

    @Headers(value={"Accept: application/json"})
    @GET(value="metrics/metrics")
    public Call<MetricsData> getMetricsData();

    @Headers(value={"Accept: application/json"})
    @GET(value="project/{project}/executions/metrics")
    public Call<MetricsResponse> executionMetrics(@Path(value="project") String var1, @QueryMap Map<String, String> var2, @Query(value="jobIdListFilter") List<String> var3, @Query(value="excludeJobIdListFilter") List<String> var4, @Query(value="jobListFilter") List<String> var5, @Query(value="excludeJobListFilter") List<String> var6);

    @Headers(value={"Accept: application/json"})
    @GET(value="executions/metrics")
    public Call<MetricsResponse> executionMetrics(@QueryMap Map<String, String> var1, @Query(value="jobIdListFilter") List<String> var2, @Query(value="excludeJobIdListFilter") List<String> var3, @Query(value="jobListFilter") List<String> var4, @Query(value="excludeJobListFilter") List<String> var5);

    @Headers(value={"Accept: application/xml"})
    @GET(value="project/{project}/executions/metrics")
    public Call<ResponseBody> executionMetricsXML(@Path(value="project") String var1, @QueryMap Map<String, String> var2, @Query(value="jobIdListFilter") List<String> var3, @Query(value="excludeJobIdListFilter") List<String> var4, @Query(value="jobListFilter") List<String> var5, @Query(value="excludeJobListFilter") List<String> var6);

    @Headers(value={"Accept: application/xml"})
    @GET(value="executions/metrics")
    public Call<ResponseBody> executionMetricsXML(@QueryMap Map<String, String> var1, @Query(value="jobIdListFilter") List<String> var2, @Query(value="excludeJobIdListFilter") List<String> var3, @Query(value="jobListFilter") List<String> var4, @Query(value="excludeJobListFilter") List<String> var5);

    @Headers(value={"Accept: application/json"})
    @GET(value="job/{jobid}/forecast")
    public Call<ForecastJobItem> getJobForecast(@Path(value="jobid") String var1, @Query(value="time") String var2, @Query(value="max") Integer var3);
}

