/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/JavaNetCookieJar;", "Lokhttp3/CookieJar;", "cookieHandler", "Ljava/net/CookieHandler;", "(Ljava/net/CookieHandler;)V", "decodeHeaderAsJavaNetCookies", "", "Lokhttp3/Cookie;", "url", "Lokhttp3/HttpUrl;", "header", "", "loadForRequest", "saveFromResponse", "", "cookies", "okhttp-urlconnection"})
public final class JavaNetCookieJar
implements CookieJar {
    private final CookieHandler cookieHandler;

    @Override
    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(cookies, "cookies");
        boolean bl = false;
        List cookieStrings = new ArrayList();
        for (Cookie cookie : cookies) {
            cookieStrings.add(Internal.cookieToString(cookie, true));
        }
        Map<String, List<String>> multimap = MapsKt.mapOf(TuplesKt.to("Set-Cookie", cookieStrings));
        try {
            this.cookieHandler.put(url.uri(), multimap);
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Saving cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull(httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        List<Cookie> list;
        Map<String, List<String>> map;
        Intrinsics.checkNotNullParameter(url, "url");
        try {
            map = this.cookieHandler.get(url.uri(), MapsKt.emptyMap());
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Loading cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull(httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, e);
            return CollectionsKt.emptyList();
        }
        Map<String, List<String>> cookieHeaders = map;
        List cookies = null;
        Map<String, List<String>> map2 = cookieHeaders;
        Intrinsics.checkNotNullExpressionValue(map2, "cookieHeaders");
        Object object = map2;
        boolean bl = false;
        for (Map.Entry<String, List<String>> entry : object.entrySet()) {
            void key;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            List<String> value = object2.getValue();
            if (!StringsKt.equals("Cookie", (String)key, true) && !StringsKt.equals("Cookie2", (String)key, true)) continue;
            List<String> list2 = value;
            Intrinsics.checkNotNullExpressionValue(list2, "value");
            object2 = list2;
            bl2 = false;
            if (!(!object2.isEmpty())) continue;
            for (String header : value) {
                if (cookies == null) {
                    boolean bl3 = false;
                    cookies = new ArrayList();
                }
                String string = header;
                Intrinsics.checkNotNullExpressionValue(string, "header");
                cookies.addAll((Collection)this.decodeHeaderAsJavaNetCookies(url, string));
            }
        }
        if (cookies != null) {
            List list3 = Collections.unmodifiableList(cookies);
            list = list3;
            Intrinsics.checkNotNullExpressionValue(list3, "Collections.unmodifiableList(cookies)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        boolean bl = false;
        List result = new ArrayList();
        int pos = 0;
        int limit = header.length();
        int pairEnd = 0;
        while (pos < limit) {
            String value;
            pairEnd = Util.delimiterOffset(header, ";,", pos, limit);
            int equalsSign = Util.delimiterOffset(header, '=', pos, pairEnd);
            String name = Util.trimSubstring(header, pos, equalsSign);
            if (StringsKt.startsWith$default(name, "$", false, 2, null)) {
                pos = pairEnd + 1;
                continue;
            }
            String string = value = equalsSign < pairEnd ? Util.trimSubstring(header, equalsSign + 1, pairEnd) : "";
            if (StringsKt.startsWith$default(value, "\"", false, 2, null) && StringsKt.endsWith$default(value, "\"", false, 2, null)) {
                String string2 = value;
                int n = 1;
                int n2 = value.length() - 1;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                value = string4;
            }
            result.add(new Cookie.Builder().name(name).value(value).domain(url.host()).build());
            pos = pairEnd + 1;
        }
        return result;
    }

    public JavaNetCookieJar(@NotNull CookieHandler cookieHandler) {
        Intrinsics.checkNotNullParameter(cookieHandler, "cookieHandler");
        this.cookieHandler = cookieHandler;
    }
}

