/*
 * Decompiled with CFR 0.152.
 */
package net.daimonin.client3d.editor.main;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.JAI;
import net.daimonin.client3d.editor.object.ImageSetImage;
import net.daimonin.client3d.editor.ui.GeneratePanel;
import net.daimonin.client3d.editor.ui.MainFrame;
import net.daimonin.client3d.editor.ui.PreferencesPanel;
import net.daimonin.client3d.editor.util.FilenameFilterPNG;
import net.daimonin.client3d.editor.util.binpacker.BinPacker;
import net.daimonin.client3d.editor.util.binpacker.Rect;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Editor3D {
    private static final String CONF_RESTRICT_SIZE_HEIGHT = "imageset.maxHeight";
    private static final String CONF_RESTRICT_SIZE_WIDTH = "imageset.maxWidth";
    private static final String CONF_RESTRICT_SIZE = "imageset.restrictSize";
    private static final String CONF_FILENAME_IMAGESET_XML = "imageset.filename.xml";
    private static final String CONF_FILENAME_IMAGESET = "imageset.filename";
    private static final String CONF_BORDER_COLOR_BLUE = "imageset.border.color.blue";
    private static final String CONF_BORDER_COLOR_GREEN = "imageset.border.color.green";
    private static final String CONF_BORDER_COLOR_RED = "imageset.border.color.red";
    private static final String CONF_BORDER_SIZE = "imageset.border.size";
    private static final String CONF_IMAGES_DIR = "images.dir";
    public static final String VERSION = "0.2.0";
    private static final int BORDERSIZEMAX = 3;
    private static final int BORDERCOLORMAX = 255;
    private static PropertiesConfiguration conf;
    public static String imageset;
    public static String imagesetxml;
    public static String startingDir;
    public static String borderSize;
    public static String borderColorR;
    public static String borderColorG;
    public static String borderColorB;
    public static boolean restrictImageSize;
    public static int maxWidth;
    public static int maxHeight;
    private static int[] dimension;
    private static List<ImageSetImage> images;
    private static MainFrame frame;

    public static void main(String[] args) {
        conf = Editor3D.readConfig();
        imageset = conf.getString(CONF_FILENAME_IMAGESET);
        imagesetxml = conf.getString(CONF_FILENAME_IMAGESET_XML);
        startingDir = conf.getString(CONF_IMAGES_DIR);
        borderSize = conf.getString(CONF_BORDER_SIZE);
        borderColorR = conf.getString(CONF_BORDER_COLOR_RED);
        borderColorG = conf.getString(CONF_BORDER_COLOR_GREEN);
        borderColorB = conf.getString(CONF_BORDER_COLOR_BLUE);
        restrictImageSize = conf.getBoolean(CONF_RESTRICT_SIZE);
        maxWidth = conf.getInt(CONF_RESTRICT_SIZE_WIDTH);
        maxHeight = conf.getInt(CONF_RESTRICT_SIZE_HEIGHT);
        frame = new MainFrame();
        frame.setVisible(true);
        Editor3D.printInfo("Welcome to Daimonin 3D GUI-editor 0.2.0");
    }

    private static PropertiesConfiguration readConfig() {
        try {
            String string = "editor3d.config";
            if (!new File("editor3d.config").exists()) {
                Editor3D.exit(1, "Configuration file 'editor3d.config' does not exist!");
            }
            return new PropertiesConfiguration("editor3d.config");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            Editor3D.printError(e.getMessage());
            return null;
        }
    }

    private static void writeImageSet(String fileNameImageSet, int[] dimension) throws IOException {
        BufferedImage bigImg = new BufferedImage(dimension[0], dimension[1], 2);
        Graphics2D big = bigImg.createGraphics();
        int i = 0;
        while (i < images.size()) {
            if (images.get(i).getBorderSize() > 0) {
                ParameterBlock params = new ParameterBlock();
                params.addSource(images.get(i).getImage());
                params.add(images.get(i).getBorderSize());
                params.add(images.get(i).getBorderSize());
                params.add(images.get(i).getBorderSize());
                params.add(images.get(i).getBorderSize());
                params.add(new BorderExtenderConstant(new double[]{images.get(i).getBorderColor().getRed(), images.get(i).getBorderColor().getGreen(), images.get(i).getBorderColor().getBlue(), 255.0}));
                big.drawImage((Image)JAI.create((String)"border", (ParameterBlock)params).getAsBufferedImage(), images.get(i).getPosX(), images.get(i).getPosY(), null);
            } else {
                big.drawImage((Image)images.get(i).getImage(), images.get(i).getPosX(), images.get(i).getPosY(), null);
            }
            ++i;
        }
        big.dispose();
        ImageIO.write((RenderedImage)bigImg, "png", new File(fileNameImageSet));
        Editor3D.printInfo(String.valueOf(System.getProperty("user.dir")) + "/" + imageset + " created");
    }

    private static void writeXML(String fileNameImageSet, String fileNameXML) throws IOException {
        List mouse;
        Hashtable names = new Hashtable();
        int i = 0;
        while (i < images.size()) {
            if (!names.containsKey(images.get(i).getName())) {
                ArrayList<ImageSetImage> values = new ArrayList<ImageSetImage>();
                values.add(images.get(i));
                names.put(images.get(i).getName(), values);
            } else {
                ((List)names.get(images.get(i).getName())).add(images.get(i));
            }
            ++i;
        }
        Enumeration keys2 = names.keys();
        while (keys2.hasMoreElements()) {
            List img2 = (List)names.get(keys2.nextElement());
            if ("fontextensions".equals(((ImageSetImage)img2.get(0)).getName())) continue;
            boolean hasDefault = false;
            int i2 = 0;
            while (i2 < img2.size()) {
                if ("default".equals(((ImageSetImage)img2.get(i2)).getState().toLowerCase())) {
                    hasDefault = true;
                }
                ++i2;
            }
            if (hasDefault) continue;
            Editor3D.printError("WARNING: image category '" + ((ImageSetImage)img2.get(0)).getName() + "' has no image with a default state!");
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("ImageSet").addAttribute("file", fileNameImageSet);
        List fntex = (List)names.get("fontextensions");
        if (fntex != null) {
            Element category = root.addElement("ImageFntExt").addAttribute("name", ((ImageSetImage)fntex.get(0)).getName());
            int i3 = 0;
            while (i3 < fntex.size()) {
                category.addElement("State").addAttribute("name", ((ImageSetImage)fntex.get(i3)).getState()).addAttribute("posX", String.valueOf(((ImageSetImage)fntex.get(i3)).getPosX() + ((ImageSetImage)fntex.get(i3)).getBorderSize())).addAttribute("posY", String.valueOf(((ImageSetImage)fntex.get(i3)).getPosY() + ((ImageSetImage)fntex.get(i3)).getBorderSize())).addAttribute("width", String.valueOf(((ImageSetImage)fntex.get(i3)).getWidth())).addAttribute("height", String.valueOf(((ImageSetImage)fntex.get(i3)).getHeight()));
                ++i3;
            }
            names.remove("fontextensions");
        }
        if ((mouse = (List)names.get("mousecursor")) != null) {
            Element category = root.addElement("Image").addAttribute("name", ((ImageSetImage)mouse.get(0)).getName()).addAttribute("width", String.valueOf(((ImageSetImage)mouse.get(0)).getImage().getWidth())).addAttribute("height", String.valueOf(((ImageSetImage)mouse.get(0)).getImage().getHeight())).addAttribute("alpha", ((ImageSetImage)mouse.get(0)).getImage().getColorModel().hasAlpha() ? String.valueOf(1) : String.valueOf(0));
            int i4 = 0;
            while (i4 < mouse.size()) {
                Editor3D.checkImageSameDimension((ImageSetImage)mouse.get(0), (ImageSetImage)mouse.get(i4), "Images of same category have different dimension");
                Editor3D.checkImageSameAlpha((ImageSetImage)mouse.get(0), (ImageSetImage)mouse.get(i4), "Images of same category have different alpha");
                category.addElement("State").addAttribute("name", ((ImageSetImage)mouse.get(i4)).getState()).addAttribute("posX", String.valueOf(((ImageSetImage)mouse.get(i4)).getPosX() + ((ImageSetImage)mouse.get(i4)).getBorderSize())).addAttribute("posY", String.valueOf(((ImageSetImage)mouse.get(i4)).getPosY() + ((ImageSetImage)mouse.get(i4)).getBorderSize()));
                ++i4;
            }
            names.remove("mousecursor");
        }
        Enumeration keys = names.keys();
        while (keys.hasMoreElements()) {
            List img = (List)names.get(keys.nextElement());
            Element category = root.addElement("Image").addAttribute("name", ((ImageSetImage)img.get(0)).getName()).addAttribute("width", String.valueOf(((ImageSetImage)img.get(0)).getImage().getWidth())).addAttribute("height", String.valueOf(((ImageSetImage)img.get(0)).getImage().getHeight())).addAttribute("alpha", ((ImageSetImage)img.get(0)).getImage().getColorModel().hasAlpha() ? String.valueOf(1) : String.valueOf(0));
            int i5 = 0;
            while (i5 < img.size()) {
                Editor3D.checkImageSameDimension((ImageSetImage)img.get(0), (ImageSetImage)img.get(i5), "Images of same category have different dimension");
                Editor3D.checkImageSameAlpha((ImageSetImage)img.get(0), (ImageSetImage)img.get(i5), "Images of same category have different alpha");
                category.addElement("State").addAttribute("name", ((ImageSetImage)img.get(i5)).getState()).addAttribute("posX", String.valueOf(((ImageSetImage)img.get(i5)).getPosX() + ((ImageSetImage)img.get(i5)).getBorderSize())).addAttribute("posY", String.valueOf(((ImageSetImage)img.get(i5)).getPosY() + ((ImageSetImage)img.get(i5)).getBorderSize()));
                ++i5;
            }
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(fileNameXML), format);
        writer.write(document);
        writer.close();
        Editor3D.printInfo(String.valueOf(System.getProperty("user.dir")) + "/" + imagesetxml + " created");
    }

    private static void checkImageSameDimension(ImageSetImage img1, ImageSetImage img2, String message) {
        int width1 = img1.getWidth();
        int width2 = img2.getWidth();
        int height1 = img1.getHeight();
        int height2 = img2.getHeight();
        if (width1 != width2 || height1 != height2) {
            Editor3D.exit(1, String.valueOf(message) + ": " + img1 + "-> width=" + width1 + " height=" + height1 + ", " + img2 + "-> width=" + width2 + " height=" + height2);
        }
    }

    private static void checkImageSameAlpha(ImageSetImage img1, ImageSetImage img2, String message) {
        boolean alpha2;
        boolean alpha1 = img1.getImage().getColorModel().hasAlpha();
        if (alpha1 != (alpha2 = img2.getImage().getColorModel().hasAlpha())) {
            Editor3D.exit(1, String.valueOf(message) + ": " + img1 + "-> alpha=" + alpha1 + ", " + img2 + "-> alpha=" + alpha2);
        }
    }

    private static int[] packImages(int[] dimension) {
        ArrayList<Rect> rects = new ArrayList<Rect>(images.size());
        int i = 0;
        while (i < images.size()) {
            rects.add(Editor3D.createRect(images.get(i)));
            ++i;
        }
        BinPacker binPacker = new BinPacker();
        List<Rect> packedRects = binPacker.packOptimized(rects, false, dimension);
        assert (images.size() == packedRects.size());
        int i2 = 0;
        while (i2 < images.size()) {
            int j = 0;
            while (j < packedRects.size()) {
                if (images.get(i2).toString().equals(packedRects.get(j).getId())) {
                    images.get(i2).setPosX(packedRects.get(j).getX());
                    images.get(i2).setPosY(packedRects.get(j).getY());
                }
                ++j;
            }
            ++i2;
        }
        return dimension;
    }

    private static void readImages(String startingDir, String borderSize, String borderColorR, String borderColorG, String borderColorB) {
        int lBorderSize;
        ArrayList<File> gfxFiles = new ArrayList<File>();
        Editor3D.readFilesRecursively(new File(startingDir), gfxFiles);
        if (gfxFiles.size() == 0) {
            Editor3D.exit(1, "No PNG files found in directory '" + startingDir + "'. Nothing to do.");
        }
        images = new ArrayList<ImageSetImage>(gfxFiles.size());
        if (!ImageSetImage.checkFilenames(gfxFiles)) {
            Editor3D.exit(1, "Invalid format of image file name. I have to exit.");
        }
        if ((lBorderSize = Integer.valueOf(borderSize).intValue()) < 0) {
            lBorderSize = 0;
        } else if (lBorderSize > 3) {
            lBorderSize = 3;
        }
        int lBorderColorR = Integer.valueOf(borderColorR);
        int lBorderColorG = Integer.valueOf(borderColorG);
        int lBorderColorB = Integer.valueOf(borderColorB);
        if (lBorderColorR < 0) {
            lBorderColorR = 0;
        } else if (lBorderColorR > 255) {
            lBorderColorR = 255;
        }
        if (lBorderColorG < 0) {
            lBorderColorG = 0;
        } else if (lBorderColorG > 255) {
            lBorderColorG = 255;
        }
        if (lBorderColorB < 0) {
            lBorderColorB = 0;
        } else if (lBorderColorB > 255) {
            lBorderColorB = 255;
        }
        int i = 0;
        while (i < gfxFiles.size()) {
            ImageSetImage image = new ImageSetImage((File)gfxFiles.get(i));
            if (lBorderSize > 0) {
                image.setBorderSize(lBorderSize);
                image.setBorderColor(new Color(lBorderColorR, lBorderColorG, lBorderColorB));
            }
            images.add(image);
            ++i;
        }
    }

    private static void readFilesRecursively(File startingDir, List<File> fileList) {
        File[] children;
        if (startingDir.isFile()) {
            fileList.add(startingDir);
        }
        if ((children = startingDir.listFiles(new FilenameFilterPNG())) != null) {
            int i = 0;
            while (i < children.length) {
                Editor3D.readFilesRecursively(children[i], fileList);
                ++i;
            }
        }
    }

    private static Rect createRect(ImageSetImage img) {
        return new Rect(img.toString(), img.getWidth() + img.getBorderSize() * 2, img.getHeight() + img.getBorderSize() * 2);
    }

    private static void exit(int status, String message) {
        if (status == 0) {
            Editor3D.printInfo(message);
            System.exit(0);
        } else {
            Editor3D.printError(message);
        }
    }

    public static void generate(GeneratePanel allPanel) {
        try {
            Editor3D.saveConfig(allPanel);
            dimension = restrictImageSize ? new int[]{maxWidth, maxHeight} : new int[]{-1, -1};
            Editor3D.readImages(startingDir, borderSize, borderColorR, borderColorG, borderColorB);
            dimension = Editor3D.packImages(dimension);
            Editor3D.writeXML(imageset, imagesetxml);
            Editor3D.writeImageSet(imageset, dimension);
            Editor3D.printSuccess("Success.\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            Editor3D.printError(e.getMessage());
        }
    }

    public static void savePreferences(PreferencesPanel prefPanel) {
        String restrictedHeight;
        String restrictedWidth;
        boolean restrictSize;
        String filenameXML;
        boolean prefsChanged = false;
        String filenamePNG = prefPanel.jTextFieldFilenamePNG.getText();
        if (filenamePNG != null && !filenamePNG.equals(conf.getString(CONF_FILENAME_IMAGESET))) {
            prefsChanged = true;
            conf.setProperty(CONF_FILENAME_IMAGESET, (Object)filenamePNG);
            imageset = filenamePNG;
        }
        if ((filenameXML = prefPanel.jTextFieldFilenameXML.getText()) != null && !filenameXML.equals(conf.getString(CONF_FILENAME_IMAGESET_XML))) {
            prefsChanged = true;
            conf.setProperty(CONF_FILENAME_IMAGESET_XML, (Object)filenameXML);
            imagesetxml = filenameXML;
        }
        if (!String.valueOf(restrictSize = prefPanel.jCheckBoxRestrictPNGSize.isSelected()).equals(conf.getString(CONF_RESTRICT_SIZE))) {
            prefsChanged = true;
            conf.setProperty(CONF_RESTRICT_SIZE, (Object)String.valueOf(restrictSize));
            restrictImageSize = restrictSize;
        }
        if ((restrictedWidth = prefPanel.jTextFieldRestrictedWidth.getText()) != null && !restrictedWidth.equals(conf.getString(CONF_RESTRICT_SIZE_WIDTH))) {
            prefsChanged = true;
            conf.setProperty(CONF_RESTRICT_SIZE_WIDTH, (Object)restrictedWidth);
            maxWidth = Integer.valueOf(restrictedWidth);
        }
        if ((restrictedHeight = prefPanel.jTextFieldRestrictedHeight.getText()) != null && !restrictedHeight.equals(conf.getString(CONF_RESTRICT_SIZE_HEIGHT))) {
            prefsChanged = true;
            conf.setProperty(CONF_RESTRICT_SIZE_HEIGHT, (Object)restrictedHeight);
            maxHeight = Integer.valueOf(restrictedHeight);
        }
        try {
            if (prefsChanged) {
                conf.save(conf.getFile());
                Editor3D.printInfo("Preferences saved");
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            Editor3D.printError(e.getMessage());
        }
        Editor3D.frame.jScrollPaneMain.setViewportView(null);
        Editor3D.frame.prefPanel = null;
    }

    public static void cancelPreferences() {
        Editor3D.frame.jScrollPaneMain.setViewportView(null);
        Editor3D.frame.prefPanel = null;
    }

    private static void saveConfig(GeneratePanel allPanel) {
        boolean confChanged = false;
        if (allPanel.jCheckBoxStartingDir.isSelected() && !startingDir.equals(conf.getString(CONF_IMAGES_DIR))) {
            confChanged = true;
            conf.setProperty(CONF_IMAGES_DIR, (Object)startingDir);
        }
        if (allPanel.jCheckBoxBorderSize.isSelected() && !borderSize.equals(conf.getString(CONF_BORDER_SIZE))) {
            confChanged = true;
            conf.setProperty(CONF_BORDER_SIZE, (Object)borderSize);
        }
        if (allPanel.jCheckBoxBorderColor.isSelected() && !borderColorR.equals(conf.getString(CONF_BORDER_COLOR_RED))) {
            confChanged = true;
            conf.setProperty(CONF_BORDER_COLOR_RED, (Object)borderColorR);
        }
        if (allPanel.jCheckBoxBorderColor.isSelected() && !borderColorG.equals(conf.getString(CONF_BORDER_COLOR_GREEN))) {
            confChanged = true;
            conf.setProperty(CONF_BORDER_COLOR_GREEN, (Object)borderColorG);
        }
        if (allPanel.jCheckBoxBorderColor.isSelected() && !borderColorB.equals(conf.getString(CONF_BORDER_COLOR_BLUE))) {
            confChanged = true;
            conf.setProperty(CONF_BORDER_COLOR_BLUE, (Object)borderColorB);
        }
        try {
            if (confChanged) {
                conf.save(conf.getFile());
                Editor3D.printInfo("Configuration saved");
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            Editor3D.printError(e.getMessage());
        }
    }

    private static void printInfo(String msg) {
        Editor3D.frame.jTextAreaInfo.append(String.valueOf(msg) + "\n");
        Editor3D.frame.jTextAreaInfo.setCaretPosition(Editor3D.frame.jTextAreaInfo.getText().length());
    }

    private static void printError(String msg) {
        Editor3D.frame.jTextAreaInfo.append(String.valueOf(msg) + "\n");
        Editor3D.frame.jTextAreaInfo.setCaretPosition(Editor3D.frame.jTextAreaInfo.getText().length());
    }

    private static void printSuccess(String msg) {
        Editor3D.frame.jTextAreaInfo.append(String.valueOf(msg) + "\n");
        Editor3D.frame.jTextAreaInfo.setCaretPosition(Editor3D.frame.jTextAreaInfo.getText().length());
    }
}

