/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.javabean.metadata.properties;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.annotation.Containment;
import org.eclipse.xwt.core.IBinding;
import org.eclipse.xwt.internal.utils.ObjectUtil;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.javabean.metadata.properties.AbstractProperty;
import org.eclipse.xwt.metadata.ILoadingType;

public class BeanProperty
extends AbstractProperty {
    protected PropertyDescriptor descriptor;
    private boolean containment = false;

    public BeanProperty(PropertyDescriptor descriptor) {
        this(descriptor, ILoadingType.DEFAULT);
    }

    public BeanProperty(PropertyDescriptor descriptor, ILoadingType loadingType) {
        super(descriptor.getName(), descriptor.getPropertyType(), loadingType);
        Containment annotation;
        Method writeMethod;
        Containment annotation2;
        this.descriptor = descriptor;
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null && (annotation2 = readMethod.getAnnotation(Containment.class)) != null) {
            this.containment = true;
        }
        if ((writeMethod = descriptor.getWriteMethod()) != null && (annotation = writeMethod.getAnnotation(Containment.class)) != null) {
            this.containment = true;
        }
    }

    @Override
    public void setValue(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        Method writeMethod;
        Class<?>[] parameterTypes;
        if (this.descriptor != null && this.descriptor.getWriteMethod() != null && (parameterTypes = (writeMethod = this.descriptor.getWriteMethod()).getParameterTypes()).length == 1) {
            Class<?> type = parameterTypes[0];
            Class<?> propertyType = this.getType();
            if (propertyType != Object.class) {
                type = propertyType;
            }
            if (!ObjectUtil.isAssignableFrom(IBinding.class, propertyType) && value != null && type != value.getClass()) {
                value = ObjectUtil.resolveValue(value, type, value);
            }
            Object oldValue = null;
            Method readMethod = this.descriptor.getReadMethod();
            if (readMethod != null) {
                oldValue = readMethod.invoke(target, new Object[0]);
            }
            if (value == null && type != null && UserData.getWidget(target) != null) {
                if (type == String.class) {
                    value = "";
                } else if (type == Boolean.class) {
                    value = false;
                }
            }
            if (oldValue != value) {
                writeMethod.setAccessible(true);
                try {
                    writeMethod.invoke(target, value);
                    this.fireSetPostAction(target, this, value);
                }
                catch (IllegalArgumentException e) {
                    if (value == null) {
                        throw new XWTException("Property type " + this.getName() + " of " + target.getClass().getName() + " cannot be null.", e);
                    }
                    throw new XWTException("Property type " + this.getName() + " of " + target.getClass().getName() + " is mismatch with " + value.getClass().getName() + " expected type is " + parameterTypes[0].getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new XWTException("Problem of invoke " + this.getName() + " of " + target.getClass().getName() + " with a value of type " + value.getClass().getName(), e);
                }
            }
        }
    }

    @Override
    public Object getValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        if (this.descriptor != null && this.descriptor.getReadMethod() != null) {
            Method readMethod = this.descriptor.getReadMethod();
            readMethod.setAccessible(true);
            return readMethod.invoke(target, new Object[0]);
        }
        return null;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isContainement() {
        return this.containment;
    }

    @Override
    public boolean isReadOnly() {
        return this.descriptor.getWriteMethod() == null;
    }
}

