/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.palette.page;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.palette.Palette;
import org.eclipse.xwt.tools.ui.palette.contribution.PaletteContribution;
import org.eclipse.xwt.tools.ui.palette.page.CustomPalettePage;
import org.eclipse.xwt.tools.ui.palette.page.CustomPaletteViewerProvider;
import org.eclipse.xwt.tools.ui.palette.page.resources.IPaletteResourceProvider;
import org.eclipse.xwt.tools.ui.palette.root.PaletteRootFactory;

public class ContributePalettePage
extends CustomPalettePage {
    public ContributePalettePage(IEditorPart editorPart, EditDomain editDomain) {
        super(new CustomPaletteViewerProvider(editDomain));
        this.createPaletteRoot(editorPart, editDomain);
    }

    private void createPaletteRoot(IEditorPart editorPart, EditDomain editDomain) {
        if (editorPart == null) {
            return;
        }
        if (editDomain == null) {
            editDomain = (EditDomain)editorPart.getAdapter(EditDomain.class);
        }
        if (editDomain == null) {
            editDomain = new DefaultEditDomain(editorPart);
        }
        String editorId = editorPart.getSite().getId();
        PaletteContribution contribution = PaletteContribution.getContribution(editorId);
        List<IPaletteResourceProvider> resourceProviders = contribution.getResourceProviders();
        boolean hasInitialiers = contribution.hasInitialiers();
        if (hasInitialiers) {
            for (IPaletteResourceProvider rp : resourceProviders) {
                Resource res = rp.getPaletteResource();
                if (res == null) continue;
                EList contents = res.getContents();
                for (EObject eObject : contents) {
                    if (!(eObject instanceof Palette)) continue;
                    Palette palette = (Palette)eObject;
                    for (Entry entry : palette.getEntries()) {
                        this.applyInitializer(contribution, entry);
                    }
                }
            }
        }
        Class<? extends Tool> selectionTool = contribution.getSelectionTool();
        Class<? extends Tool> creationTool = contribution.getCreationTool();
        PaletteRootFactory factory = new PaletteRootFactory(resourceProviders, creationTool, selectionTool);
        PaletteRoot paletteRoot = factory.createPaletteRoot();
        editDomain.setPaletteRoot(paletteRoot);
    }

    private void applyInitializer(PaletteContribution contribution, Entry entry) {
        contribution.applyInitializer(entry);
        for (Entry child : entry.getEntries()) {
            this.applyInitializer(contribution, child);
        }
    }
}

