/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.palette.part;

import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.xwt.vex.EditorMessages;
import org.eclipse.xwt.vex.VEXEditor;
import org.eclipse.xwt.vex.palette.PaletteRootFactory;
import org.eclipse.xwt.vex.palette.customize.CustomerPaletteContextMenuProvider;
import org.eclipse.xwt.vex.palette.customize.InvokeType;
import org.eclipse.xwt.vex.palette.customize.dialogs.CustomizePaletteDialog;
import org.eclipse.xwt.vex.palette.part.CustomizePaletteViewer;
import org.eclipse.xwt.vex.palette.part.DynamicPaletteViewer;
import org.eclipse.xwt.vex.palette.part.ToolPaletteViewer;
import org.eclipse.xwt.vex.palette.part.ToolTransferDragSourceListener;
import org.eclipse.xwt.vex.swt.CustomSashForm;
import org.eclipse.xwt.vex.toolpalette.impl.EntryImpl;

public class ToolPaletteViewerProvider
extends PaletteViewerProvider {
    private IEditorPart editorPart;
    private PaletteViewer toolPaletteViewer;
    private DynamicPaletteViewer dynamicPaletteViewer;
    private CustomizePaletteViewer customizePaletteViewer;
    private CustomSashForm sashFormMain;
    private CustomSashForm dynamicAndCustomizeSashForm;
    protected DropTargetListener dropTargetAdapter = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            CustomizePaletteDialog customizeDialog = new CustomizePaletteDialog(InvokeType.DragAdd, null, event.data.toString());
            customizeDialog.open();
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };

    public ToolPaletteViewerProvider(EditDomain graphicalViewerDomain, IEditorPart editorPart) {
        super(graphicalViewerDomain);
        this.editorPart = editorPart;
    }

    public PaletteViewer createPaletteViewer(Composite parent) {
        PageBook pageBook = (PageBook)parent;
        this.sashFormMain = new CustomSashForm((Composite)pageBook, 512);
        CustomSashForm toolSashForm = new CustomSashForm((Composite)this.sashFormMain, 512);
        this.toolPaletteViewer = new ToolPaletteViewer(this.getEditDomain());
        this.toolPaletteViewer.createControl((Composite)toolSashForm);
        this.configurePaletteViewer(this.toolPaletteViewer);
        this.hookPaletteViewer(this.toolPaletteViewer);
        this.dynamicAndCustomizeSashForm = new CustomSashForm((Composite)this.sashFormMain, 512);
        Composite dynamicComposite = new Composite((Composite)this.dynamicAndCustomizeSashForm, 2048);
        dynamicComposite.setLayout((Layout)new FillLayout());
        Composite customizeComposite = new Composite((Composite)this.dynamicAndCustomizeSashForm, 2048);
        customizeComposite.setLayout((Layout)new FillLayout());
        this.dynamicPaletteViewer = new DynamicPaletteViewer();
        this.dynamicPaletteViewer.createControl(dynamicComposite);
        this.configurePaletteViewer(this.dynamicPaletteViewer);
        this.dynamicPaletteViewer.setPaletteRoot(PaletteRootFactory.createDynamicPalette(this.editorPart));
        this.customizePaletteViewer = new CustomizePaletteViewer();
        this.customizePaletteViewer.createControl(customizeComposite);
        this.configurePaletteViewer(this.customizePaletteViewer);
        this.customizePaletteViewer.setPaletteRoot(PaletteRootFactory.createCustomizePalette(this.editorPart));
        DropTarget dropTarget = new DropTarget((Control)customizeComposite, 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dropTarget.setTransfer(types);
        dropTarget.addDropListener(this.dropTargetAdapter);
        this.sashFormMain.setWeights(new int[]{2, 1});
        this.dynamicAndCustomizeSashForm.setWeights(new int[]{1, 1});
        pageBook.showPage((Control)this.sashFormMain);
        this.toolPaletteViewer.setProperty(EditorMessages.CustomizeComponentFactory_VIEWER_EDITOR, (Object)this.editorPart);
        this.toolPaletteViewer.setProperty("Dynamic_PaletteViewer", (Object)this.dynamicPaletteViewer);
        this.toolPaletteViewer.setProperty("Customize_PaletteViewer", (Object)this.customizePaletteViewer);
        this.toolPaletteViewer.setProperty("ToolSashForm", (Object)toolSashForm);
        this.toolPaletteViewer.setProperty("SashFormMain", (Object)this.sashFormMain);
        this.dynamicPaletteViewer.setProperty("DynamicAndCustomizeSashForm", (Object)this.dynamicAndCustomizeSashForm);
        this.dynamicPaletteViewer.setProperty("DynamicComposite", dynamicComposite);
        this.customizePaletteViewer.setProperty("DynamicAndCustomizeSashForm", (Object)this.dynamicAndCustomizeSashForm);
        this.customizePaletteViewer.setProperty("CustomizeComposite", customizeComposite);
        return this.toolPaletteViewer;
    }

    public DynamicPaletteViewer getDynamicPaletteViewer() {
        return this.dynamicPaletteViewer;
    }

    public CustomizePaletteViewer getCustomizePaletteViewer() {
        return this.customizePaletteViewer;
    }

    protected void configurePaletteViewer(final PaletteViewer viewer) {
        viewer.setContextMenu((MenuManager)new CustomerPaletteContextMenuProvider(viewer));
        viewer.addDragSourceListener((TransferDragSourceListener)new ToolTransferDragSourceListener((EditPartViewer)viewer));
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                super.mouseDoubleClick(e);
                List selectedEditParts = viewer.getSelectedEditParts();
                CombinedTemplateCreationEntry selectedEntry = null;
                for (Object object : selectedEditParts) {
                    selectedEntry = (CombinedTemplateCreationEntry)((EditPart)object).getModel();
                }
                EntryImpl entryTemplate = (EntryImpl)selectedEntry.getTemplate();
                IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (activeEditor instanceof VEXEditor) {
                    VEXEditor currentVEXEditor = (VEXEditor)activeEditor;
                    currentVEXEditor.defaultCreation(entryTemplate);
                }
            }
        });
    }
}

