/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xwt.vex.VEXContext;
import org.eclipse.xwt.vex.VEXTextEditorHelper;
import org.eclipse.xwt.vex.toolpalette.ContextType;
import org.eclipse.xwt.vex.toolpalette.Entry;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractContext
implements VEXContext {
    @Override
    public int findDropPosition(Node node, Entry entry, int documentPosition) {
        String scope = entry.getScope();
        ContextType contextType = entry.getContext();
        return this.findDropPosition(node, scope, contextType, documentPosition);
    }

    @Override
    public int findDropPosition(Node node, String scope, ContextType contextType, int cursorPosition) {
        Node parentNode;
        String scopeName;
        IDOMNode treeNode = (IDOMNode)node;
        if (!(scope == null || (scopeName = scope.trim()).length() <= 0 || treeNode.getNodeType() != 3 || (parentNode = treeNode.getParentNode()) != null && this.isKindOf(parentNode, scopeName))) {
            return -1;
        }
        switch (contextType) {
            case XML_ALL: {
                break;
            }
            case XML_ATTRIBUTE: {
                break;
            }
            case XML_ATTRIBUTE_VALUE: {
                ITextRegion completionRegion = VEXTextEditorHelper.getCompletionRegion(cursorPosition, (Node)treeNode);
                String regionType = completionRegion.getType();
                if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                    return treeNode.getStartOffset();
                }
                return -1;
            }
            case NONE: {
                break;
            }
            case XML_NEW: {
                break;
            }
            case XML_TAG: {
                if (treeNode.getNodeType() == 3) {
                    return treeNode.getStartOffset();
                }
                ITextRegion completionRegion = VEXTextEditorHelper.getCompletionRegion(cursorPosition, (Node)treeNode);
                String regionType = completionRegion.getType();
                if (regionType == "XML_PI_CLOSE" || regionType == "XML_PI_OPEN" || regionType == "XML_CONTENT" || regionType == "XML_TAG_OPEN" || regionType == "XML_TAG_CLOSE" || regionType == "XML_TAG_ATTRIBUTE_VALUE" || regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_NAME" || regionType == "XML_END_TAG_OPEN") {
                    IStructuredDocumentRegion endStructuredDocumentRegion;
                    NodeList nodeList = treeNode.getChildNodes();
                    int length = nodeList.getLength();
                    int i = 0;
                    while (i < length) {
                        Node child = nodeList.item(i);
                        if (child.getNodeType() == 3) {
                            return ((IDOMNode)child).getEndOffset();
                        }
                        ++i;
                    }
                    if (regionType == "XML_END_TAG_OPEN" && length == 0 && cursorPosition == (endStructuredDocumentRegion = treeNode.getEndStructuredDocumentRegion()).getStart()) {
                        return cursorPosition;
                    }
                }
                return -1;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return cursorPosition;
    }

    protected abstract boolean isKindOf(Node var1, String var2);
}

