/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.xwt.tools.ui.designer.core.parts.tools.SelectionHandle;

public class NewNonResizeEditPolicy
extends NonResizableEditPolicy {
    private boolean displayNonHandles;

    public NewNonResizeEditPolicy(boolean displayNonHandles) {
        this.displayNonHandles = displayNonHandles;
        this.setDragAllowed(false);
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        GraphicalEditPart host = (GraphicalEditPart)this.getHost();
        if (this.displayNonHandles) {
            if (this.isDragAllowed()) {
                NonResizableHandleKit.addHandles((GraphicalEditPart)host, list);
            } else {
                NonResizableHandleKit.addHandles((GraphicalEditPart)host, list, (DragTracker)new SelectEditPartTracker(this.getHost()), (Cursor)SharedCursors.ARROW);
            }
        } else {
            if (this.isDragAllowed()) {
                NonResizableHandleKit.addMoveHandle((GraphicalEditPart)host, list);
            }
            list.add((Handle)this.createSelectionHandle(host));
        }
        return list;
    }

    protected AbstractHandle createSelectionHandle(GraphicalEditPart host) {
        return new SelectionHandle(host);
    }
}

