/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.layouts.control;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditor;

public class SpinnerFieldEditor
extends FieldEditor {
    private Spinner spinner;
    private int wasSelected = -1;

    public SpinnerFieldEditor(String fieldName, String labelText, Composite parent) {
        super(fieldName, labelText, parent);
    }

    @Override
    protected Control createEditor(Composite parent) {
        Label label = new Label(parent, 0);
        if (this.labelText != null) {
            label.setText(this.labelText);
        }
        this.adapt((Control)label);
        this.spinner = new Spinner(parent, 2048);
        this.spinner.setMinimum(-1);
        this.spinner.setMaximum(9999);
        this.spinner.setLayoutData((Object)new GridData(768));
        this.spinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selection = SpinnerFieldEditor.this.spinner.getSelection();
                SpinnerFieldEditor.this.dispatchEvent(Integer.toString(SpinnerFieldEditor.this.wasSelected), Integer.toString(selection));
                SpinnerFieldEditor.this.wasSelected = selection;
            }
        });
        this.adapt((Control)this.spinner);
        return parent;
    }

    @Override
    protected void update(String value) {
        try {
            this.wasSelected = Integer.parseInt(value);
            this.spinner.setSelection(this.wasSelected);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

