/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.sash;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.xwt.tools.ui.designer.commands.ChangeWeightsCommand;
import org.eclipse.xwt.tools.ui.designer.commands.MoveChildCommand;
import org.eclipse.xwt.tools.ui.designer.core.parts.VisualEditPart;
import org.eclipse.xwt.tools.ui.designer.editor.sash.SashFormChildResizableEditPolicy;
import org.eclipse.xwt.tools.ui.designer.editor.sash.SashFormDeleteCommand;
import org.eclipse.xwt.tools.ui.designer.editor.sash.SashFormInsertCreateCommand;
import org.eclipse.xwt.tools.ui.designer.editor.sash.SashMoveableEditPolicy;
import org.eclipse.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.misc.CompositeEditPartHelper;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class SashFormLayoutEditPolicy
extends FlowLayoutEditPolicy {
    static int WIDTH = 4;
    private Polygon insertionLine;
    private int index = 0;

    protected Command getCreateCommand(CreateRequest request) {
        EditPart reference;
        int i;
        SashFormEditPart host = (SashFormEditPart)this.getHost();
        List<ControlEditPart> children = CompositeEditPartHelper.getChildren(host);
        if (this.index == -1 || children.size() == 0) {
            i = -1;
            reference = null;
        } else {
            boolean after = this.index % 2 != 0;
            i = this.index / 2;
            if (after) {
                ++i;
            }
            reference = (EditPart)children.get(i);
        }
        return new SashFormInsertCreateCommand(this.getHost(), reference, request, i);
    }

    protected Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    protected Polyline getLineFeedback() {
        if (this.insertionLine == null) {
            this.insertionLine = new Polygon();
            this.insertionLine.setLineWidth(WIDTH);
            this.insertionLine.addPoint(new Point(0, 0));
            this.insertionLine.addPoint(new Point(10, 10));
            this.insertionLine.addPoint(new Point(10, 10));
            this.insertionLine.addPoint(new Point(10, 10));
            this.insertionLine.setForegroundColor(ColorConstants.lightBlue);
            this.addFeedback((IFigure)this.insertionLine);
        }
        return this.insertionLine;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.insertionLine != null) {
            this.removeFeedback((IFigure)this.insertionLine);
            this.insertionLine = null;
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
        Point p4;
        Point p3;
        GraphicalEditPart editPart;
        if (!"create child".equals(request.getType())) {
            return;
        }
        Polyline fb = this.getLineFeedback();
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        SashFormEditPart host = (SashFormEditPart)this.getHost();
        List<ControlEditPart> children = CompositeEditPartHelper.getChildren(host);
        Rectangle parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)host));
        if (children.size() == 0) {
            Point p1 = new Point(parentBox.x, parentBox.y);
            p1 = transposer.t(p1);
            Point p2 = new Point(parentBox.x, parentBox.y + parentBox.height);
            p2 = transposer.t(p2);
            Point p32 = new Point(parentBox.x + parentBox.width / 2, parentBox.y + parentBox.height);
            p32 = transposer.t(p32);
            Point p42 = new Point(parentBox.x + parentBox.width / 2, parentBox.y);
            p42 = transposer.t(p42);
            fb.translateToRelative((Translatable)p1);
            fb.setPoint(p1, 0);
            fb.translateToRelative((Translatable)p2);
            fb.setPoint(p2, 1);
            fb.translateToRelative((Translatable)p32);
            fb.setPoint(p32, 2);
            fb.translateToRelative((Translatable)p42);
            fb.setPoint(p42, 3);
            return;
        }
        if (children.size() == 1) {
            Point p1 = new Point(parentBox.x + parentBox.width / 2, parentBox.y);
            p1 = transposer.t(p1);
            Point p2 = new Point(parentBox.x + parentBox.width / 2, parentBox.y + parentBox.height);
            p2 = transposer.t(p2);
            Point p33 = new Point(parentBox.x + parentBox.width, parentBox.y + parentBox.height);
            p33 = transposer.t(p33);
            Point p43 = new Point(parentBox.x + parentBox.width, parentBox.y);
            p43 = transposer.t(p43);
            fb.translateToRelative((Translatable)p1);
            fb.setPoint(p1, 0);
            fb.translateToRelative((Translatable)p2);
            fb.setPoint(p2, 1);
            fb.translateToRelative((Translatable)p33);
            fb.setPoint(p33, 2);
            fb.translateToRelative((Translatable)p43);
            fb.setPoint(p43, 3);
            return;
        }
        boolean before = true;
        int epIndex = this.getFeedbackIndexFor(request);
        Rectangle r = null;
        this.index = epIndex;
        if (epIndex == -1) {
            before = false;
            epIndex = children.size() - 1;
            editPart = (GraphicalEditPart)children.get(epIndex);
            r = transposer.t(this.getAbsoluteBounds(editPart));
        } else {
            editPart = (GraphicalEditPart)children.get(epIndex);
            r = transposer.t(this.getAbsoluteBounds(editPart));
            Point p = transposer.t(this.getLocationFromRequest(request));
            if (p.x <= r.x + r.width / 2) {
                before = true;
            } else {
                before = false;
                editPart = (GraphicalEditPart)children.get(--epIndex);
                r = transposer.t(this.getAbsoluteBounds(editPart));
            }
        }
        int x = Integer.MIN_VALUE;
        if (before) {
            if (epIndex > 0) {
                Rectangle boxPrev = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)children.get(epIndex - 1)));
                int prevRight = boxPrev.right();
                if (prevRight < r.x) {
                    x = prevRight + (r.x - prevRight) / 2;
                } else if (prevRight == r.x) {
                    x = prevRight + 1;
                }
            }
            if (x == Integer.MIN_VALUE && (x = r.x - 5) < parentBox.x) {
                x = parentBox.x + (r.x - parentBox.x) / 2;
            }
        } else {
            int rRight = r.x + r.width;
            x = rRight + 5;
            int pRight = parentBox.x + parentBox.width;
            if (x > pRight) {
                x = rRight + (pRight - rRight) / 2;
            }
        }
        Point p1 = new Point(x, r.y);
        p1 = transposer.t(p1);
        Point p2 = new Point(x, r.y + parentBox.height);
        p2 = transposer.t(p2);
        if (editPart instanceof SashEditPart) {
            if (before) {
                editPart = (GraphicalEditPart)children.get(epIndex - 1);
                before = false;
            } else {
                editPart = (GraphicalEditPart)children.get(epIndex + 1);
            }
        }
        Rectangle sibleBound = transposer.t(this.getAbsoluteBounds(editPart));
        if (before) {
            p3 = new Point(x + sibleBound.width / 2, r.y + parentBox.height);
            p4 = new Point(x + sibleBound.width / 2, r.y);
        } else {
            p3 = new Point(x - sibleBound.width / 2, r.y + parentBox.height);
            p4 = new Point(x - sibleBound.width / 2, r.y);
        }
        p3 = transposer.t(p3);
        p4 = transposer.t(p4);
        fb.translateToRelative((Translatable)p1);
        fb.setPoint(p1, 0);
        fb.translateToRelative((Translatable)p2);
        fb.setPoint(p2, 1);
        fb.translateToRelative((Translatable)p3);
        fb.setPoint(p3, 2);
        fb.translateToRelative((Translatable)p4);
        fb.setPoint(p4, 3);
    }

    private Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        return null;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return new MoveChildCommand(child, after);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof SelectionRequest) {
            SashFormEditPart host = (SashFormEditPart)this.getHost();
            List<ControlEditPart> children = CompositeEditPartHelper.getChildren(host);
            if (children.size() == 0) {
                return null;
            }
            SelectionRequest selectionRequest = (SelectionRequest)request;
            Transposer transposer = new Transposer();
            transposer.setEnabled(!this.isHorizontal());
            Point location = selectionRequest.getLocation().getCopy();
            location = transposer.t(location);
            CreateRequest createRequest = new CreateRequest();
            createRequest.setLocation(selectionRequest.getLocation());
            int index = this.getFeedbackIndexFor((Request)createRequest);
            if (index == -1) {
                return null;
            }
            if (index == 0) {
                return (EditPart)children.get(0);
            }
            GraphicalEditPart reference = (GraphicalEditPart)children.get(index);
            Rectangle bounds = this.getAbsoluteBounds(reference);
            bounds = transposer.t(bounds);
            GraphicalEditPart previousSash = null;
            GraphicalEditPart nextSash = null;
            if (reference instanceof SashEditPart) {
                if (location.x < bounds.x + bounds.width / 2) {
                    nextSash = reference;
                    if (index - 2 < 0) {
                        return reference;
                    }
                    previousSash = (GraphicalEditPart)children.get(index - 2);
                } else {
                    previousSash = reference;
                    if (index + 2 >= children.size()) {
                        return reference;
                    }
                    nextSash = (GraphicalEditPart)children.get(index + 2);
                }
            } else {
                previousSash = (GraphicalEditPart)children.get(index - 1);
                nextSash = (GraphicalEditPart)children.get(index);
            }
            Rectangle previousBounds = this.getAbsoluteBounds(previousSash);
            previousBounds = transposer.t(previousBounds);
            Rectangle nextBounds = this.getAbsoluteBounds(nextSash);
            nextBounds = transposer.t(nextBounds);
            int width = nextBounds.x - previousBounds.x - previousBounds.width;
            if (location.x < previousBounds.x + previousBounds.width + width / 2) {
                return previousSash;
            }
            return nextSash;
        }
        return super.getTargetEditPart(request);
    }

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return this.createChangeBoundsCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getDeleteDependantCommand(GroupRequest request) {
        List editParts = request.getEditParts();
        if (!editParts.isEmpty()) {
            ArrayList<XamlNode> deleteThems = new ArrayList<XamlNode>();
            for (Object object : editParts) {
                if (!(object instanceof VisualEditPart)) continue;
                VisualEditPart part = (VisualEditPart)object;
                deleteThems.add((XamlNode)part.getCastModel());
            }
            if (!deleteThems.isEmpty()) {
                return new SashFormDeleteCommand(deleteThems);
            }
        }
        return super.getDeleteDependantCommand((Request)request);
    }

    protected Command createChangeBoundsCommand(ChangeBoundsRequest request) {
        boolean isChildRequest = true;
        for (Object object : request.getEditParts()) {
            if (!(object instanceof SashFormEditPart)) continue;
            isChildRequest = false;
            break;
        }
        if (isChildRequest) {
            return new ChangeWeightsCommand((SashFormEditPart)this.getHost(), request);
        }
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof SashEditPart) {
            return new SashMoveableEditPolicy((SashEditPart)child);
        }
        List<ControlEditPart> children = CompositeEditPartHelper.getChildren((SashFormEditPart)this.getHost());
        if (children.size() < 2) {
            return new NonResizableEditPolicy();
        }
        int directions = 0;
        directions = this.isHorizontal() ? 24 : 5;
        child.removeEditPolicy((Object)"PrimaryDrag Policy");
        return new SashFormChildResizableEditPolicy(directions, false);
    }

    protected boolean isHorizontal() {
        SashFormEditPart host = (SashFormEditPart)this.getHost();
        return host.isHorizontal();
    }
}

